@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin

import com.pulumi.azurenative.codesigning.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.codesigning.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CertificateProfile].
 */
@PulumiTagMarker
public class CertificateProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateProfileArgs = CertificateProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateProfileArgsBuilder.() -> Unit) {
        val builder = CertificateProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CertificateProfile {
        val builtJavaResource =
            com.pulumi.azurenative.codesigning.CertificateProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CertificateProfile(builtJavaResource)
    }
}

/**
 * Certificate profile resource.
 * Azure REST API version: 2024-02-05-preview.
 * ## Example Usage
 * ### Create a certificate profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateProfile = new AzureNative.CodeSigning.CertificateProfile("certificateProfile", new()
 *     {
 *         AccountName = "MyAccount",
 *         IdentityValidationId = "00000000-1234-5678-3333-444444444444",
 *         IncludePostalCode = true,
 *         IncludeStreetAddress = false,
 *         ProfileName = "profileA",
 *         ProfileType = AzureNative.CodeSigning.ProfileType.PublicTrust,
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/codesigning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codesigning.NewCertificateProfile(ctx, "certificateProfile", &codesigning.CertificateProfileArgs{
 * 			AccountName:          pulumi.String("MyAccount"),
 * 			IdentityValidationId: pulumi.String("00000000-1234-5678-3333-444444444444"),
 * 			IncludePostalCode:    pulumi.Bool(true),
 * 			IncludeStreetAddress: pulumi.Bool(false),
 * 			ProfileName:          pulumi.String("profileA"),
 * 			ProfileType:          pulumi.String(codesigning.ProfileTypePublicTrust),
 * 			ResourceGroupName:    pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.codesigning.CertificateProfile;
 * import com.pulumi.azurenative.codesigning.CertificateProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateProfile = new CertificateProfile("certificateProfile", CertificateProfileArgs.builder()
 *             .accountName("MyAccount")
 *             .identityValidationId("00000000-1234-5678-3333-444444444444")
 *             .includePostalCode(true)
 *             .includeStreetAddress(false)
 *             .profileName("profileA")
 *             .profileType("PublicTrust")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:codesigning:CertificateProfile profileA /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CodeSigning/codeSigningAccounts/{accountName}/certificateProfiles/{profileName}
 * ```
 */
public class CertificateProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.codesigning.CertificateProfile,
) : KotlinCustomResource(javaResource, CertificateProfileMapper) {
    /**
     * Used as L in the certificate subject name.
     */
    public val city: Output<String>
        get() = javaResource.city().applyValue({ args0 -> args0 })

    /**
     * Used as CN in the certificate subject name.
     */
    public val commonName: Output<String>
        get() = javaResource.commonName().applyValue({ args0 -> args0 })

    /**
     * Used as C in the certificate subject name.
     */
    public val country: Output<String>
        get() = javaResource.country().applyValue({ args0 -> args0 })

    /**
     * Enhanced key usage of the certificate.
     */
    public val enhancedKeyUsage: Output<String>
        get() = javaResource.enhancedKeyUsage().applyValue({ args0 -> args0 })

    /**
     * Identity validation id used for the certificate subject name.
     */
    public val identityValidationId: Output<String>?
        get() = javaResource.identityValidationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to include L in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    public val includeCity: Output<Boolean>?
        get() = javaResource.includeCity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to include C in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    public val includeCountry: Output<Boolean>?
        get() = javaResource.includeCountry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to include PC in the certificate subject name.
     */
    public val includePostalCode: Output<Boolean>?
        get() = javaResource.includePostalCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to include S in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    public val includeState: Output<Boolean>?
        get() = javaResource.includeState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to include STREET in the certificate subject name.
     */
    public val includeStreetAddress: Output<Boolean>?
        get() = javaResource.includeStreetAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Used as O in the certificate subject name.
     */
    public val organization: Output<String>
        get() = javaResource.organization().applyValue({ args0 -> args0 })

    /**
     * Used as OU in the private trust certificate subject name.
     */
    public val organizationUnit: Output<String>
        get() = javaResource.organizationUnit().applyValue({ args0 -> args0 })

    /**
     * Used as PC in the certificate subject name.
     */
    public val postalCode: Output<String>
        get() = javaResource.postalCode().applyValue({ args0 -> args0 })

    /**
     * Profile type of the certificate.
     */
    public val profileType: Output<String>
        get() = javaResource.profileType().applyValue({ args0 -> args0 })

    /**
     * Status of the current operation on certificate profile.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Used as S in the certificate subject name.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Status of the certificate profile.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Used as STREET in the certificate subject name.
     */
    public val streetAddress: Output<String>
        get() = javaResource.streetAddress().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CertificateProfileMapper : ResourceMapper<CertificateProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.codesigning.CertificateProfile::class == javaResource::class

    override fun map(javaResource: Resource): CertificateProfile = CertificateProfile(
        javaResource as
            com.pulumi.azurenative.codesigning.CertificateProfile,
    )
}

/**
 * @see [CertificateProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CertificateProfile].
 */
public suspend fun certificateProfile(
    name: String,
    block: suspend CertificateProfileResourceBuilder.() -> Unit,
): CertificateProfile {
    val builder = CertificateProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CertificateProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificateProfile(name: String): CertificateProfile {
    val builder = CertificateProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
