@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin

import com.pulumi.azurenative.codesigning.CertificateProfileArgs.builder
import com.pulumi.azurenative.codesigning.kotlin.enums.ProfileType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Certificate profile resource.
 * Azure REST API version: 2024-02-05-preview.
 * ## Example Usage
 * ### Create a certificate profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateProfile = new AzureNative.CodeSigning.CertificateProfile("certificateProfile", new()
 *     {
 *         AccountName = "MyAccount",
 *         IdentityValidationId = "00000000-1234-5678-3333-444444444444",
 *         IncludePostalCode = true,
 *         IncludeStreetAddress = false,
 *         ProfileName = "profileA",
 *         ProfileType = AzureNative.CodeSigning.ProfileType.PublicTrust,
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/codesigning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codesigning.NewCertificateProfile(ctx, "certificateProfile", &codesigning.CertificateProfileArgs{
 * 			AccountName:          pulumi.String("MyAccount"),
 * 			IdentityValidationId: pulumi.String("00000000-1234-5678-3333-444444444444"),
 * 			IncludePostalCode:    pulumi.Bool(true),
 * 			IncludeStreetAddress: pulumi.Bool(false),
 * 			ProfileName:          pulumi.String("profileA"),
 * 			ProfileType:          pulumi.String(codesigning.ProfileTypePublicTrust),
 * 			ResourceGroupName:    pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.codesigning.CertificateProfile;
 * import com.pulumi.azurenative.codesigning.CertificateProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateProfile = new CertificateProfile("certificateProfile", CertificateProfileArgs.builder()
 *             .accountName("MyAccount")
 *             .identityValidationId("00000000-1234-5678-3333-444444444444")
 *             .includePostalCode(true)
 *             .includeStreetAddress(false)
 *             .profileName("profileA")
 *             .profileType("PublicTrust")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:codesigning:CertificateProfile profileA /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CodeSigning/codeSigningAccounts/{accountName}/certificateProfiles/{profileName}
 * ```
 * @property accountName Trusted Signing account name.
 * @property identityValidationId Identity validation id used for the certificate subject name.
 * @property includeCity Whether to include L in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includeCountry Whether to include C in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includePostalCode Whether to include PC in the certificate subject name.
 * @property includeState Whether to include S in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includeStreetAddress Whether to include STREET in the certificate subject name.
 * @property profileName Certificate profile name.
 * @property profileType Profile type of the certificate.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CertificateProfileArgs(
    public val accountName: Output<String>? = null,
    public val identityValidationId: Output<String>? = null,
    public val includeCity: Output<Boolean>? = null,
    public val includeCountry: Output<Boolean>? = null,
    public val includePostalCode: Output<Boolean>? = null,
    public val includeState: Output<Boolean>? = null,
    public val includeStreetAddress: Output<Boolean>? = null,
    public val profileName: Output<String>? = null,
    public val profileType: Output<Either<String, ProfileType>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.CertificateProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.codesigning.CertificateProfileArgs =
        com.pulumi.azurenative.codesigning.CertificateProfileArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identityValidationId(identityValidationId?.applyValue({ args0 -> args0 }))
            .includeCity(includeCity?.applyValue({ args0 -> args0 }))
            .includeCountry(includeCountry?.applyValue({ args0 -> args0 }))
            .includePostalCode(includePostalCode?.applyValue({ args0 -> args0 }))
            .includeState(includeState?.applyValue({ args0 -> args0 }))
            .includeStreetAddress(includeStreetAddress?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .profileType(
                profileType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateProfileArgs].
 */
@PulumiTagMarker
public class CertificateProfileArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identityValidationId: Output<String>? = null

    private var includeCity: Output<Boolean>? = null

    private var includeCountry: Output<Boolean>? = null

    private var includePostalCode: Output<Boolean>? = null

    private var includeState: Output<Boolean>? = null

    private var includeStreetAddress: Output<Boolean>? = null

    private var profileName: Output<String>? = null

    private var profileType: Output<Either<String, ProfileType>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("ldfxtfacmgcugbeb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Identity validation id used for the certificate subject name.
     */
    @JvmName("yvhbaxjyndvygqno")
    public suspend fun identityValidationId(`value`: Output<String>) {
        this.identityValidationId = value
    }

    /**
     * @param value Whether to include L in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("gwaaorjddimcmrjs")
    public suspend fun includeCity(`value`: Output<Boolean>) {
        this.includeCity = value
    }

    /**
     * @param value Whether to include C in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("yakqvxcehackwmly")
    public suspend fun includeCountry(`value`: Output<Boolean>) {
        this.includeCountry = value
    }

    /**
     * @param value Whether to include PC in the certificate subject name.
     */
    @JvmName("wxjqorpdlovqxvic")
    public suspend fun includePostalCode(`value`: Output<Boolean>) {
        this.includePostalCode = value
    }

    /**
     * @param value Whether to include S in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("kyehdqbdcloupvns")
    public suspend fun includeState(`value`: Output<Boolean>) {
        this.includeState = value
    }

    /**
     * @param value Whether to include STREET in the certificate subject name.
     */
    @JvmName("moodtbcgichvshpt")
    public suspend fun includeStreetAddress(`value`: Output<Boolean>) {
        this.includeStreetAddress = value
    }

    /**
     * @param value Certificate profile name.
     */
    @JvmName("byyscimrmaudmumy")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Profile type of the certificate.
     */
    @JvmName("egwowbruiqfjooaf")
    public suspend fun profileType(`value`: Output<Either<String, ProfileType>>) {
        this.profileType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ojccuqoyrylncevq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("hbktxllrvuurjmct")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Identity validation id used for the certificate subject name.
     */
    @JvmName("sqrwqfhqpjjfxxmx")
    public suspend fun identityValidationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityValidationId = mapped
    }

    /**
     * @param value Whether to include L in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("mwaiibrwujcrwfyc")
    public suspend fun includeCity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeCity = mapped
    }

    /**
     * @param value Whether to include C in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("mtkdocjjxhwdilhr")
    public suspend fun includeCountry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeCountry = mapped
    }

    /**
     * @param value Whether to include PC in the certificate subject name.
     */
    @JvmName("xowltemstqccmsgb")
    public suspend fun includePostalCode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includePostalCode = mapped
    }

    /**
     * @param value Whether to include S in the certificate subject name. Applicable only for private trust, private trust ci profile types
     */
    @JvmName("esxaejshsgqqqtxb")
    public suspend fun includeState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeState = mapped
    }

    /**
     * @param value Whether to include STREET in the certificate subject name.
     */
    @JvmName("ptpxjrjsqpllstrl")
    public suspend fun includeStreetAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeStreetAddress = mapped
    }

    /**
     * @param value Certificate profile name.
     */
    @JvmName("ndwmceqwltwnrijr")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Profile type of the certificate.
     */
    @JvmName("jbofvhplbetjwpnx")
    public suspend fun profileType(`value`: Either<String, ProfileType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileType = mapped
    }

    /**
     * @param value Profile type of the certificate.
     */
    @JvmName("lwfkkhoomysifqyq")
    public fun profileType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProfileType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileType = mapped
    }

    /**
     * @param value Profile type of the certificate.
     */
    @JvmName("eieyntfjxslcldos")
    public fun profileType(`value`: ProfileType) {
        val toBeMapped = Either.ofRight<String, ProfileType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tiftiqswimbtwfbp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CertificateProfileArgs = CertificateProfileArgs(
        accountName = accountName,
        identityValidationId = identityValidationId,
        includeCity = includeCity,
        includeCountry = includeCountry,
        includePostalCode = includePostalCode,
        includeState = includeState,
        includeStreetAddress = includeStreetAddress,
        profileName = profileName,
        profileType = profileType,
        resourceGroupName = resourceGroupName,
    )
}
