@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin

import com.pulumi.azurenative.codesigning.CodeSigningAccountArgs.builder
import com.pulumi.azurenative.codesigning.kotlin.inputs.AccountSkuArgs
import com.pulumi.azurenative.codesigning.kotlin.inputs.AccountSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Trusted signing account resource.
 * Azure REST API version: 2024-02-05-preview.
 * ## Example Usage
 * ### Create a trusted Signing Account.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var codeSigningAccount = new AzureNative.CodeSigning.CodeSigningAccount("codeSigningAccount", new()
 *     {
 *         AccountName = "MyAccount",
 *         Location = "westus",
 *         ResourceGroupName = "MyResourceGroup",
 *         Sku = new AzureNative.CodeSigning.Inputs.AccountSkuArgs
 *         {
 *             Name = AzureNative.CodeSigning.SkuName.Basic,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/codesigning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codesigning.NewCodeSigningAccount(ctx, "codeSigningAccount", &codesigning.CodeSigningAccountArgs{
 * 			AccountName:       pulumi.String("MyAccount"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Sku: &codesigning.AccountSkuArgs{
 * 				Name: pulumi.String(codesigning.SkuNameBasic),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.codesigning.CodeSigningAccount;
 * import com.pulumi.azurenative.codesigning.CodeSigningAccountArgs;
 * import com.pulumi.azurenative.codesigning.inputs.AccountSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var codeSigningAccount = new CodeSigningAccount("codeSigningAccount", CodeSigningAccountArgs.builder()
 *             .accountName("MyAccount")
 *             .location("westus")
 *             .resourceGroupName("MyResourceGroup")
 *             .sku(AccountSkuArgs.builder()
 *                 .name("Basic")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:codesigning:CodeSigningAccount MyAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CodeSigning/codeSigningAccounts/{accountName}
 * ```
 * @property accountName Trusted Signing account name.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku SKU of the trusted signing account.
 * @property tags Resource tags.
 */
public data class CodeSigningAccountArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<AccountSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.CodeSigningAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.codesigning.CodeSigningAccountArgs =
        com.pulumi.azurenative.codesigning.CodeSigningAccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CodeSigningAccountArgs].
 */
@PulumiTagMarker
public class CodeSigningAccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<AccountSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("agveglomjaikmslx")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lfuuqdnsdciuqwrj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kcehrofnfckvbgol")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU of the trusted signing account.
     */
    @JvmName("ddiydjcprkxueaga")
    public suspend fun sku(`value`: Output<AccountSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hfoywaslexrywsca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("xsaoevtmbromqgkp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("njumbhfdjosruryp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkxdgfheryewapxg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU of the trusted signing account.
     */
    @JvmName("sewheaiqyocxqvcs")
    public suspend fun sku(`value`: AccountSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the trusted signing account.
     */
    @JvmName("ufgdipeylqihsomx")
    public suspend fun sku(argument: suspend AccountSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AccountSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jksiedsehrbqcyvc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lnsgcgkvxsdvtpmc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CodeSigningAccountArgs = CodeSigningAccountArgs(
        accountName = accountName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
