@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.inputs

import com.pulumi.azurenative.codesigning.inputs.AccountSkuArgs.builder
import com.pulumi.azurenative.codesigning.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of the trusted signing account.
 * @property name Name of the SKU.
 */
public data class AccountSkuArgs(
    public val name: Output<Either<String, SkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.inputs.AccountSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.codesigning.inputs.AccountSkuArgs =
        com.pulumi.azurenative.codesigning.inputs.AccountSkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountSkuArgs].
 */
@PulumiTagMarker
public class AccountSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value Name of the SKU.
     */
    @JvmName("hbiimehauourcpnh")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value Name of the SKU.
     */
    @JvmName("wobmjqaadarqevyn")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the SKU.
     */
    @JvmName("wehrxlkmndwqjgko")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the SKU.
     */
    @JvmName("hgvdnvltjdilxkpn")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AccountSkuArgs = AccountSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
