@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.inputs

import com.pulumi.azurenative.codesigning.inputs.GetCertificateProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Trusted Signing account name.
 * @property profileName Certificate profile name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCertificateProfilePlainArgs(
    public val accountName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.inputs.GetCertificateProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.codesigning.inputs.GetCertificateProfilePlainArgs =
        com.pulumi.azurenative.codesigning.inputs.GetCertificateProfilePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificateProfilePlainArgs].
 */
@PulumiTagMarker
public class GetCertificateProfilePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("qesjfhfjooajldca")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Certificate profile name.
     */
    @JvmName("mtugufuaossyluwc")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pvaupmplxbornbgf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCertificateProfilePlainArgs = GetCertificateProfilePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
