@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getAccountPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getCommitmentPlanAssociationPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getCommitmentPlanPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getDeploymentPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getEncryptionScopePlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getRaiBlocklistItemPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getRaiBlocklistPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getRaiPolicyPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.getSharedCommitmentPlanPlain
import com.pulumi.azurenative.cognitiveservices.CognitiveservicesFunctions.listAccountKeysPlain
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetCommitmentPlanAssociationPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetCommitmentPlanAssociationPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetCommitmentPlanPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetCommitmentPlanPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetDeploymentPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetDeploymentPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetEncryptionScopePlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetEncryptionScopePlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiBlocklistItemPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiBlocklistItemPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiBlocklistPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiBlocklistPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiPolicyPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetRaiPolicyPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetSharedCommitmentPlanPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.GetSharedCommitmentPlanPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.ListAccountKeysPlainArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.ListAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetCommitmentPlanAssociationResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetCommitmentPlanResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetDeploymentResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetEncryptionScopeResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiBlocklistItemResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiBlocklistResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiPolicyResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetSharedCommitmentPlanResult
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.ListAccountKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetCommitmentPlanAssociationResult.Companion.toKotlin as getCommitmentPlanAssociationResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetCommitmentPlanResult.Companion.toKotlin as getCommitmentPlanResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetDeploymentResult.Companion.toKotlin as getDeploymentResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetEncryptionScopeResult.Companion.toKotlin as getEncryptionScopeResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiBlocklistItemResult.Companion.toKotlin as getRaiBlocklistItemResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiBlocklistResult.Companion.toKotlin as getRaiBlocklistResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetRaiPolicyResult.Companion.toKotlin as getRaiPolicyResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.GetSharedCommitmentPlanResult.Companion.toKotlin as getSharedCommitmentPlanResultToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.ListAccountKeysResult.Companion.toKotlin as listAccountKeysResultToKotlin

public object CognitiveservicesFunctions {
    /**
     * Returns a Cognitive Services account specified by the parameters.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-04-18, 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of Cognitive Services account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified commitmentPlans associated with the Cognitive Services account.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services account commitment plan.
     */
    public suspend fun getCommitmentPlan(argument: GetCommitmentPlanPlainArgs):
        GetCommitmentPlanResult =
        getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(argument.toJava()).await())

    /**
     * @see [getCommitmentPlan].
     * @param accountName The name of Cognitive Services account.
     * @param commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services account commitment plan.
     */
    public suspend fun getCommitmentPlan(
        accountName: String,
        commitmentPlanName: String,
        resourceGroupName: String,
    ): GetCommitmentPlanResult {
        val argument = GetCommitmentPlanPlainArgs(
            accountName = accountName,
            commitmentPlanName = commitmentPlanName,
            resourceGroupName = resourceGroupName,
        )
        return getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommitmentPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetCommitmentPlanPlainArgs].
     * @return Cognitive Services account commitment plan.
     */
    public suspend
    fun getCommitmentPlan(argument: suspend GetCommitmentPlanPlainArgsBuilder.() -> Unit):
        GetCommitmentPlanResult {
        val builder = GetCommitmentPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the association of the Cognitive Services commitment plan.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return The commitment plan association.
     */
    public suspend fun getCommitmentPlanAssociation(argument: GetCommitmentPlanAssociationPlainArgs):
        GetCommitmentPlanAssociationResult =
        getCommitmentPlanAssociationResultToKotlin(getCommitmentPlanAssociationPlain(argument.toJava()).await())

    /**
     * @see [getCommitmentPlanAssociation].
     * @param commitmentPlanAssociationName The name of the commitment plan association with the Cognitive Services Account
     * @param commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The commitment plan association.
     */
    public suspend fun getCommitmentPlanAssociation(
        commitmentPlanAssociationName: String,
        commitmentPlanName: String,
        resourceGroupName: String,
    ): GetCommitmentPlanAssociationResult {
        val argument = GetCommitmentPlanAssociationPlainArgs(
            commitmentPlanAssociationName = commitmentPlanAssociationName,
            commitmentPlanName = commitmentPlanName,
            resourceGroupName = resourceGroupName,
        )
        return getCommitmentPlanAssociationResultToKotlin(getCommitmentPlanAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommitmentPlanAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetCommitmentPlanAssociationPlainArgs].
     * @return The commitment plan association.
     */
    public suspend
    fun getCommitmentPlanAssociation(argument: suspend GetCommitmentPlanAssociationPlainArgsBuilder.() -> Unit):
        GetCommitmentPlanAssociationResult {
        val builder = GetCommitmentPlanAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommitmentPlanAssociationResultToKotlin(getCommitmentPlanAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified deployments associated with the Cognitive Services account.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services account deployment.
     */
    public suspend fun getDeployment(argument: GetDeploymentPlainArgs): GetDeploymentResult =
        getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getDeployment].
     * @param accountName The name of Cognitive Services account.
     * @param deploymentName The name of the deployment associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services account deployment.
     */
    public suspend fun getDeployment(
        accountName: String,
        deploymentName: String,
        resourceGroupName: String,
    ): GetDeploymentResult {
        val argument = GetDeploymentPlainArgs(
            accountName = accountName,
            deploymentName = deploymentName,
            resourceGroupName = resourceGroupName,
        )
        return getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetDeploymentPlainArgs].
     * @return Cognitive Services account deployment.
     */
    public suspend fun getDeployment(argument: suspend GetDeploymentPlainArgsBuilder.() -> Unit):
        GetDeploymentResult {
        val builder = GetDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentResultToKotlin(getDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified EncryptionScope associated with the Cognitive Services account.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services EncryptionScope
     */
    public suspend fun getEncryptionScope(argument: GetEncryptionScopePlainArgs):
        GetEncryptionScopeResult =
        getEncryptionScopeResultToKotlin(getEncryptionScopePlain(argument.toJava()).await())

    /**
     * @see [getEncryptionScope].
     * @param accountName The name of Cognitive Services account.
     * @param encryptionScopeName The name of the encryptionScope associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services EncryptionScope
     */
    public suspend fun getEncryptionScope(
        accountName: String,
        encryptionScopeName: String,
        resourceGroupName: String,
    ): GetEncryptionScopeResult {
        val argument = GetEncryptionScopePlainArgs(
            accountName = accountName,
            encryptionScopeName = encryptionScopeName,
            resourceGroupName = resourceGroupName,
        )
        return getEncryptionScopeResultToKotlin(getEncryptionScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getEncryptionScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetEncryptionScopePlainArgs].
     * @return Cognitive Services EncryptionScope
     */
    public suspend
    fun getEncryptionScope(argument: suspend GetEncryptionScopePlainArgsBuilder.() -> Unit):
        GetEncryptionScopeResult {
        val builder = GetEncryptionScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEncryptionScopeResultToKotlin(getEncryptionScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the Cognitive Services account.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName The name of Cognitive Services account.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified custom blocklist associated with the Azure OpenAI account.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services RaiBlocklist.
     */
    public suspend fun getRaiBlocklist(argument: GetRaiBlocklistPlainArgs): GetRaiBlocklistResult =
        getRaiBlocklistResultToKotlin(getRaiBlocklistPlain(argument.toJava()).await())

    /**
     * @see [getRaiBlocklist].
     * @param accountName The name of Cognitive Services account.
     * @param raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services RaiBlocklist.
     */
    public suspend fun getRaiBlocklist(
        accountName: String,
        raiBlocklistName: String,
        resourceGroupName: String,
    ): GetRaiBlocklistResult {
        val argument = GetRaiBlocklistPlainArgs(
            accountName = accountName,
            raiBlocklistName = raiBlocklistName,
            resourceGroupName = resourceGroupName,
        )
        return getRaiBlocklistResultToKotlin(getRaiBlocklistPlain(argument.toJava()).await())
    }

    /**
     * @see [getRaiBlocklist].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetRaiBlocklistPlainArgs].
     * @return Cognitive Services RaiBlocklist.
     */
    public suspend fun getRaiBlocklist(argument: suspend GetRaiBlocklistPlainArgsBuilder.() -> Unit):
        GetRaiBlocklistResult {
        val builder = GetRaiBlocklistPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRaiBlocklistResultToKotlin(getRaiBlocklistPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified custom blocklist Item associated with the custom blocklist.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services RaiBlocklist Item.
     */
    public suspend fun getRaiBlocklistItem(argument: GetRaiBlocklistItemPlainArgs):
        GetRaiBlocklistItemResult =
        getRaiBlocklistItemResultToKotlin(getRaiBlocklistItemPlain(argument.toJava()).await())

    /**
     * @see [getRaiBlocklistItem].
     * @param accountName The name of Cognitive Services account.
     * @param raiBlocklistItemName The name of the RaiBlocklist Item associated with the custom blocklist
     * @param raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services RaiBlocklist Item.
     */
    public suspend fun getRaiBlocklistItem(
        accountName: String,
        raiBlocklistItemName: String,
        raiBlocklistName: String,
        resourceGroupName: String,
    ): GetRaiBlocklistItemResult {
        val argument = GetRaiBlocklistItemPlainArgs(
            accountName = accountName,
            raiBlocklistItemName = raiBlocklistItemName,
            raiBlocklistName = raiBlocklistName,
            resourceGroupName = resourceGroupName,
        )
        return getRaiBlocklistItemResultToKotlin(getRaiBlocklistItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getRaiBlocklistItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetRaiBlocklistItemPlainArgs].
     * @return Cognitive Services RaiBlocklist Item.
     */
    public suspend
    fun getRaiBlocklistItem(argument: suspend GetRaiBlocklistItemPlainArgsBuilder.() -> Unit):
        GetRaiBlocklistItemResult {
        val builder = GetRaiBlocklistItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRaiBlocklistItemResultToKotlin(getRaiBlocklistItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Content Filters associated with the Azure OpenAI account.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services RaiPolicy.
     */
    public suspend fun getRaiPolicy(argument: GetRaiPolicyPlainArgs): GetRaiPolicyResult =
        getRaiPolicyResultToKotlin(getRaiPolicyPlain(argument.toJava()).await())

    /**
     * @see [getRaiPolicy].
     * @param accountName The name of Cognitive Services account.
     * @param raiPolicyName The name of the RaiPolicy associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services RaiPolicy.
     */
    public suspend fun getRaiPolicy(
        accountName: String,
        raiPolicyName: String,
        resourceGroupName: String,
    ): GetRaiPolicyResult {
        val argument = GetRaiPolicyPlainArgs(
            accountName = accountName,
            raiPolicyName = raiPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getRaiPolicyResultToKotlin(getRaiPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getRaiPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetRaiPolicyPlainArgs].
     * @return Cognitive Services RaiPolicy.
     */
    public suspend fun getRaiPolicy(argument: suspend GetRaiPolicyPlainArgsBuilder.() -> Unit):
        GetRaiPolicyResult {
        val builder = GetRaiPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRaiPolicyResultToKotlin(getRaiPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a Cognitive Services commitment plan specified by the parameters.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Cognitive Services account commitment plan.
     */
    public suspend fun getSharedCommitmentPlan(argument: GetSharedCommitmentPlanPlainArgs):
        GetSharedCommitmentPlanResult =
        getSharedCommitmentPlanResultToKotlin(getSharedCommitmentPlanPlain(argument.toJava()).await())

    /**
     * @see [getSharedCommitmentPlan].
     * @param commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cognitive Services account commitment plan.
     */
    public suspend fun getSharedCommitmentPlan(commitmentPlanName: String, resourceGroupName: String):
        GetSharedCommitmentPlanResult {
        val argument = GetSharedCommitmentPlanPlainArgs(
            commitmentPlanName = commitmentPlanName,
            resourceGroupName = resourceGroupName,
        )
        return getSharedCommitmentPlanResultToKotlin(getSharedCommitmentPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getSharedCommitmentPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;GetSharedCommitmentPlanPlainArgs].
     * @return Cognitive Services account commitment plan.
     */
    public suspend
    fun getSharedCommitmentPlan(argument: suspend GetSharedCommitmentPlanPlainArgsBuilder.() -> Unit):
        GetSharedCommitmentPlanResult {
        val builder = GetSharedCommitmentPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSharedCommitmentPlanResultToKotlin(getSharedCommitmentPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the account keys for the specified Cognitive Services account.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-04-18, 2023-10-01-preview.
     * @param argument null
     * @return The access keys for the cognitive services account.
     */
    public suspend fun listAccountKeys(argument: ListAccountKeysPlainArgs): ListAccountKeysResult =
        listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listAccountKeys].
     * @param accountName The name of Cognitive Services account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The access keys for the cognitive services account.
     */
    public suspend fun listAccountKeys(accountName: String, resourceGroupName: String):
        ListAccountKeysResult {
        val argument = ListAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cognitiveservices&#46;kotlin&#46;inputs&#46;ListAccountKeysPlainArgs].
     * @return The access keys for the cognitive services account.
     */
    public suspend fun listAccountKeys(argument: suspend ListAccountKeysPlainArgsBuilder.() -> Unit):
        ListAccountKeysResult {
        val builder = ListAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountKeysResultToKotlin(listAccountKeysPlain(builtArgument.toJava()).await())
    }
}
