@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.CommitmentPlanPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.CommitmentPlanPropertiesArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services account commitment plan.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### PutCommitmentPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var commitmentPlan = new AzureNative.CognitiveServices.CommitmentPlan("commitmentPlan", new()
 *     {
 *         AccountName = "accountName",
 *         CommitmentPlanName = "commitmentPlanName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.CommitmentPlanPropertiesArgs
 *         {
 *             AutoRenew = true,
 *             Current = new AzureNative.CognitiveServices.Inputs.CommitmentPeriodArgs
 *             {
 *                 Tier = "T1",
 *             },
 *             HostingModel = AzureNative.CognitiveServices.HostingModel.Web,
 *             PlanType = "Speech2Text",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewCommitmentPlan(ctx, "commitmentPlan", &cognitiveservices.CommitmentPlanArgs{
 * 			AccountName:        pulumi.String("accountName"),
 * 			CommitmentPlanName: pulumi.String("commitmentPlanName"),
 * 			Properties: &cognitiveservices.CommitmentPlanPropertiesArgs{
 * 				AutoRenew: pulumi.Bool(true),
 * 				Current: &cognitiveservices.CommitmentPeriodArgs{
 * 					Tier: pulumi.String("T1"),
 * 				},
 * 				HostingModel: pulumi.String(cognitiveservices.HostingModelWeb),
 * 				PlanType:     pulumi.String("Speech2Text"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlan;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var commitmentPlan = new CommitmentPlan("commitmentPlan", CommitmentPlanArgs.builder()
 *             .accountName("accountName")
 *             .commitmentPlanName("commitmentPlanName")
 *             .properties(CommitmentPlanPropertiesArgs.builder()
 *                 .autoRenew(true)
 *                 .current(CommitmentPeriodArgs.builder()
 *                     .tier("T1")
 *                     .build())
 *                 .hostingModel("Web")
 *                 .planType("Speech2Text")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:CommitmentPlan commitmentPlanName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/commitmentPlans/{commitmentPlanName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property kind The Kind of the resource.
 * @property location The geo-location where the resource lives
 * @property properties Properties of Cognitive Services account commitment plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The resource model definition representing SKU
 * @property tags Resource tags.
 */
public data class CommitmentPlanArgs(
    public val accountName: Output<String>? = null,
    public val commitmentPlanName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CommitmentPlanPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs =
        com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .commitmentPlanName(commitmentPlanName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CommitmentPlanArgs].
 */
@PulumiTagMarker
public class CommitmentPlanArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var commitmentPlanName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CommitmentPlanPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("cpexjsdrckpguwvr")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("cubwwywsgkowpjwx")
    public suspend fun commitmentPlanName(`value`: Output<String>) {
        this.commitmentPlanName = value
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("tgyffkjmvwslhhsk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fxgyojbmgsfaqlqn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Cognitive Services account commitment plan.
     */
    @JvmName("ilbfajiaftwvaoxr")
    public suspend fun properties(`value`: Output<CommitmentPlanPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("deeqvfrwcpidaday")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("nunkvsninbpxxlbe")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("acfyjolksgnqcgbu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("pidhehbvcavenuwx")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("vjbwxrsatyvnashd")
    public suspend fun commitmentPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("dtuavfqvyovfdpkb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lxadqrjtlppteqxu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Cognitive Services account commitment plan.
     */
    @JvmName("fgimwfpxsrfbwbak")
    public suspend fun properties(`value`: CommitmentPlanPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account commitment plan.
     */
    @JvmName("miblvjiowobrmgpy")
    public suspend fun properties(argument: suspend CommitmentPlanPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CommitmentPlanPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rqnnwgvrxqekgccr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("pqtyackpltfwoyfm")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The resource model definition representing SKU
     */
    @JvmName("qymchdkvuubqtbha")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qxysvfqldrhvhxyr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tkumawfipipwsbrd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CommitmentPlanArgs = CommitmentPlanArgs(
        accountName = accountName,
        commitmentPlanName = commitmentPlanName,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
