@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The commitment plan association.
 * Azure REST API version: 2023-05-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### PutCommitmentPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var commitmentPlanAssociation = new AzureNative.CognitiveServices.CommitmentPlanAssociation("commitmentPlanAssociation", new()
 *     {
 *         AccountId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName",
 *         CommitmentPlanAssociationName = "commitmentPlanAssociationName",
 *         CommitmentPlanName = "commitmentPlanName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewCommitmentPlanAssociation(ctx, "commitmentPlanAssociation", &cognitiveservices.CommitmentPlanAssociationArgs{
 * 			AccountId:                     pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName"),
 * 			CommitmentPlanAssociationName: pulumi.String("commitmentPlanAssociationName"),
 * 			CommitmentPlanName:            pulumi.String("commitmentPlanName"),
 * 			ResourceGroupName:             pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var commitmentPlanAssociation = new CommitmentPlanAssociation("commitmentPlanAssociation", CommitmentPlanAssociationArgs.builder()
 *             .accountId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName")
 *             .commitmentPlanAssociationName("commitmentPlanAssociationName")
 *             .commitmentPlanName("commitmentPlanName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:CommitmentPlanAssociation commitmentPlanAssociationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/commitmentPlans/{commitmentPlanName}/accountAssociations/{commitmentPlanAssociationName}
 * ```
 * @property accountId The Azure resource id of the account.
 * @property commitmentPlanAssociationName The name of the commitment plan association with the Cognitive Services Account
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CommitmentPlanAssociationArgs(
    public val accountId: Output<String>? = null,
    public val commitmentPlanAssociationName: Output<String>? = null,
    public val commitmentPlanName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs =
        com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .commitmentPlanAssociationName(commitmentPlanAssociationName?.applyValue({ args0 -> args0 }))
            .commitmentPlanName(commitmentPlanName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommitmentPlanAssociationArgs].
 */
@PulumiTagMarker
public class CommitmentPlanAssociationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var commitmentPlanAssociationName: Output<String>? = null

    private var commitmentPlanName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Azure resource id of the account.
     */
    @JvmName("rfifdlcqkcthltxn")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The name of the commitment plan association with the Cognitive Services Account
     */
    @JvmName("nkmtswtleffrrjkc")
    public suspend fun commitmentPlanAssociationName(`value`: Output<String>) {
        this.commitmentPlanAssociationName = value
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("rqcqbfhjoaenmbkm")
    public suspend fun commitmentPlanName(`value`: Output<String>) {
        this.commitmentPlanName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iecbvtltqoyrybfl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Azure resource id of the account.
     */
    @JvmName("syvnmvhicebiwaul")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The name of the commitment plan association with the Cognitive Services Account
     */
    @JvmName("uduunwumcncnmkbf")
    public suspend fun commitmentPlanAssociationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanAssociationName = mapped
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("pmsrwqbrmwocupng")
    public suspend fun commitmentPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hgxselxkyjkdelpa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CommitmentPlanAssociationArgs = CommitmentPlanAssociationArgs(
        accountId = accountId,
        commitmentPlanAssociationName = commitmentPlanAssociationName,
        commitmentPlanName = commitmentPlanName,
        resourceGroupName = resourceGroupName,
    )
}
