@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.DeploymentArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cognitive Services account deployment.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### PutDeployment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.CognitiveServices.Deployment("deployment", new()
 *     {
 *         AccountName = "accountName",
 *         DeploymentName = "deploymentName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.DeploymentPropertiesArgs
 *         {
 *             Model = new AzureNative.CognitiveServices.Inputs.DeploymentModelArgs
 *             {
 *                 Format = "OpenAI",
 *                 Name = "ada",
 *                 Version = "1",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewDeployment(ctx, "deployment", &cognitiveservices.DeploymentArgs{
 * 			AccountName:    pulumi.String("accountName"),
 * 			DeploymentName: pulumi.String("deploymentName"),
 * 			Properties: &cognitiveservices.DeploymentPropertiesArgs{
 * 				Model: &cognitiveservices.DeploymentModelArgs{
 * 					Format:  pulumi.String("OpenAI"),
 * 					Name:    pulumi.String("ada"),
 * 					Version: pulumi.String("1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Deployment;
 * import com.pulumi.azurenative.cognitiveservices.DeploymentArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.DeploymentPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.DeploymentModelArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .accountName("accountName")
 *             .deploymentName("deploymentName")
 *             .properties(DeploymentPropertiesArgs.builder()
 *                 .model(DeploymentModelArgs.builder()
 *                     .format("OpenAI")
 *                     .name("ada")
 *                     .version("1")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:Deployment deploymentName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/deployments/{deploymentName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property deploymentName The name of the deployment associated with the Cognitive Services Account
 * @property properties Properties of Cognitive Services account deployment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The resource model definition representing SKU
 */
public data class DeploymentArgs(
    public val accountName: Output<String>? = null,
    public val deploymentName: Output<String>? = null,
    public val properties: Output<DeploymentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.DeploymentArgs =
        com.pulumi.azurenative.cognitiveservices.DeploymentArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var deploymentName: Output<String>? = null

    private var properties: Output<DeploymentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("hhgqxjblypfxkbfq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the deployment associated with the Cognitive Services Account
     */
    @JvmName("vniteorjljjcrnub")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Properties of Cognitive Services account deployment.
     */
    @JvmName("ljmtjmnpxmduwity")
    public suspend fun properties(`value`: Output<DeploymentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hfeaxibavkiwwjfj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("pltqhxyncvbpdrkb")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("eegjuwiukvpjsubx")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the deployment associated with the Cognitive Services Account
     */
    @JvmName("xmcecpoyqlywjmjx")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value Properties of Cognitive Services account deployment.
     */
    @JvmName("skreonvvfxgyeywd")
    public suspend fun properties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account deployment.
     */
    @JvmName("bceumsmnoxybocdy")
    public suspend fun properties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("umfjbxukidlrcdkn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("expbafyhuexrsbvg")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The resource model definition representing SKU
     */
    @JvmName("wrngsgifscvohekm")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        accountName = accountName,
        deploymentName = deploymentName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
    )
}
