@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.RaiBlocklistArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiBlocklistPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiBlocklistPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services RaiBlocklist.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutRaiBlocklist
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiBlocklist = new AzureNative.CognitiveServices.RaiBlocklist("raiBlocklist", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiBlocklistPropertiesArgs
 *         {
 *             Description = "Basic blocklist description",
 *         },
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiBlocklist(ctx, "raiBlocklist", &cognitiveservices.RaiBlocklistArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiBlocklistPropertiesArgs{
 * 				Description: pulumi.String("Basic blocklist description"),
 * 			},
 * 			RaiBlocklistName:  pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklist;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklistArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiBlocklist = new RaiBlocklist("raiBlocklist", RaiBlocklistArgs.builder()
 *             .accountName("accountName")
 *             .properties(RaiBlocklistPropertiesArgs.builder()
 *                 .description("Basic blocklist description")
 *                 .build())
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiBlocklist raiBlocklistName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiBlocklists/{raiBlocklistName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property properties Properties of Cognitive Services RaiBlocklist.
 * @property raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class RaiBlocklistArgs(
    public val accountName: Output<String>? = null,
    public val properties: Output<RaiBlocklistPropertiesArgs>? = null,
    public val raiBlocklistName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.RaiBlocklistArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.RaiBlocklistArgs =
        com.pulumi.azurenative.cognitiveservices.RaiBlocklistArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiBlocklistName(raiBlocklistName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RaiBlocklistArgs].
 */
@PulumiTagMarker
public class RaiBlocklistArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var properties: Output<RaiBlocklistPropertiesArgs>? = null

    private var raiBlocklistName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("qbaukmsgtgtquexp")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Properties of Cognitive Services RaiBlocklist.
     */
    @JvmName("rntryjfpvbgjwteh")
    public suspend fun properties(`value`: Output<RaiBlocklistPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("frwunajiftqvhpbg")
    public suspend fun raiBlocklistName(`value`: Output<String>) {
        this.raiBlocklistName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wcuudsboiutyjfmd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fbmyqthwlhjnccxn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("fskwlftawfjalhmj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Properties of Cognitive Services RaiBlocklist.
     */
    @JvmName("xhrnwglxemtuudkf")
    public suspend fun properties(`value`: RaiBlocklistPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services RaiBlocklist.
     */
    @JvmName("rmleatjudqyrcniw")
    public suspend fun properties(argument: suspend RaiBlocklistPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiBlocklistPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("uuenfnasuaiarvub")
    public suspend fun raiBlocklistName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pyuquajxsgqdhagh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogpdiulitvojswij")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("crrnjimxmajktyrn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RaiBlocklistArgs = RaiBlocklistArgs(
        accountName = accountName,
        properties = properties,
        raiBlocklistName = raiBlocklistName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
