@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiBlocklistItemPropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiBlocklistItemPropertiesResponse.Companion.toKotlin as raiBlocklistItemPropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RaiBlocklistItem].
 */
@PulumiTagMarker
public class RaiBlocklistItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RaiBlocklistItemArgs = RaiBlocklistItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RaiBlocklistItemArgsBuilder.() -> Unit) {
        val builder = RaiBlocklistItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RaiBlocklistItem {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RaiBlocklistItem(builtJavaResource)
    }
}

/**
 * Cognitive Services RaiBlocklist Item.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutRaiBlocklistItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiBlocklistItem = new AzureNative.CognitiveServices.RaiBlocklistItem("raiBlocklistItem", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiBlocklistItemPropertiesArgs
 *         {
 *             IsRegex = false,
 *             Pattern = "Pattern To Block",
 *         },
 *         RaiBlocklistItemName = "raiBlocklistItemName",
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiBlocklistItem(ctx, "raiBlocklistItem", &cognitiveservices.RaiBlocklistItemArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiBlocklistItemPropertiesArgs{
 * 				IsRegex: pulumi.Bool(false),
 * 				Pattern: pulumi.String("Pattern To Block"),
 * 			},
 * 			RaiBlocklistItemName: pulumi.String("raiBlocklistItemName"),
 * 			RaiBlocklistName:     pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName:    pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistItemPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiBlocklistItem = new RaiBlocklistItem("raiBlocklistItem", RaiBlocklistItemArgs.builder()
 *             .accountName("accountName")
 *             .properties(RaiBlocklistItemPropertiesArgs.builder()
 *                 .isRegex(false)
 *                 .pattern("Pattern To Block")
 *                 .build())
 *             .raiBlocklistItemName("raiBlocklistItemName")
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiBlocklistItem raiBlocklistItemName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiBlocklists/{raiBlocklistName}/raiBlocklistItems/{raiBlocklistItemName}
 * ```
 */
public class RaiBlocklistItem internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem,
) : KotlinCustomResource(javaResource, RaiBlocklistItemMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services RaiBlocklist Item.
     */
    public val properties: Output<RaiBlocklistItemPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                raiBlocklistItemPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RaiBlocklistItemMapper : ResourceMapper<RaiBlocklistItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem::class == javaResource::class

    override fun map(javaResource: Resource): RaiBlocklistItem = RaiBlocklistItem(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem,
    )
}

/**
 * @see [RaiBlocklistItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RaiBlocklistItem].
 */
public suspend fun raiBlocklistItem(
    name: String,
    block: suspend RaiBlocklistItemResourceBuilder.() -> Unit,
): RaiBlocklistItem {
    val builder = RaiBlocklistItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RaiBlocklistItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun raiBlocklistItem(name: String): RaiBlocklistItem {
    val builder = RaiBlocklistItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
