@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiPolicyPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiPolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services RaiPolicy.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutRaiPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiPolicy = new AzureNative.CognitiveServices.RaiPolicy("raiPolicy", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiPolicyPropertiesArgs
 *         {
 *             BasePolicyName = "112",
 *             ContentFilters = new[]
 *             {
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Low,
 *                     Blocking = true,
 *                     Name = "hate",
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Low,
 *                     Name = "sexual",
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Enabled = false,
 *                     Name = "violence",
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Enabled = false,
 *                     Name = "DefaultHateSpeechBlockList",
 *                 },
 *             },
 *         },
 *         RaiPolicyName = "raiPolicyName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiPolicy(ctx, "raiPolicy", &cognitiveservices.RaiPolicyArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiPolicyPropertiesArgs{
 * 				BasePolicyName: pulumi.String("112"),
 * 				ContentFilters: cognitiveservices.RaiPolicyContentFilterArray{
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelLow),
 * 						Blocking:            pulumi.Bool(true),
 * 						Name:                pulumi.String("hate"),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelLow),
 * 						Name:                pulumi.String("sexual"),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Enabled: pulumi.Bool(false),
 * 						Name:    pulumi.String("violence"),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Enabled: pulumi.Bool(false),
 * 						Name:    pulumi.String("DefaultHateSpeechBlockList"),
 * 					},
 * 				},
 * 			},
 * 			RaiPolicyName:     pulumi.String("raiPolicyName"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicy;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiPolicy = new RaiPolicy("raiPolicy", RaiPolicyArgs.builder()
 *             .accountName("accountName")
 *             .properties(RaiPolicyPropertiesArgs.builder()
 *                 .basePolicyName("112")
 *                 .contentFilters(
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Low")
 *                         .blocking(true)
 *                         .name("hate")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Low")
 *                         .name("sexual")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .enabled(false)
 *                         .name("violence")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .enabled(false)
 *                         .name("DefaultHateSpeechBlockList")
 *                         .build())
 *                 .build())
 *             .raiPolicyName("raiPolicyName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiPolicy raiPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiPolicies/{raiPolicyName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property properties Properties of Cognitive Services RaiPolicy.
 * @property raiPolicyName The name of the RaiPolicy associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class RaiPolicyArgs(
    public val accountName: Output<String>? = null,
    public val properties: Output<RaiPolicyPropertiesArgs>? = null,
    public val raiPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs =
        com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiPolicyName(raiPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyArgs].
 */
@PulumiTagMarker
public class RaiPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var properties: Output<RaiPolicyPropertiesArgs>? = null

    private var raiPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("iubskvyuqaiicwca")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("xieviapbjkbksqww")
    public suspend fun properties(`value`: Output<RaiPolicyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the RaiPolicy associated with the Cognitive Services Account
     */
    @JvmName("ivhdwimshppwtbfi")
    public suspend fun raiPolicyName(`value`: Output<String>) {
        this.raiPolicyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iquiiqykumlsishj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oyndqbmysqlgqxek")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("gwwkioakiawjxjdw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("bcqgxseoqeogovvh")
    public suspend fun properties(`value`: RaiPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("iusfxayrydtggbhh")
    public suspend fun properties(argument: suspend RaiPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the RaiPolicy associated with the Cognitive Services Account
     */
    @JvmName("yoopqbqqcggumdqm")
    public suspend fun raiPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("haejtqjrxvfyuues")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gxuhhvpfnekorwyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qhktyqsxwoofkwur")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RaiPolicyArgs = RaiPolicyArgs(
        accountName = accountName,
        properties = properties,
        raiPolicyName = raiPolicyName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
