@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlanArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.CommitmentPlanPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.CommitmentPlanPropertiesArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services account commitment plan.
 * Azure REST API version: 2023-05-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create Commitment Plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sharedCommitmentPlan = new AzureNative.CognitiveServices.SharedCommitmentPlan("sharedCommitmentPlan", new()
 *     {
 *         CommitmentPlanName = "commitmentPlanName",
 *         Kind = "SpeechServices",
 *         Location = "West US",
 *         Properties = new AzureNative.CognitiveServices.Inputs.CommitmentPlanPropertiesArgs
 *         {
 *             AutoRenew = true,
 *             Current = new AzureNative.CognitiveServices.Inputs.CommitmentPeriodArgs
 *             {
 *                 Tier = "T1",
 *             },
 *             HostingModel = AzureNative.CognitiveServices.HostingModel.Web,
 *             PlanType = "STT",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewSharedCommitmentPlan(ctx, "sharedCommitmentPlan", &cognitiveservices.SharedCommitmentPlanArgs{
 * 			CommitmentPlanName: pulumi.String("commitmentPlanName"),
 * 			Kind:               pulumi.String("SpeechServices"),
 * 			Location:           pulumi.String("West US"),
 * 			Properties: &cognitiveservices.CommitmentPlanPropertiesArgs{
 * 				AutoRenew: pulumi.Bool(true),
 * 				Current: &cognitiveservices.CommitmentPeriodArgs{
 * 					Tier: pulumi.String("T1"),
 * 				},
 * 				HostingModel: pulumi.String(cognitiveservices.HostingModelWeb),
 * 				PlanType:     pulumi.String("STT"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlan;
 * import com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlanArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sharedCommitmentPlan = new SharedCommitmentPlan("sharedCommitmentPlan", SharedCommitmentPlanArgs.builder()
 *             .commitmentPlanName("commitmentPlanName")
 *             .kind("SpeechServices")
 *             .location("West US")
 *             .properties(CommitmentPlanPropertiesArgs.builder()
 *                 .autoRenew(true)
 *                 .current(CommitmentPeriodArgs.builder()
 *                     .tier("T1")
 *                     .build())
 *                 .hostingModel("Web")
 *                 .planType("STT")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:SharedCommitmentPlan commitmentPlanName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/commitmentPlans/{commitmentPlanName}
 * ```
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property kind The Kind of the resource.
 * @property location The geo-location where the resource lives
 * @property properties Properties of Cognitive Services account commitment plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The resource model definition representing SKU
 * @property tags Resource tags.
 */
public data class SharedCommitmentPlanArgs(
    public val commitmentPlanName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CommitmentPlanPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlanArgs =
        com.pulumi.azurenative.cognitiveservices.SharedCommitmentPlanArgs.builder()
            .commitmentPlanName(commitmentPlanName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SharedCommitmentPlanArgs].
 */
@PulumiTagMarker
public class SharedCommitmentPlanArgsBuilder internal constructor() {
    private var commitmentPlanName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CommitmentPlanPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("rbwdbfqurncooihr")
    public suspend fun commitmentPlanName(`value`: Output<String>) {
        this.commitmentPlanName = value
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("hrbhffumprpxnkke")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ayndpmunstawdbxf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Cognitive Services account commitment plan.
     */
    @JvmName("oxwjertndmydjoax")
    public suspend fun properties(`value`: Output<CommitmentPlanPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("khhubtksncvktmvj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("epbuphcaouwyjork")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nqvhcwcwcgohrlsw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("dqgdqgpcgvuawjep")
    public suspend fun commitmentPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("eylorfpfjokdelyx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hnumyxvjbnuypgup")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Cognitive Services account commitment plan.
     */
    @JvmName("gpqyonroniliphvj")
    public suspend fun properties(`value`: CommitmentPlanPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account commitment plan.
     */
    @JvmName("rjvhvibmihnktlht")
    public suspend fun properties(argument: suspend CommitmentPlanPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CommitmentPlanPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yyftgwipqtdiedkw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("itueoeqliwgwnfov")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The resource model definition representing SKU
     */
    @JvmName("fdqololwoddlgote")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ypvbnhiyvtmjcwyv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("canxlnnfcnwqguqj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SharedCommitmentPlanArgs = SharedCommitmentPlanArgs(
        commitmentPlanName = commitmentPlanName,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
