@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.HostingModel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of Cognitive Services account commitment plan.
 * @property autoRenew AutoRenew commitment plan.
 * @property commitmentPlanGuid Commitment plan guid.
 * @property current Cognitive Services account commitment period.
 * @property hostingModel Account hosting model.
 * @property next Cognitive Services account commitment period.
 * @property planType Commitment plan type.
 */
public data class CommitmentPlanPropertiesArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val commitmentPlanGuid: Output<String>? = null,
    public val current: Output<CommitmentPeriodArgs>? = null,
    public val hostingModel: Output<Either<String, HostingModel>>? = null,
    public val next: Output<CommitmentPeriodArgs>? = null,
    public val planType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .commitmentPlanGuid(commitmentPlanGuid?.applyValue({ args0 -> args0 }))
            .current(current?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostingModel(
                hostingModel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .next(next?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .planType(planType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommitmentPlanPropertiesArgs].
 */
@PulumiTagMarker
public class CommitmentPlanPropertiesArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var commitmentPlanGuid: Output<String>? = null

    private var current: Output<CommitmentPeriodArgs>? = null

    private var hostingModel: Output<Either<String, HostingModel>>? = null

    private var next: Output<CommitmentPeriodArgs>? = null

    private var planType: Output<String>? = null

    /**
     * @param value AutoRenew commitment plan.
     */
    @JvmName("bvmlibaeuenfstjt")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Commitment plan guid.
     */
    @JvmName("liowfiqcpjasvtec")
    public suspend fun commitmentPlanGuid(`value`: Output<String>) {
        this.commitmentPlanGuid = value
    }

    /**
     * @param value Cognitive Services account commitment period.
     */
    @JvmName("knggnyhfcgscxprq")
    public suspend fun current(`value`: Output<CommitmentPeriodArgs>) {
        this.current = value
    }

    /**
     * @param value Account hosting model.
     */
    @JvmName("ggensxwbvjcuspfh")
    public suspend fun hostingModel(`value`: Output<Either<String, HostingModel>>) {
        this.hostingModel = value
    }

    /**
     * @param value Cognitive Services account commitment period.
     */
    @JvmName("jnyjiettgesepvsg")
    public suspend fun next(`value`: Output<CommitmentPeriodArgs>) {
        this.next = value
    }

    /**
     * @param value Commitment plan type.
     */
    @JvmName("vmccnqjcgocmbslp")
    public suspend fun planType(`value`: Output<String>) {
        this.planType = value
    }

    /**
     * @param value AutoRenew commitment plan.
     */
    @JvmName("yqrvyhqpedviapng")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Commitment plan guid.
     */
    @JvmName("hgilwkhsfawmjefa")
    public suspend fun commitmentPlanGuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlanGuid = mapped
    }

    /**
     * @param value Cognitive Services account commitment period.
     */
    @JvmName("vegdmefabtmcfrkn")
    public suspend fun current(`value`: CommitmentPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.current = mapped
    }

    /**
     * @param argument Cognitive Services account commitment period.
     */
    @JvmName("cjshwlbfyyyqsjrw")
    public suspend fun current(argument: suspend CommitmentPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = CommitmentPeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.current = mapped
    }

    /**
     * @param value Account hosting model.
     */
    @JvmName("irgusjlpkrgldkqi")
    public suspend fun hostingModel(`value`: Either<String, HostingModel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostingModel = mapped
    }

    /**
     * @param value Account hosting model.
     */
    @JvmName("uchtvsgsmgswhehc")
    public fun hostingModel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostingModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostingModel = mapped
    }

    /**
     * @param value Account hosting model.
     */
    @JvmName("nghrdlduuotkchno")
    public fun hostingModel(`value`: HostingModel) {
        val toBeMapped = Either.ofRight<String, HostingModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostingModel = mapped
    }

    /**
     * @param value Cognitive Services account commitment period.
     */
    @JvmName("stwbmbgxaluqtult")
    public suspend fun next(`value`: CommitmentPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.next = mapped
    }

    /**
     * @param argument Cognitive Services account commitment period.
     */
    @JvmName("jpgtdbxbybgpgufo")
    public suspend fun next(argument: suspend CommitmentPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = CommitmentPeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.next = mapped
    }

    /**
     * @param value Commitment plan type.
     */
    @JvmName("unxwwnahhpqecpwe")
    public suspend fun planType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planType = mapped
    }

    internal fun build(): CommitmentPlanPropertiesArgs = CommitmentPlanPropertiesArgs(
        autoRenew = autoRenew,
        commitmentPlanGuid = commitmentPlanGuid,
        current = current,
        hostingModel = hostingModel,
        next = next,
        planType = planType,
    )
}
