@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.MultiRegionSettingsArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.RoutingMethods
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The multiregion settings Cognitive Services account.
 * @property regions
 * @property routingMethod Multiregion routing methods.
 */
public data class MultiRegionSettingsArgs(
    public val regions: Output<List<RegionSettingArgs>>? = null,
    public val routingMethod: Output<Either<String, RoutingMethods>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.MultiRegionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.MultiRegionSettingsArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.MultiRegionSettingsArgs.builder()
            .regions(
                regions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .routingMethod(
                routingMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MultiRegionSettingsArgs].
 */
@PulumiTagMarker
public class MultiRegionSettingsArgsBuilder internal constructor() {
    private var regions: Output<List<RegionSettingArgs>>? = null

    private var routingMethod: Output<Either<String, RoutingMethods>>? = null

    /**
     * @param value
     */
    @JvmName("grtempeitguiggvl")
    public suspend fun regions(`value`: Output<List<RegionSettingArgs>>) {
        this.regions = value
    }

    @JvmName("fvwrbkpkqvhjefry")
    public suspend fun regions(vararg values: Output<RegionSettingArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("uloveyuogwycqwke")
    public suspend fun regions(values: List<Output<RegionSettingArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value Multiregion routing methods.
     */
    @JvmName("ddswtoiacworaqii")
    public suspend fun routingMethod(`value`: Output<Either<String, RoutingMethods>>) {
        this.routingMethod = value
    }

    /**
     * @param value
     */
    @JvmName("ormmcfjndgxalrqs")
    public suspend fun regions(`value`: List<RegionSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lvuafgpsswsahqui")
    public suspend fun regions(argument: List<suspend RegionSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegionSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vhbeudtraxpetlmv")
    public suspend fun regions(vararg argument: suspend RegionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegionSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hhmlahgbjguqiwkx")
    public suspend fun regions(argument: suspend RegionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RegionSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("aolwfvwiaohmvbyf")
    public suspend fun regions(vararg values: RegionSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value Multiregion routing methods.
     */
    @JvmName("qhfancefqnwnwxvg")
    public suspend fun routingMethod(`value`: Either<String, RoutingMethods>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingMethod = mapped
    }

    /**
     * @param value Multiregion routing methods.
     */
    @JvmName("fqnvnqcjrsifkuax")
    public fun routingMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingMethods>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingMethod = mapped
    }

    /**
     * @param value Multiregion routing methods.
     */
    @JvmName("lrubxpidtofiddbr")
    public fun routingMethod(`value`: RoutingMethods) {
        val toBeMapped = Either.ofRight<String, RoutingMethods>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingMethod = mapped
    }

    internal fun build(): MultiRegionSettingsArgs = MultiRegionSettingsArgs(
        regions = regions,
        routingMethod = routingMethod,
    )
}
