@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure OpenAI blocklist config.
 * @property blocking If blocking would occur.
 * @property blocklistName Name of ContentFilter.
 */
public data class RaiBlocklistConfigArgs(
    public val blocking: Output<Boolean>? = null,
    public val blocklistName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistConfigArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistConfigArgs.builder()
            .blocking(blocking?.applyValue({ args0 -> args0 }))
            .blocklistName(blocklistName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RaiBlocklistConfigArgs].
 */
@PulumiTagMarker
public class RaiBlocklistConfigArgsBuilder internal constructor() {
    private var blocking: Output<Boolean>? = null

    private var blocklistName: Output<String>? = null

    /**
     * @param value If blocking would occur.
     */
    @JvmName("mrkdmrhjweanbfah")
    public suspend fun blocking(`value`: Output<Boolean>) {
        this.blocking = value
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("jnmdmbybhffansbw")
    public suspend fun blocklistName(`value`: Output<String>) {
        this.blocklistName = value
    }

    /**
     * @param value If blocking would occur.
     */
    @JvmName("yxduripwlftdquur")
    public suspend fun blocking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blocking = mapped
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("ehocbkyjxwdiasjq")
    public suspend fun blocklistName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blocklistName = mapped
    }

    internal fun build(): RaiBlocklistConfigArgs = RaiBlocklistConfigArgs(
        blocking = blocking,
        blocklistName = blocklistName,
    )
}
