@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule governing the accessibility from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 * @property ignoreMissingVnetServiceEndpoint Ignore missing vnet service endpoint or not.
 * @property state Gets the state of virtual network rule.
 */
public data class VirtualNetworkRuleArgs(
    public val id: Output<String>,
    public val ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.VirtualNetworkRuleArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .ignoreMissingVnetServiceEndpoint(ignoreMissingVnetServiceEndpoint?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null

    private var state: Output<String>? = null

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("xyauwhgctporlxkk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Ignore missing vnet service endpoint or not.
     */
    @JvmName("fgphovwbfjhuygod")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Output<Boolean>) {
        this.ignoreMissingVnetServiceEndpoint = value
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("gtcbtsxqcodbepwd")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("ghufumwicwjauvvc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Ignore missing vnet service endpoint or not.
     */
    @JvmName("cdygqdscmpjvcprq")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMissingVnetServiceEndpoint = mapped
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("xlnikjrlujofexas")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        ignoreMissingVnetServiceEndpoint = ignoreMissingVnetServiceEndpoint,
        state = state,
    )
}
