@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The api properties for special APIs.
 * @property aadClientId (Metrics Advisor Only) The Azure AD Client Id (Application Id).
 * @property aadTenantId (Metrics Advisor Only) The Azure AD Tenant Id.
 * @property eventHubConnectionString (Personalization Only) The flag to enable statistics of Bing Search.
 * @property qnaAzureSearchEndpointId (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
 * @property qnaAzureSearchEndpointKey (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
 * @property qnaRuntimeEndpoint (QnAMaker Only) The runtime endpoint of QnAMaker.
 * @property statisticsEnabled (Bing Search Only) The flag to enable statistics of Bing Search.
 * @property storageAccountConnectionString (Personalization Only) The storage account connection string.
 * @property superUser (Metrics Advisor Only) The super user of Metrics Advisor.
 * @property websiteName (Metrics Advisor Only) The website name of Metrics Advisor.
 */
public data class ApiPropertiesResponse(
    public val aadClientId: String? = null,
    public val aadTenantId: String? = null,
    public val eventHubConnectionString: String? = null,
    public val qnaAzureSearchEndpointId: String? = null,
    public val qnaAzureSearchEndpointKey: String? = null,
    public val qnaRuntimeEndpoint: String? = null,
    public val statisticsEnabled: Boolean? = null,
    public val storageAccountConnectionString: String? = null,
    public val superUser: String? = null,
    public val websiteName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.ApiPropertiesResponse):
            ApiPropertiesResponse = ApiPropertiesResponse(
            aadClientId = javaType.aadClientId().map({ args0 -> args0 }).orElse(null),
            aadTenantId = javaType.aadTenantId().map({ args0 -> args0 }).orElse(null),
            eventHubConnectionString = javaType.eventHubConnectionString().map({ args0 -> args0 }).orElse(null),
            qnaAzureSearchEndpointId = javaType.qnaAzureSearchEndpointId().map({ args0 -> args0 }).orElse(null),
            qnaAzureSearchEndpointKey = javaType.qnaAzureSearchEndpointKey().map({ args0 ->
                args0
            }).orElse(null),
            qnaRuntimeEndpoint = javaType.qnaRuntimeEndpoint().map({ args0 -> args0 }).orElse(null),
            statisticsEnabled = javaType.statisticsEnabled().map({ args0 -> args0 }).orElse(null),
            storageAccountConnectionString = javaType.storageAccountConnectionString().map({ args0 ->
                args0
            }).orElse(null),
            superUser = javaType.superUser().map({ args0 -> args0 }).orElse(null),
            websiteName = javaType.websiteName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
