@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of Cognitive Services account deployment model.
 * @property activeCapacity Deployment active capacity. This value might be different from `capacity` if customer recently updated `capacity`.
 * @property capacity Deployment capacity.
 * @property scaleType Deployment scale type.
 */
public data class DeploymentScaleSettingsResponse(
    public val activeCapacity: Int,
    public val capacity: Int? = null,
    public val scaleType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.DeploymentScaleSettingsResponse):
            DeploymentScaleSettingsResponse = DeploymentScaleSettingsResponse(
            activeCapacity = javaType.activeCapacity(),
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            scaleType = javaType.scaleType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
