@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The access keys for the cognitive services account.
 * @property key1 Gets the value of key 1.
 * @property key2 Gets the value of key 2.
 */
public data class ListAccountKeysResult(
    public val key1: String? = null,
    public val key2: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.ListAccountKeysResult):
            ListAccountKeysResult = ListAccountKeysResult(
            key1 = javaType.key1().map({ args0 -> args0 }).orElse(null),
            key2 = javaType.key2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
