@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CommunicationService].
 */
@PulumiTagMarker
public class CommunicationServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommunicationServiceArgs = CommunicationServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommunicationServiceArgsBuilder.() -> Unit) {
        val builder = CommunicationServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommunicationService {
        val builtJavaResource =
            com.pulumi.azurenative.communication.CommunicationService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommunicationService(builtJavaResource)
    }
}

/**
 * A class representing a CommunicationService resource.
 * Azure REST API version: 2023-03-31. Prior API version in Azure Native 1.x: 2020-08-20.
 * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communicationService = new AzureNative.Communication.CommunicationService("communicationService", new()
 *     {
 *         CommunicationServiceName = "MyCommunicationResource",
 *         DataLocation = "United States",
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewCommunicationService(ctx, "communicationService", &communication.CommunicationServiceArgs{
 * 			CommunicationServiceName: pulumi.String("MyCommunicationResource"),
 * 			DataLocation:             pulumi.String("United States"),
 * 			Location:                 pulumi.String("Global"),
 * 			ResourceGroupName:        pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.CommunicationService;
 * import com.pulumi.azurenative.communication.CommunicationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communicationService = new CommunicationService("communicationService", CommunicationServiceArgs.builder()
 *             .communicationServiceName("MyCommunicationResource")
 *             .dataLocation("United States")
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:CommunicationService MyCommunicationResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/communicationServices/{communicationServiceName}
 * ```
 */
public class CommunicationService internal constructor(
    override val javaResource: com.pulumi.azurenative.communication.CommunicationService,
) : KotlinCustomResource(javaResource, CommunicationServiceMapper) {
    /**
     * The location where the communication service stores its data at rest.
     */
    public val dataLocation: Output<String>
        get() = javaResource.dataLocation().applyValue({ args0 -> args0 })

    /**
     * FQDN of the CommunicationService instance.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The immutable resource Id of the communication service.
     */
    public val immutableResourceId: Output<String>
        get() = javaResource.immutableResourceId().applyValue({ args0 -> args0 })

    /**
     * List of email Domain resource Ids.
     */
    public val linkedDomains: Output<List<String>>?
        get() = javaResource.linkedDomains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource ID of an Azure Notification Hub linked to this resource.
     */
    public val notificationHubId: Output<String>
        get() = javaResource.notificationHubId().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object CommunicationServiceMapper : ResourceMapper<CommunicationService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.communication.CommunicationService::class == javaResource::class

    override fun map(javaResource: Resource): CommunicationService = CommunicationService(
        javaResource
            as com.pulumi.azurenative.communication.CommunicationService,
    )
}

/**
 * @see [CommunicationService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommunicationService].
 */
public suspend fun communicationService(
    name: String,
    block: suspend CommunicationServiceResourceBuilder.() -> Unit,
): CommunicationService {
    val builder = CommunicationServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommunicationService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun communicationService(name: String): CommunicationService {
    val builder = CommunicationServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
