@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationRecords
import com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationStates
import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationRecords.Companion.toKotlin as domainPropertiesResponseVerificationRecordsToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationStates.Companion.toKotlin as domainPropertiesResponseVerificationStatesToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.azurenative.communication.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * A class representing a Domains resource.
 * Azure REST API version: 2023-03-31. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2022-07-01-preview, 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update Domains resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.Communication.Domain("domain", new()
 *     {
 *         DomainManagement = AzureNative.Communication.DomainManagement.CustomerManaged,
 *         DomainName = "mydomain.com",
 *         EmailServiceName = "MyEmailServiceResource",
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewDomain(ctx, "domain", &communication.DomainArgs{
 * 			DomainManagement:  pulumi.String(communication.DomainManagementCustomerManaged),
 * 			DomainName:        pulumi.String("mydomain.com"),
 * 			EmailServiceName:  pulumi.String("MyEmailServiceResource"),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.Domain;
 * import com.pulumi.azurenative.communication.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainManagement("CustomerManaged")
 *             .domainName("mydomain.com")
 *             .emailServiceName("MyEmailServiceResource")
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:Domain mydomain.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.azurenative.communication.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The location where the Domains resource data is stored at rest.
     */
    public val dataLocation: Output<String>
        get() = javaResource.dataLocation().applyValue({ args0 -> args0 })

    /**
     * Describes how a Domains resource is being managed.
     */
    public val domainManagement: Output<String>
        get() = javaResource.domainManagement().applyValue({ args0 -> args0 })

    /**
     * P2 sender domain that is displayed to the email recipients [RFC 5322].
     */
    public val fromSenderDomain: Output<String>
        get() = javaResource.fromSenderDomain().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * P1 sender domain that is present on the email envelope [RFC 5321].
     */
    public val mailFromSenderDomain: Output<String>
        get() = javaResource.mailFromSenderDomain().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Describes whether user engagement tracking is enabled or disabled.
     */
    public val userEngagementTracking: Output<String>?
        get() = javaResource.userEngagementTracking().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of DnsRecord
     */
    public val verificationRecords: Output<DomainPropertiesResponseVerificationRecords>
        get() = javaResource.verificationRecords().applyValue({ args0 ->
            args0.let({ args0 ->
                domainPropertiesResponseVerificationRecordsToKotlin(args0)
            })
        })

    /**
     * List of VerificationStatusRecord
     */
    public val verificationStates: Output<DomainPropertiesResponseVerificationStates>
        get() = javaResource.verificationStates().applyValue({ args0 ->
            args0.let({ args0 ->
                domainPropertiesResponseVerificationStatesToKotlin(args0)
            })
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.communication.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.azurenative.communication.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
