@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SenderUsername].
 */
@PulumiTagMarker
public class SenderUsernameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SenderUsernameArgs = SenderUsernameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SenderUsernameArgsBuilder.() -> Unit) {
        val builder = SenderUsernameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SenderUsername {
        val builtJavaResource =
            com.pulumi.azurenative.communication.SenderUsername(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SenderUsername(builtJavaResource)
    }
}

/**
 * A class representing a SenderUsername resource.
 * Azure REST API version: 2023-03-31.
 * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update SenderUsernames resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var senderUsername = new AzureNative.Communication.SenderUsername("senderUsername", new()
 *     {
 *         DisplayName = "Contoso News Alerts",
 *         DomainName = "contoso.com",
 *         EmailServiceName = "contosoEmailService",
 *         ResourceGroupName = "contosoResourceGroup",
 *         SenderUsername = "contosoNewsAlerts",
 *         Username = "contosoNewsAlerts",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewSenderUsername(ctx, "senderUsername", &communication.SenderUsernameArgs{
 * 			DisplayName:       pulumi.String("Contoso News Alerts"),
 * 			DomainName:        pulumi.String("contoso.com"),
 * 			EmailServiceName:  pulumi.String("contosoEmailService"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			SenderUsername:    pulumi.String("contosoNewsAlerts"),
 * 			Username:          pulumi.String("contosoNewsAlerts"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.SenderUsername;
 * import com.pulumi.azurenative.communication.SenderUsernameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var senderUsername = new SenderUsername("senderUsername", SenderUsernameArgs.builder()
 *             .displayName("Contoso News Alerts")
 *             .domainName("contoso.com")
 *             .emailServiceName("contosoEmailService")
 *             .resourceGroupName("contosoResourceGroup")
 *             .senderUsername("contosoNewsAlerts")
 *             .username("contosoNewsAlerts")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:SenderUsername contoso.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/senderUsernames/{senderUsername}
 * ```
 */
public class SenderUsername internal constructor(
    override val javaResource: com.pulumi.azurenative.communication.SenderUsername,
) : KotlinCustomResource(javaResource, SenderUsernameMapper) {
    /**
     * The location where the SenderUsername resource data is stored at rest.
     */
    public val dataLocation: Output<String>
        get() = javaResource.dataLocation().applyValue({ args0 -> args0 })

    /**
     * The display name for the senderUsername.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource. Unknown is the default state for Communication Services.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A sender senderUsername to be used when sending emails.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object SenderUsernameMapper : ResourceMapper<SenderUsername> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.communication.SenderUsername::class == javaResource::class

    override fun map(javaResource: Resource): SenderUsername = SenderUsername(
        javaResource as
            com.pulumi.azurenative.communication.SenderUsername,
    )
}

/**
 * @see [SenderUsername].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SenderUsername].
 */
public suspend fun senderUsername(
    name: String,
    block: suspend SenderUsernameResourceBuilder.() -> Unit,
): SenderUsername {
    val builder = SenderUsernameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SenderUsername].
 * @param name The _unique_ name of the resulting resource.
 */
public fun senderUsername(name: String): SenderUsername {
    val builder = SenderUsernameResourceBuilder()
    builder.name(name)
    return builder.build()
}
