@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.GetEmailServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEmailServicePlainArgs(
    public val emailServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.communication.inputs.GetEmailServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.inputs.GetEmailServicePlainArgs =
        com.pulumi.azurenative.communication.inputs.GetEmailServicePlainArgs.builder()
            .emailServiceName(emailServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEmailServicePlainArgs].
 */
@PulumiTagMarker
public class GetEmailServicePlainArgsBuilder internal constructor() {
    private var emailServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("ncpjlslcamtcsikh")
    public suspend fun emailServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iaynaftmxauwotra")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEmailServicePlainArgs = GetEmailServicePlainArgs(
        emailServiceName = emailServiceName ?: throw PulumiNullFieldException("emailServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
