@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.GetSuppressionListAddressPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addressId The id of the address in a suppression list.
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property suppressionListName The name of the suppression list.
 */
public data class GetSuppressionListAddressPlainArgs(
    public val addressId: String,
    public val domainName: String,
    public val emailServiceName: String,
    public val resourceGroupName: String,
    public val suppressionListName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.communication.inputs.GetSuppressionListAddressPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.communication.inputs.GetSuppressionListAddressPlainArgs =
        com.pulumi.azurenative.communication.inputs.GetSuppressionListAddressPlainArgs.builder()
            .addressId(addressId.let({ args0 -> args0 }))
            .domainName(domainName.let({ args0 -> args0 }))
            .emailServiceName(emailServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .suppressionListName(suppressionListName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSuppressionListAddressPlainArgs].
 */
@PulumiTagMarker
public class GetSuppressionListAddressPlainArgsBuilder internal constructor() {
    private var addressId: String? = null

    private var domainName: String? = null

    private var emailServiceName: String? = null

    private var resourceGroupName: String? = null

    private var suppressionListName: String? = null

    /**
     * @param value The id of the address in a suppression list.
     */
    @JvmName("nukiskexycjwwhoa")
    public suspend fun addressId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addressId = mapped
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("heoloqwohglrnxox")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("lfbjsondciodhncj")
    public suspend fun emailServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jlfikwqigfcmboyg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("ypchjrtennttihpd")
    public suspend fun suppressionListName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.suppressionListName = mapped
    }

    internal fun build(): GetSuppressionListAddressPlainArgs = GetSuppressionListAddressPlainArgs(
        addressId = addressId ?: throw PulumiNullFieldException("addressId"),
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        emailServiceName = emailServiceName ?: throw PulumiNullFieldException("emailServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        suppressionListName = suppressionListName ?: throw PulumiNullFieldException("suppressionListName"),
    )
}
