@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.GetSuppressionListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property suppressionListName The name of the suppression list.
 */
public data class GetSuppressionListPlainArgs(
    public val domainName: String,
    public val emailServiceName: String,
    public val resourceGroupName: String,
    public val suppressionListName: String,
) : ConvertibleToJava<com.pulumi.azurenative.communication.inputs.GetSuppressionListPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.inputs.GetSuppressionListPlainArgs =
        com.pulumi.azurenative.communication.inputs.GetSuppressionListPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .emailServiceName(emailServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .suppressionListName(suppressionListName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSuppressionListPlainArgs].
 */
@PulumiTagMarker
public class GetSuppressionListPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var emailServiceName: String? = null

    private var resourceGroupName: String? = null

    private var suppressionListName: String? = null

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("tmbgbmymmphxxlsg")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("iobxmukggtwqngsc")
    public suspend fun emailServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("illaxtxcokurefjx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("uovdveqxnxvxfxne")
    public suspend fun suppressionListName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.suppressionListName = mapped
    }

    internal fun build(): GetSuppressionListPlainArgs = GetSuppressionListPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        emailServiceName = emailServiceName ?: throw PulumiNullFieldException("emailServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        suppressionListName = suppressionListName ?: throw PulumiNullFieldException("suppressionListName"),
    )
}
