@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing a SuppressionList resource.
 * @property createdTimeStamp The date the resource was created.
 * @property dataLocation The location where the SuppressionListAddress data is stored at rest. This value is inherited from the parent Domains resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastUpdatedTimeStamp The date the resource was last updated.
 * @property listName The the name of the suppression list. This value must match one of the valid sender usernames of the sending domain.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSuppressionListResult(
    public val createdTimeStamp: String,
    public val dataLocation: String,
    public val id: String,
    public val lastUpdatedTimeStamp: String,
    public val listName: String? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.GetSuppressionListResult):
            GetSuppressionListResult = GetSuppressionListResult(
            createdTimeStamp = javaType.createdTimeStamp(),
            dataLocation = javaType.dataLocation(),
            id = javaType.id(),
            lastUpdatedTimeStamp = javaType.lastUpdatedTimeStamp(),
            listName = javaType.listName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
