@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing the access keys of a CommunicationService.
 * @property primaryConnectionString CommunicationService connection string constructed via the primaryKey
 * @property primaryKey The primary access key.
 * @property secondaryConnectionString CommunicationService connection string constructed via the secondaryKey
 * @property secondaryKey The secondary access key.
 */
public data class ListCommunicationServiceKeysResult(
    public val primaryConnectionString: String? = null,
    public val primaryKey: String? = null,
    public val secondaryConnectionString: String? = null,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.ListCommunicationServiceKeysResult):
            ListCommunicationServiceKeysResult = ListCommunicationServiceKeysResult(
            primaryConnectionString = javaType.primaryConnectionString().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            secondaryConnectionString = javaType.secondaryConnectionString().map({ args0 ->
                args0
            }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
