@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin.inputs

import com.pulumi.azurenative.community.inputs.IdentityConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the Community CommunityTraining Identity Configuration
 * @property b2cAuthenticationPolicy The name of the authentication policy registered in ADB2C for the Community Training Resource
 * @property b2cPasswordResetPolicy The name of the password reset policy registered in ADB2C for the Community Training Resource
 * @property clientId The clientId of the application registered in the selected identity provider for the Community Training Resource
 * @property clientSecret The client secret of the application registered in the selected identity provider for the Community Training Resource
 * @property customLoginParameters The custom login parameters for the Community Training Resource
 * @property domainName The domain name of the selected identity provider for the Community Training Resource
 * @property identityType The identity type of the Community Training Resource
 * @property teamsEnabled To indicate whether the Community Training Resource has Teams enabled
 * @property tenantId The tenantId of the selected identity provider for the Community Training Resource
 */
public data class IdentityConfigurationPropertiesArgs(
    public val b2cAuthenticationPolicy: Output<String>? = null,
    public val b2cPasswordResetPolicy: Output<String>? = null,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val customLoginParameters: Output<String>? = null,
    public val domainName: Output<String>,
    public val identityType: Output<String>,
    public val teamsEnabled: Output<Boolean>? = null,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.community.inputs.IdentityConfigurationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.community.inputs.IdentityConfigurationPropertiesArgs =
        com.pulumi.azurenative.community.inputs.IdentityConfigurationPropertiesArgs.builder()
            .b2cAuthenticationPolicy(b2cAuthenticationPolicy?.applyValue({ args0 -> args0 }))
            .b2cPasswordResetPolicy(b2cPasswordResetPolicy?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .customLoginParameters(customLoginParameters?.applyValue({ args0 -> args0 }))
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .identityType(identityType.applyValue({ args0 -> args0 }))
            .teamsEnabled(teamsEnabled?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityConfigurationPropertiesArgsBuilder internal constructor() {
    private var b2cAuthenticationPolicy: Output<String>? = null

    private var b2cPasswordResetPolicy: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var customLoginParameters: Output<String>? = null

    private var domainName: Output<String>? = null

    private var identityType: Output<String>? = null

    private var teamsEnabled: Output<Boolean>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The name of the authentication policy registered in ADB2C for the Community Training Resource
     */
    @JvmName("inylhluiagrdledg")
    public suspend fun b2cAuthenticationPolicy(`value`: Output<String>) {
        this.b2cAuthenticationPolicy = value
    }

    /**
     * @param value The name of the password reset policy registered in ADB2C for the Community Training Resource
     */
    @JvmName("xihrdwocvwrsamrq")
    public suspend fun b2cPasswordResetPolicy(`value`: Output<String>) {
        this.b2cPasswordResetPolicy = value
    }

    /**
     * @param value The clientId of the application registered in the selected identity provider for the Community Training Resource
     */
    @JvmName("bnkgyhedjhrfvvbw")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret of the application registered in the selected identity provider for the Community Training Resource
     */
    @JvmName("jrnivkhoamfioyxf")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The custom login parameters for the Community Training Resource
     */
    @JvmName("cwtiflpgoptunkwh")
    public suspend fun customLoginParameters(`value`: Output<String>) {
        this.customLoginParameters = value
    }

    /**
     * @param value The domain name of the selected identity provider for the Community Training Resource
     */
    @JvmName("tceqappxqbquvhqx")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The identity type of the Community Training Resource
     */
    @JvmName("jpohlkvdljgfdsjs")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value To indicate whether the Community Training Resource has Teams enabled
     */
    @JvmName("swcixpryynqqlqph")
    public suspend fun teamsEnabled(`value`: Output<Boolean>) {
        this.teamsEnabled = value
    }

    /**
     * @param value The tenantId of the selected identity provider for the Community Training Resource
     */
    @JvmName("eryddbrdkfkmmycj")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the authentication policy registered in ADB2C for the Community Training Resource
     */
    @JvmName("jdvtgdpgbvhnsohu")
    public suspend fun b2cAuthenticationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.b2cAuthenticationPolicy = mapped
    }

    /**
     * @param value The name of the password reset policy registered in ADB2C for the Community Training Resource
     */
    @JvmName("vnumwlfljmwfnarg")
    public suspend fun b2cPasswordResetPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.b2cPasswordResetPolicy = mapped
    }

    /**
     * @param value The clientId of the application registered in the selected identity provider for the Community Training Resource
     */
    @JvmName("nbtgphhxxpavyfys")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret of the application registered in the selected identity provider for the Community Training Resource
     */
    @JvmName("xunadslqjbgaldxc")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The custom login parameters for the Community Training Resource
     */
    @JvmName("pwokqemdrgicylrr")
    public suspend fun customLoginParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLoginParameters = mapped
    }

    /**
     * @param value The domain name of the selected identity provider for the Community Training Resource
     */
    @JvmName("fgciysqjaigdqwwv")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The identity type of the Community Training Resource
     */
    @JvmName("yodmstnvbfkbnpol")
    public suspend fun identityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value To indicate whether the Community Training Resource has Teams enabled
     */
    @JvmName("qellwxibkrwjodwj")
    public suspend fun teamsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamsEnabled = mapped
    }

    /**
     * @param value The tenantId of the selected identity provider for the Community Training Resource
     */
    @JvmName("abktovuyovvvnlks")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): IdentityConfigurationPropertiesArgs = IdentityConfigurationPropertiesArgs(
        b2cAuthenticationPolicy = b2cAuthenticationPolicy,
        b2cPasswordResetPolicy = b2cPasswordResetPolicy,
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        customLoginParameters = customLoginParameters,
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        identityType = identityType ?: throw PulumiNullFieldException("identityType"),
        teamsEnabled = teamsEnabled,
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
