@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.ComputeFunctions.getAvailabilitySetPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getCapacityReservationGroupPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getCapacityReservationPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getCloudServicePlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDedicatedHostGroupPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDedicatedHostPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDiskAccessAPrivateEndpointConnectionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDiskAccessPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDiskEncryptionSetPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getDiskPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getGalleryApplicationPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getGalleryApplicationVersionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getGalleryImagePlain
import com.pulumi.azurenative.compute.ComputeFunctions.getGalleryImageVersionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getGalleryPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getImagePlain
import com.pulumi.azurenative.compute.ComputeFunctions.getLogAnalyticExportRequestRateByIntervalPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getLogAnalyticExportThrottledRequestsPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getProximityPlacementGroupPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getRestorePointCollectionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getRestorePointPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getSnapshotPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getSshPublicKeyPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineExtensionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineRunCommandByVirtualMachinePlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineScaleSetExtensionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineScaleSetPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineScaleSetVMExtensionPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineScaleSetVMPlain
import com.pulumi.azurenative.compute.ComputeFunctions.getVirtualMachineScaleSetVMRunCommandPlain
import com.pulumi.azurenative.compute.kotlin.enums.IntervalInMins
import com.pulumi.azurenative.compute.kotlin.inputs.GetAvailabilitySetPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetAvailabilitySetPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetCapacityReservationGroupPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetCapacityReservationGroupPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetCapacityReservationPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetCapacityReservationPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetCloudServicePlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetCloudServicePlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDedicatedHostGroupPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDedicatedHostGroupPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDedicatedHostPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDedicatedHostPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskAccessPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskAccessPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskEncryptionSetPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskEncryptionSetPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetDiskPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryApplicationPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryApplicationPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryApplicationVersionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryApplicationVersionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryImagePlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryImagePlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryImageVersionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryImageVersionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetGalleryPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetImagePlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetLogAnalyticExportRequestRateByIntervalPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetLogAnalyticExportRequestRateByIntervalPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetLogAnalyticExportThrottledRequestsPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetLogAnalyticExportThrottledRequestsPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetProximityPlacementGroupPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetProximityPlacementGroupPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetRestorePointCollectionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetRestorePointCollectionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetRestorePointPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetRestorePointPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetSshPublicKeyPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetSshPublicKeyPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineExtensionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineExtensionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetExtensionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetExtensionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgsBuilder
import com.pulumi.azurenative.compute.kotlin.outputs.GetAvailabilitySetResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetCapacityReservationGroupResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetCapacityReservationResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetCloudServiceResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDedicatedHostGroupResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDedicatedHostResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskAccessAPrivateEndpointConnectionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskAccessResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskEncryptionSetResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryApplicationResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryApplicationVersionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryImageResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryImageVersionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetImageResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetLogAnalyticExportRequestRateByIntervalResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetLogAnalyticExportThrottledRequestsResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetProximityPlacementGroupResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetRestorePointCollectionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetRestorePointResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetSnapshotResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetSshPublicKeyResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineExtensionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineRunCommandByVirtualMachineResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetExtensionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMExtensionResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMResult
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMRunCommandResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.compute.kotlin.outputs.GetAvailabilitySetResult.Companion.toKotlin as getAvailabilitySetResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetCapacityReservationGroupResult.Companion.toKotlin as getCapacityReservationGroupResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetCapacityReservationResult.Companion.toKotlin as getCapacityReservationResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetCloudServiceResult.Companion.toKotlin as getCloudServiceResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDedicatedHostGroupResult.Companion.toKotlin as getDedicatedHostGroupResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDedicatedHostResult.Companion.toKotlin as getDedicatedHostResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskAccessAPrivateEndpointConnectionResult.Companion.toKotlin as getDiskAccessAPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskAccessResult.Companion.toKotlin as getDiskAccessResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskEncryptionSetResult.Companion.toKotlin as getDiskEncryptionSetResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetDiskResult.Companion.toKotlin as getDiskResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryApplicationResult.Companion.toKotlin as getGalleryApplicationResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryApplicationVersionResult.Companion.toKotlin as getGalleryApplicationVersionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryImageResult.Companion.toKotlin as getGalleryImageResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryImageVersionResult.Companion.toKotlin as getGalleryImageVersionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetGalleryResult.Companion.toKotlin as getGalleryResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetImageResult.Companion.toKotlin as getImageResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetLogAnalyticExportRequestRateByIntervalResult.Companion.toKotlin as getLogAnalyticExportRequestRateByIntervalResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetLogAnalyticExportThrottledRequestsResult.Companion.toKotlin as getLogAnalyticExportThrottledRequestsResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetProximityPlacementGroupResult.Companion.toKotlin as getProximityPlacementGroupResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetRestorePointCollectionResult.Companion.toKotlin as getRestorePointCollectionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetRestorePointResult.Companion.toKotlin as getRestorePointResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetSshPublicKeyResult.Companion.toKotlin as getSshPublicKeyResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineExtensionResult.Companion.toKotlin as getVirtualMachineExtensionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineRunCommandByVirtualMachineResult.Companion.toKotlin as getVirtualMachineRunCommandByVirtualMachineResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetExtensionResult.Companion.toKotlin as getVirtualMachineScaleSetExtensionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetResult.Companion.toKotlin as getVirtualMachineScaleSetResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMExtensionResult.Companion.toKotlin as getVirtualMachineScaleSetVMExtensionResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMResult.Companion.toKotlin as getVirtualMachineScaleSetVMResultToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GetVirtualMachineScaleSetVMRunCommandResult.Companion.toKotlin as getVirtualMachineScaleSetVMRunCommandResultToKotlin

public object ComputeFunctions {
    /**
     * Retrieves information about an availability set.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2016-04-30-preview, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
     */
    public suspend fun getAvailabilitySet(argument: GetAvailabilitySetPlainArgs):
        GetAvailabilitySetResult =
        getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(argument.toJava()).await())

    /**
     * @see [getAvailabilitySet].
     * @param availabilitySetName The name of the availability set.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
     */
    public suspend fun getAvailabilitySet(availabilitySetName: String, resourceGroupName: String):
        GetAvailabilitySetResult {
        val argument = GetAvailabilitySetPlainArgs(
            availabilitySetName = availabilitySetName,
            resourceGroupName = resourceGroupName,
        )
        return getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilitySet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetAvailabilitySetPlainArgs].
     * @return Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
     */
    public suspend
    fun getAvailabilitySet(argument: suspend GetAvailabilitySetPlainArgsBuilder.() -> Unit):
        GetAvailabilitySetResult {
        val builder = GetAvailabilitySetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation that retrieves information about the capacity reservation.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the capacity reservation.
     */
    public suspend fun getCapacityReservation(argument: GetCapacityReservationPlainArgs):
        GetCapacityReservationResult =
        getCapacityReservationResultToKotlin(getCapacityReservationPlain(argument.toJava()).await())

    /**
     * @see [getCapacityReservation].
     * @param capacityReservationGroupName The name of the capacity reservation group.
     * @param capacityReservationName The name of the capacity reservation.
     * @param expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the capacity reservation that is managed by the platform and can change outside of control plane operations.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the capacity reservation.
     */
    public suspend fun getCapacityReservation(
        capacityReservationGroupName: String,
        capacityReservationName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): GetCapacityReservationResult {
        val argument = GetCapacityReservationPlainArgs(
            capacityReservationGroupName = capacityReservationGroupName,
            capacityReservationName = capacityReservationName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return getCapacityReservationResultToKotlin(getCapacityReservationPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityReservation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetCapacityReservationPlainArgs].
     * @return Specifies information about the capacity reservation.
     */
    public suspend
    fun getCapacityReservation(argument: suspend GetCapacityReservationPlainArgsBuilder.() -> Unit):
        GetCapacityReservationResult {
        val builder = GetCapacityReservationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityReservationResultToKotlin(getCapacityReservationPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation that retrieves information about a capacity reservation group.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
     */
    public suspend fun getCapacityReservationGroup(argument: GetCapacityReservationGroupPlainArgs):
        GetCapacityReservationGroupResult =
        getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(argument.toJava()).await())

    /**
     * @see [getCapacityReservationGroup].
     * @param capacityReservationGroupName The name of the capacity reservation group.
     * @param expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the capacity reservations under the capacity reservation group which is a snapshot of the runtime properties of a capacity reservation that is managed by the platform and can change outside of control plane operations.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
     */
    public suspend fun getCapacityReservationGroup(
        capacityReservationGroupName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): GetCapacityReservationGroupResult {
        val argument = GetCapacityReservationGroupPlainArgs(
            capacityReservationGroupName = capacityReservationGroupName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityReservationGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetCapacityReservationGroupPlainArgs].
     * @return Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
     */
    public suspend
    fun getCapacityReservationGroup(argument: suspend GetCapacityReservationGroupPlainArgsBuilder.() -> Unit):
        GetCapacityReservationGroupResult {
        val builder = GetCapacityReservationGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Display information about a cloud service.
     * Azure REST API version: 2022-09-04.
     * @param argument null
     * @return Describes the cloud service.
     */
    public suspend fun getCloudService(argument: GetCloudServicePlainArgs): GetCloudServiceResult =
        getCloudServiceResultToKotlin(getCloudServicePlain(argument.toJava()).await())

    /**
     * @see [getCloudService].
     * @param cloudServiceName Name of the cloud service.
     * @param resourceGroupName Name of the resource group.
     * @return Describes the cloud service.
     */
    public suspend fun getCloudService(cloudServiceName: String, resourceGroupName: String):
        GetCloudServiceResult {
        val argument = GetCloudServicePlainArgs(
            cloudServiceName = cloudServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudServiceResultToKotlin(getCloudServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetCloudServicePlainArgs].
     * @return Describes the cloud service.
     */
    public suspend fun getCloudService(argument: suspend GetCloudServicePlainArgsBuilder.() -> Unit):
        GetCloudServiceResult {
        val builder = GetCloudServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudServiceResultToKotlin(getCloudServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a dedicated host.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the Dedicated host.
     */
    public suspend fun getDedicatedHost(argument: GetDedicatedHostPlainArgs): GetDedicatedHostResult =
        getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHost].
     * @param expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated host. 'UserData' is not supported for dedicated host.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the Dedicated host.
     */
    public suspend fun getDedicatedHost(
        expand: String? = null,
        hostGroupName: String,
        hostName: String,
        resourceGroupName: String,
    ): GetDedicatedHostResult {
        val argument = GetDedicatedHostPlainArgs(
            expand = expand,
            hostGroupName = hostGroupName,
            hostName = hostName,
            resourceGroupName = resourceGroupName,
        )
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHost].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDedicatedHostPlainArgs].
     * @return Specifies information about the Dedicated host.
     */
    public suspend
    fun getDedicatedHost(argument: suspend GetDedicatedHostPlainArgsBuilder.() -> Unit):
        GetDedicatedHostResult {
        val builder = GetDedicatedHostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a dedicated host group.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
     */
    public suspend fun getDedicatedHostGroup(argument: GetDedicatedHostGroupPlainArgs):
        GetDedicatedHostGroupResult =
        getDedicatedHostGroupResultToKotlin(getDedicatedHostGroupPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHostGroup].
     * @param expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated hosts under the dedicated host group. 'UserData' is not supported for dedicated host group.
     * @param hostGroupName The name of the dedicated host group.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
     */
    public suspend fun getDedicatedHostGroup(
        expand: String? = null,
        hostGroupName: String,
        resourceGroupName: String,
    ): GetDedicatedHostGroupResult {
        val argument = GetDedicatedHostGroupPlainArgs(
            expand = expand,
            hostGroupName = hostGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getDedicatedHostGroupResultToKotlin(getDedicatedHostGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHostGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDedicatedHostGroupPlainArgs].
     * @return Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
     */
    public suspend
    fun getDedicatedHostGroup(argument: suspend GetDedicatedHostGroupPlainArgsBuilder.() -> Unit):
        GetDedicatedHostGroupResult {
        val builder = GetDedicatedHostGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostGroupResultToKotlin(getDedicatedHostGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a disk.
     * Azure REST API version: 2022-07-02.
     * Other available API versions: 2016-04-30-preview, 2018-06-01, 2019-07-01, 2023-01-02, 2023-04-02, 2023-10-02.
     * @param argument null
     * @return Disk resource.
     */
    public suspend fun getDisk(argument: GetDiskPlainArgs): GetDiskResult =
        getDiskResultToKotlin(getDiskPlain(argument.toJava()).await())

    /**
     * @see [getDisk].
     * @param diskName The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     * @param resourceGroupName The name of the resource group.
     * @return Disk resource.
     */
    public suspend fun getDisk(diskName: String, resourceGroupName: String): GetDiskResult {
        val argument = GetDiskPlainArgs(
            diskName = diskName,
            resourceGroupName = resourceGroupName,
        )
        return getDiskResultToKotlin(getDiskPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisk].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDiskPlainArgs].
     * @return Disk resource.
     */
    public suspend fun getDisk(argument: suspend GetDiskPlainArgsBuilder.() -> Unit): GetDiskResult {
        val builder = GetDiskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskResultToKotlin(getDiskPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a disk access resource.
     * Azure REST API version: 2022-07-02.
     * Other available API versions: 2023-01-02, 2023-04-02, 2023-10-02.
     * @param argument null
     * @return disk access resource.
     */
    public suspend fun getDiskAccess(argument: GetDiskAccessPlainArgs): GetDiskAccessResult =
        getDiskAccessResultToKotlin(getDiskAccessPlain(argument.toJava()).await())

    /**
     * @see [getDiskAccess].
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     * @param resourceGroupName The name of the resource group.
     * @return disk access resource.
     */
    public suspend fun getDiskAccess(diskAccessName: String, resourceGroupName: String):
        GetDiskAccessResult {
        val argument = GetDiskAccessPlainArgs(
            diskAccessName = diskAccessName,
            resourceGroupName = resourceGroupName,
        )
        return getDiskAccessResultToKotlin(getDiskAccessPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskAccess].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDiskAccessPlainArgs].
     * @return disk access resource.
     */
    public suspend fun getDiskAccess(argument: suspend GetDiskAccessPlainArgsBuilder.() -> Unit):
        GetDiskAccessResult {
        val builder = GetDiskAccessPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskAccessResultToKotlin(getDiskAccessPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * Azure REST API version: 2022-07-02.
     * Other available API versions: 2023-01-02, 2023-04-02, 2023-10-02.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getDiskAccessAPrivateEndpointConnection(argument: GetDiskAccessAPrivateEndpointConnectionPlainArgs):
        GetDiskAccessAPrivateEndpointConnectionResult =
        getDiskAccessAPrivateEndpointConnectionResultToKotlin(getDiskAccessAPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getDiskAccessAPrivateEndpointConnection].
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getDiskAccessAPrivateEndpointConnection(
        diskAccessName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetDiskAccessAPrivateEndpointConnectionResult {
        val argument = GetDiskAccessAPrivateEndpointConnectionPlainArgs(
            diskAccessName = diskAccessName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getDiskAccessAPrivateEndpointConnectionResultToKotlin(getDiskAccessAPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskAccessAPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDiskAccessAPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getDiskAccessAPrivateEndpointConnection(argument: suspend GetDiskAccessAPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetDiskAccessAPrivateEndpointConnectionResult {
        val builder = GetDiskAccessAPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskAccessAPrivateEndpointConnectionResultToKotlin(getDiskAccessAPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a disk encryption set.
     * Azure REST API version: 2022-07-02.
     * Other available API versions: 2020-06-30, 2023-01-02, 2023-04-02, 2023-10-02.
     * @param argument null
     * @return disk encryption set resource.
     */
    public suspend fun getDiskEncryptionSet(argument: GetDiskEncryptionSetPlainArgs):
        GetDiskEncryptionSetResult =
        getDiskEncryptionSetResultToKotlin(getDiskEncryptionSetPlain(argument.toJava()).await())

    /**
     * @see [getDiskEncryptionSet].
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     * @param resourceGroupName The name of the resource group.
     * @return disk encryption set resource.
     */
    public suspend fun getDiskEncryptionSet(diskEncryptionSetName: String, resourceGroupName: String):
        GetDiskEncryptionSetResult {
        val argument = GetDiskEncryptionSetPlainArgs(
            diskEncryptionSetName = diskEncryptionSetName,
            resourceGroupName = resourceGroupName,
        )
        return getDiskEncryptionSetResultToKotlin(getDiskEncryptionSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskEncryptionSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetDiskEncryptionSetPlainArgs].
     * @return disk encryption set resource.
     */
    public suspend
    fun getDiskEncryptionSet(argument: suspend GetDiskEncryptionSetPlainArgsBuilder.() -> Unit):
        GetDiskEncryptionSetResult {
        val builder = GetDiskEncryptionSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskEncryptionSetResultToKotlin(getDiskEncryptionSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a Shared Image Gallery.
     * Azure REST API version: 2022-03-03.
     * Other available API versions: 2022-08-03, 2023-07-03.
     * @param argument null
     * @return Specifies information about the Shared Image Gallery that you want to create or update.
     */
    public suspend fun getGallery(argument: GetGalleryPlainArgs): GetGalleryResult =
        getGalleryResultToKotlin(getGalleryPlain(argument.toJava()).await())

    /**
     * @see [getGallery].
     * @param expand The expand query option to apply on the operation.
     * @param galleryName The name of the Shared Image Gallery.
     * @param resourceGroupName The name of the resource group.
     * @param select The select expression to apply on the operation.
     * @return Specifies information about the Shared Image Gallery that you want to create or update.
     */
    public suspend fun getGallery(
        expand: String? = null,
        galleryName: String,
        resourceGroupName: String,
        select: String? = null,
    ): GetGalleryResult {
        val argument = GetGalleryPlainArgs(
            expand = expand,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
            select = select,
        )
        return getGalleryResultToKotlin(getGalleryPlain(argument.toJava()).await())
    }

    /**
     * @see [getGallery].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetGalleryPlainArgs].
     * @return Specifies information about the Shared Image Gallery that you want to create or update.
     */
    public suspend fun getGallery(argument: suspend GetGalleryPlainArgsBuilder.() -> Unit):
        GetGalleryResult {
        val builder = GetGalleryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryResultToKotlin(getGalleryPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a gallery Application Definition.
     * Azure REST API version: 2022-03-03.
     * Other available API versions: 2022-08-03, 2023-07-03.
     * @param argument null
     * @return Specifies information about the gallery Application Definition that you want to create or update.
     */
    public suspend fun getGalleryApplication(argument: GetGalleryApplicationPlainArgs):
        GetGalleryApplicationResult =
        getGalleryApplicationResultToKotlin(getGalleryApplicationPlain(argument.toJava()).await())

    /**
     * @see [getGalleryApplication].
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the gallery Application Definition that you want to create or update.
     */
    public suspend fun getGalleryApplication(
        galleryApplicationName: String,
        galleryName: String,
        resourceGroupName: String,
    ): GetGalleryApplicationResult {
        val argument = GetGalleryApplicationPlainArgs(
            galleryApplicationName = galleryApplicationName,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryApplicationResultToKotlin(getGalleryApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetGalleryApplicationPlainArgs].
     * @return Specifies information about the gallery Application Definition that you want to create or update.
     */
    public suspend
    fun getGalleryApplication(argument: suspend GetGalleryApplicationPlainArgsBuilder.() -> Unit):
        GetGalleryApplicationResult {
        val builder = GetGalleryApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryApplicationResultToKotlin(getGalleryApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a gallery Application Version.
     * Azure REST API version: 2022-03-03.
     * Other available API versions: 2022-08-03, 2023-07-03.
     * @param argument null
     * @return Specifies information about the gallery Application Version that you want to create or update.
     */
    public suspend fun getGalleryApplicationVersion(argument: GetGalleryApplicationVersionPlainArgs):
        GetGalleryApplicationVersionResult =
        getGalleryApplicationVersionResultToKotlin(getGalleryApplicationVersionPlain(argument.toJava()).await())

    /**
     * @see [getGalleryApplicationVersion].
     * @param expand The expand expression to apply on the operation.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the gallery Application Version that you want to create or update.
     */
    public suspend fun getGalleryApplicationVersion(
        expand: String? = null,
        galleryApplicationName: String,
        galleryApplicationVersionName: String,
        galleryName: String,
        resourceGroupName: String,
    ): GetGalleryApplicationVersionResult {
        val argument = GetGalleryApplicationVersionPlainArgs(
            expand = expand,
            galleryApplicationName = galleryApplicationName,
            galleryApplicationVersionName = galleryApplicationVersionName,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryApplicationVersionResultToKotlin(getGalleryApplicationVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryApplicationVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetGalleryApplicationVersionPlainArgs].
     * @return Specifies information about the gallery Application Version that you want to create or update.
     */
    public suspend
    fun getGalleryApplicationVersion(argument: suspend GetGalleryApplicationVersionPlainArgsBuilder.() -> Unit):
        GetGalleryApplicationVersionResult {
        val builder = GetGalleryApplicationVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryApplicationVersionResultToKotlin(getGalleryApplicationVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a gallery image definition.
     * Azure REST API version: 2022-03-03.
     * Other available API versions: 2022-08-03, 2023-07-03.
     * @param argument null
     * @return Specifies information about the gallery image definition that you want to create or update.
     */
    public suspend fun getGalleryImage(argument: GetGalleryImagePlainArgs): GetGalleryImageResult =
        getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())

    /**
     * @see [getGalleryImage].
     * @param galleryImageName The name of the gallery image definition to be retrieved.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the gallery image definition that you want to create or update.
     */
    public suspend fun getGalleryImage(
        galleryImageName: String,
        galleryName: String,
        resourceGroupName: String,
    ): GetGalleryImageResult {
        val argument = GetGalleryImagePlainArgs(
            galleryImageName = galleryImageName,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetGalleryImagePlainArgs].
     * @return Specifies information about the gallery image definition that you want to create or update.
     */
    public suspend fun getGalleryImage(argument: suspend GetGalleryImagePlainArgsBuilder.() -> Unit):
        GetGalleryImageResult {
        val builder = GetGalleryImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryImageResultToKotlin(getGalleryImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a gallery image version.
     * Azure REST API version: 2022-03-03.
     * Other available API versions: 2019-03-01, 2022-08-03, 2023-07-03.
     * @param argument null
     * @return Specifies information about the gallery image version that you want to create or update.
     */
    public suspend fun getGalleryImageVersion(argument: GetGalleryImageVersionPlainArgs):
        GetGalleryImageVersionResult =
        getGalleryImageVersionResultToKotlin(getGalleryImageVersionPlain(argument.toJava()).await())

    /**
     * @see [getGalleryImageVersion].
     * @param expand The expand expression to apply on the operation.
     * @param galleryImageName The name of the gallery image definition in which the Image Version resides.
     * @param galleryImageVersionName The name of the gallery image version to be retrieved.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition resides.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the gallery image version that you want to create or update.
     */
    public suspend fun getGalleryImageVersion(
        expand: String? = null,
        galleryImageName: String,
        galleryImageVersionName: String,
        galleryName: String,
        resourceGroupName: String,
    ): GetGalleryImageVersionResult {
        val argument = GetGalleryImageVersionPlainArgs(
            expand = expand,
            galleryImageName = galleryImageName,
            galleryImageVersionName = galleryImageVersionName,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryImageVersionResultToKotlin(getGalleryImageVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryImageVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetGalleryImageVersionPlainArgs].
     * @return Specifies information about the gallery image version that you want to create or update.
     */
    public suspend
    fun getGalleryImageVersion(argument: suspend GetGalleryImageVersionPlainArgsBuilder.() -> Unit):
        GetGalleryImageVersionResult {
        val builder = GetGalleryImageVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryImageVersionResultToKotlin(getGalleryImageVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an image.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        getImageResultToKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param expand The expand expression to apply on the operation.
     * @param imageName The name of the image.
     * @param resourceGroupName The name of the resource group.
     * @return The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    public suspend fun getImage(
        expand: String? = null,
        imageName: String,
        resourceGroupName: String,
    ): GetImageResult {
        val argument = GetImagePlainArgs(
            expand = expand,
            imageName = imageName,
            resourceGroupName = resourceGroupName,
        )
        return getImageResultToKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit):
        GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageResultToKotlin(getImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Export logs that show Api requests made by this subscription in the given time window to show throttling activities.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2017-12-01, 2018-04-01, 2018-06-01, 2018-10-01, 2019-03-01, 2019-07-01, 2019-12-01, 2020-06-01, 2020-12-01, 2021-03-01, 2021-04-01, 2021-07-01, 2021-11-01, 2022-03-01, 2022-08-01, 2022-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return LogAnalytics operation status response
     */
    public suspend
    fun getLogAnalyticExportRequestRateByInterval(argument: GetLogAnalyticExportRequestRateByIntervalPlainArgs):
        GetLogAnalyticExportRequestRateByIntervalResult =
        getLogAnalyticExportRequestRateByIntervalResultToKotlin(getLogAnalyticExportRequestRateByIntervalPlain(argument.toJava()).await())

    /**
     * @see [getLogAnalyticExportRequestRateByInterval].
     * @param blobContainerSasUri SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
     * @param fromTime From time of the query
     * @param groupByClientApplicationId Group query result by Client Application ID.
     * @param groupByOperationName Group query result by Operation Name.
     * @param groupByResourceName Group query result by Resource Name.
     * @param groupByThrottlePolicy Group query result by Throttle Policy applied.
     * @param groupByUserAgent Group query result by User Agent.
     * @param intervalLength Interval value in minutes used to create LogAnalytics call rate logs.
     * @param location The location upon which virtual-machine-sizes is queried.
     * @param toTime To time of the query
     * @return LogAnalytics operation status response
     */
    public suspend fun getLogAnalyticExportRequestRateByInterval(
        blobContainerSasUri: String,
        fromTime: String,
        groupByClientApplicationId: Boolean? = null,
        groupByOperationName: Boolean? = null,
        groupByResourceName: Boolean? = null,
        groupByThrottlePolicy: Boolean? = null,
        groupByUserAgent: Boolean? = null,
        intervalLength: IntervalInMins,
        location: String,
        toTime: String,
    ): GetLogAnalyticExportRequestRateByIntervalResult {
        val argument = GetLogAnalyticExportRequestRateByIntervalPlainArgs(
            blobContainerSasUri = blobContainerSasUri,
            fromTime = fromTime,
            groupByClientApplicationId = groupByClientApplicationId,
            groupByOperationName = groupByOperationName,
            groupByResourceName = groupByResourceName,
            groupByThrottlePolicy = groupByThrottlePolicy,
            groupByUserAgent = groupByUserAgent,
            intervalLength = intervalLength,
            location = location,
            toTime = toTime,
        )
        return getLogAnalyticExportRequestRateByIntervalResultToKotlin(getLogAnalyticExportRequestRateByIntervalPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogAnalyticExportRequestRateByInterval].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetLogAnalyticExportRequestRateByIntervalPlainArgs].
     * @return LogAnalytics operation status response
     */
    public suspend
    fun getLogAnalyticExportRequestRateByInterval(argument: suspend GetLogAnalyticExportRequestRateByIntervalPlainArgsBuilder.() -> Unit):
        GetLogAnalyticExportRequestRateByIntervalResult {
        val builder = GetLogAnalyticExportRequestRateByIntervalPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogAnalyticExportRequestRateByIntervalResultToKotlin(getLogAnalyticExportRequestRateByIntervalPlain(builtArgument.toJava()).await())
    }

    /**
     * Export logs that show total throttled Api requests for this subscription in the given time window.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2017-12-01, 2018-04-01, 2018-06-01, 2018-10-01, 2019-03-01, 2019-07-01, 2019-12-01, 2020-06-01, 2020-12-01, 2021-03-01, 2021-04-01, 2021-07-01, 2021-11-01, 2022-03-01, 2022-08-01, 2022-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return LogAnalytics operation status response
     */
    public suspend
    fun getLogAnalyticExportThrottledRequests(argument: GetLogAnalyticExportThrottledRequestsPlainArgs):
        GetLogAnalyticExportThrottledRequestsResult =
        getLogAnalyticExportThrottledRequestsResultToKotlin(getLogAnalyticExportThrottledRequestsPlain(argument.toJava()).await())

    /**
     * @see [getLogAnalyticExportThrottledRequests].
     * @param blobContainerSasUri SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
     * @param fromTime From time of the query
     * @param groupByClientApplicationId Group query result by Client Application ID.
     * @param groupByOperationName Group query result by Operation Name.
     * @param groupByResourceName Group query result by Resource Name.
     * @param groupByThrottlePolicy Group query result by Throttle Policy applied.
     * @param groupByUserAgent Group query result by User Agent.
     * @param location The location upon which virtual-machine-sizes is queried.
     * @param toTime To time of the query
     * @return LogAnalytics operation status response
     */
    public suspend fun getLogAnalyticExportThrottledRequests(
        blobContainerSasUri: String,
        fromTime: String,
        groupByClientApplicationId: Boolean? = null,
        groupByOperationName: Boolean? = null,
        groupByResourceName: Boolean? = null,
        groupByThrottlePolicy: Boolean? = null,
        groupByUserAgent: Boolean? = null,
        location: String,
        toTime: String,
    ): GetLogAnalyticExportThrottledRequestsResult {
        val argument = GetLogAnalyticExportThrottledRequestsPlainArgs(
            blobContainerSasUri = blobContainerSasUri,
            fromTime = fromTime,
            groupByClientApplicationId = groupByClientApplicationId,
            groupByOperationName = groupByOperationName,
            groupByResourceName = groupByResourceName,
            groupByThrottlePolicy = groupByThrottlePolicy,
            groupByUserAgent = groupByUserAgent,
            location = location,
            toTime = toTime,
        )
        return getLogAnalyticExportThrottledRequestsResultToKotlin(getLogAnalyticExportThrottledRequestsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogAnalyticExportThrottledRequests].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetLogAnalyticExportThrottledRequestsPlainArgs].
     * @return LogAnalytics operation status response
     */
    public suspend
    fun getLogAnalyticExportThrottledRequests(argument: suspend GetLogAnalyticExportThrottledRequestsPlainArgsBuilder.() -> Unit):
        GetLogAnalyticExportThrottledRequestsResult {
        val builder = GetLogAnalyticExportThrottledRequestsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogAnalyticExportThrottledRequestsResultToKotlin(getLogAnalyticExportThrottledRequestsPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a proximity placement group .
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-03-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the proximity placement group.
     */
    public suspend fun getProximityPlacementGroup(argument: GetProximityPlacementGroupPlainArgs):
        GetProximityPlacementGroupResult =
        getProximityPlacementGroupResultToKotlin(getProximityPlacementGroupPlain(argument.toJava()).await())

    /**
     * @see [getProximityPlacementGroup].
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param resourceGroupName The name of the resource group.
     * @return Specifies information about the proximity placement group.
     */
    public suspend fun getProximityPlacementGroup(
        includeColocationStatus: String? = null,
        proximityPlacementGroupName: String,
        resourceGroupName: String,
    ): GetProximityPlacementGroupResult {
        val argument = GetProximityPlacementGroupPlainArgs(
            includeColocationStatus = includeColocationStatus,
            proximityPlacementGroupName = proximityPlacementGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getProximityPlacementGroupResultToKotlin(getProximityPlacementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getProximityPlacementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetProximityPlacementGroupPlainArgs].
     * @return Specifies information about the proximity placement group.
     */
    public suspend
    fun getProximityPlacementGroup(argument: suspend GetProximityPlacementGroupPlainArgsBuilder.() -> Unit):
        GetProximityPlacementGroupResult {
        val builder = GetProximityPlacementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProximityPlacementGroupResultToKotlin(getProximityPlacementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the restore point.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2021-11-01, 2022-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Restore Point details.
     */
    public suspend fun getRestorePoint(argument: GetRestorePointPlainArgs): GetRestorePointResult =
        getRestorePointResultToKotlin(getRestorePointPlain(argument.toJava()).await())

    /**
     * @see [getRestorePoint].
     * @param expand The expand expression to apply on the operation. 'InstanceView' retrieves information about the run-time state of a restore point.
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @return Restore Point details.
     */
    public suspend fun getRestorePoint(
        expand: String? = null,
        resourceGroupName: String,
        restorePointCollectionName: String,
        restorePointName: String,
    ): GetRestorePointResult {
        val argument = GetRestorePointPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            restorePointCollectionName = restorePointCollectionName,
            restorePointName = restorePointName,
        )
        return getRestorePointResultToKotlin(getRestorePointPlain(argument.toJava()).await())
    }

    /**
     * @see [getRestorePoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetRestorePointPlainArgs].
     * @return Restore Point details.
     */
    public suspend fun getRestorePoint(argument: suspend GetRestorePointPlainArgsBuilder.() -> Unit):
        GetRestorePointResult {
        val builder = GetRestorePointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRestorePointResultToKotlin(getRestorePointPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the restore point collection.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Create or update Restore Point collection parameters.
     */
    public suspend fun getRestorePointCollection(argument: GetRestorePointCollectionPlainArgs):
        GetRestorePointCollectionResult =
        getRestorePointCollectionResultToKotlin(getRestorePointCollectionPlain(argument.toJava()).await())

    /**
     * @see [getRestorePointCollection].
     * @param expand The expand expression to apply on the operation. If expand=restorePoints, server will return all contained restore points in the restorePointCollection.
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @return Create or update Restore Point collection parameters.
     */
    public suspend fun getRestorePointCollection(
        expand: String? = null,
        resourceGroupName: String,
        restorePointCollectionName: String,
    ): GetRestorePointCollectionResult {
        val argument = GetRestorePointCollectionPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            restorePointCollectionName = restorePointCollectionName,
        )
        return getRestorePointCollectionResultToKotlin(getRestorePointCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRestorePointCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetRestorePointCollectionPlainArgs].
     * @return Create or update Restore Point collection parameters.
     */
    public suspend
    fun getRestorePointCollection(argument: suspend GetRestorePointCollectionPlainArgsBuilder.() -> Unit):
        GetRestorePointCollectionResult {
        val builder = GetRestorePointCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRestorePointCollectionResultToKotlin(getRestorePointCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a snapshot.
     * Azure REST API version: 2022-07-02.
     * Other available API versions: 2016-04-30-preview, 2017-03-30, 2018-06-01, 2023-01-02, 2023-04-02, 2023-10-02.
     * @param argument null
     * @return Snapshot resource.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
     * @return Snapshot resource.
     */
    public suspend fun getSnapshot(resourceGroupName: String, snapshotName: String):
        GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            resourceGroupName = resourceGroupName,
            snapshotName = snapshotName,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return Snapshot resource.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit):
        GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about an SSH public key.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Specifies information about the SSH public key.
     */
    public suspend fun getSshPublicKey(argument: GetSshPublicKeyPlainArgs): GetSshPublicKeyResult =
        getSshPublicKeyResultToKotlin(getSshPublicKeyPlain(argument.toJava()).await())

    /**
     * @see [getSshPublicKey].
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @return Specifies information about the SSH public key.
     */
    public suspend fun getSshPublicKey(resourceGroupName: String, sshPublicKeyName: String):
        GetSshPublicKeyResult {
        val argument = GetSshPublicKeyPlainArgs(
            resourceGroupName = resourceGroupName,
            sshPublicKeyName = sshPublicKeyName,
        )
        return getSshPublicKeyResultToKotlin(getSshPublicKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSshPublicKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetSshPublicKeyPlainArgs].
     * @return Specifies information about the SSH public key.
     */
    public suspend fun getSshPublicKey(argument: suspend GetSshPublicKeyPlainArgsBuilder.() -> Unit):
        GetSshPublicKeyResult {
        val builder = GetSshPublicKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSshPublicKeyResultToKotlin(getSshPublicKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about the model view or the instance view of a virtual machine.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine.
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs):
        GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the virtual machine that is managed by the platform and can change outside of control plane operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user during the VM Create/Update operation.
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @return Describes a Virtual Machine.
     */
    public suspend fun getVirtualMachine(
        expand: String? = null,
        resourceGroupName: String,
        vmName: String,
    ): GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            vmName = vmName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return Describes a Virtual Machine.
     */
    public suspend
    fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2021-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine Extension.
     */
    public suspend fun getVirtualMachineExtension(argument: GetVirtualMachineExtensionPlainArgs):
        GetVirtualMachineExtensionResult =
        getVirtualMachineExtensionResultToKotlin(getVirtualMachineExtensionPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineExtension].
     * @param expand The expand expression to apply on the operation.
     * @param resourceGroupName The name of the resource group.
     * @param vmExtensionName The name of the virtual machine extension.
     * @param vmName The name of the virtual machine containing the extension.
     * @return Describes a Virtual Machine Extension.
     */
    public suspend fun getVirtualMachineExtension(
        expand: String? = null,
        resourceGroupName: String,
        vmExtensionName: String,
        vmName: String,
    ): GetVirtualMachineExtensionResult {
        val argument = GetVirtualMachineExtensionPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            vmExtensionName = vmExtensionName,
            vmName = vmName,
        )
        return getVirtualMachineExtensionResultToKotlin(getVirtualMachineExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineExtensionPlainArgs].
     * @return Describes a Virtual Machine Extension.
     */
    public suspend
    fun getVirtualMachineExtension(argument: suspend GetVirtualMachineExtensionPlainArgsBuilder.() -> Unit):
        GetVirtualMachineExtensionResult {
        val builder = GetVirtualMachineExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineExtensionResultToKotlin(getVirtualMachineExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the run command.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine run command.
     */
    public suspend
    fun getVirtualMachineRunCommandByVirtualMachine(argument: GetVirtualMachineRunCommandByVirtualMachinePlainArgs):
        GetVirtualMachineRunCommandByVirtualMachineResult =
        getVirtualMachineRunCommandByVirtualMachineResultToKotlin(getVirtualMachineRunCommandByVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineRunCommandByVirtualMachine].
     * @param expand The expand expression to apply on the operation.
     * @param resourceGroupName The name of the resource group.
     * @param runCommandName The name of the virtual machine run command.
     * @param vmName The name of the virtual machine containing the run command.
     * @return Describes a Virtual Machine run command.
     */
    public suspend fun getVirtualMachineRunCommandByVirtualMachine(
        expand: String? = null,
        resourceGroupName: String,
        runCommandName: String,
        vmName: String,
    ): GetVirtualMachineRunCommandByVirtualMachineResult {
        val argument = GetVirtualMachineRunCommandByVirtualMachinePlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            runCommandName = runCommandName,
            vmName = vmName,
        )
        return getVirtualMachineRunCommandByVirtualMachineResultToKotlin(getVirtualMachineRunCommandByVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineRunCommandByVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineRunCommandByVirtualMachinePlainArgs].
     * @return Describes a Virtual Machine run command.
     */
    public suspend
    fun getVirtualMachineRunCommandByVirtualMachine(argument: suspend GetVirtualMachineRunCommandByVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineRunCommandByVirtualMachineResult {
        val builder = GetVirtualMachineRunCommandByVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineRunCommandByVirtualMachineResultToKotlin(getVirtualMachineRunCommandByVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Display information about a virtual machine scale set.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2015-06-15, 2016-04-30-preview, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine Scale Set.
     */
    public suspend fun getVirtualMachineScaleSet(argument: GetVirtualMachineScaleSetPlainArgs):
        GetVirtualMachineScaleSetResult =
        getVirtualMachineScaleSetResultToKotlin(getVirtualMachineScaleSetPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineScaleSet].
     * @param expand The expand expression to apply on the operation. 'UserData' retrieves the UserData property of the VM scale set that was provided by the user during the VM scale set Create/Update operation
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @return Describes a Virtual Machine Scale Set.
     */
    public suspend fun getVirtualMachineScaleSet(
        expand: String? = null,
        resourceGroupName: String,
        vmScaleSetName: String,
    ): GetVirtualMachineScaleSetResult {
        val argument = GetVirtualMachineScaleSetPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            vmScaleSetName = vmScaleSetName,
        )
        return getVirtualMachineScaleSetResultToKotlin(getVirtualMachineScaleSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineScaleSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineScaleSetPlainArgs].
     * @return Describes a Virtual Machine Scale Set.
     */
    public suspend
    fun getVirtualMachineScaleSet(argument: suspend GetVirtualMachineScaleSetPlainArgsBuilder.() -> Unit):
        GetVirtualMachineScaleSetResult {
        val builder = GetVirtualMachineScaleSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScaleSetResultToKotlin(getVirtualMachineScaleSetPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2021-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine Scale Set Extension.
     */
    public suspend
    fun getVirtualMachineScaleSetExtension(argument: GetVirtualMachineScaleSetExtensionPlainArgs):
        GetVirtualMachineScaleSetExtensionResult =
        getVirtualMachineScaleSetExtensionResultToKotlin(getVirtualMachineScaleSetExtensionPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineScaleSetExtension].
     * @param expand The expand expression to apply on the operation.
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set containing the extension.
     * @param vmssExtensionName The name of the VM scale set extension.
     * @return Describes a Virtual Machine Scale Set Extension.
     */
    public suspend fun getVirtualMachineScaleSetExtension(
        expand: String? = null,
        resourceGroupName: String,
        vmScaleSetName: String,
        vmssExtensionName: String,
    ): GetVirtualMachineScaleSetExtensionResult {
        val argument = GetVirtualMachineScaleSetExtensionPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            vmScaleSetName = vmScaleSetName,
            vmssExtensionName = vmssExtensionName,
        )
        return getVirtualMachineScaleSetExtensionResultToKotlin(getVirtualMachineScaleSetExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineScaleSetExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineScaleSetExtensionPlainArgs].
     * @return Describes a Virtual Machine Scale Set Extension.
     */
    public suspend
    fun getVirtualMachineScaleSetExtension(argument: suspend GetVirtualMachineScaleSetExtensionPlainArgsBuilder.() -> Unit):
        GetVirtualMachineScaleSetExtensionResult {
        val builder = GetVirtualMachineScaleSetExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScaleSetExtensionResultToKotlin(getVirtualMachineScaleSetExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual machine from a VM scale set.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a virtual machine scale set virtual machine.
     */
    public suspend fun getVirtualMachineScaleSetVM(argument: GetVirtualMachineScaleSetVMPlainArgs):
        GetVirtualMachineScaleSetVMResult =
        getVirtualMachineScaleSetVMResultToKotlin(getVirtualMachineScaleSetVMPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineScaleSetVM].
     * @param expand The expand expression to apply on the operation. 'InstanceView' will retrieve the instance view of the virtual machine. 'UserData' will retrieve the UserData of the virtual machine.
     * @param instanceId The instance ID of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @return Describes a virtual machine scale set virtual machine.
     */
    public suspend fun getVirtualMachineScaleSetVM(
        expand: String? = null,
        instanceId: String,
        resourceGroupName: String,
        vmScaleSetName: String,
    ): GetVirtualMachineScaleSetVMResult {
        val argument = GetVirtualMachineScaleSetVMPlainArgs(
            expand = expand,
            instanceId = instanceId,
            resourceGroupName = resourceGroupName,
            vmScaleSetName = vmScaleSetName,
        )
        return getVirtualMachineScaleSetVMResultToKotlin(getVirtualMachineScaleSetVMPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineScaleSetVM].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineScaleSetVMPlainArgs].
     * @return Describes a virtual machine scale set virtual machine.
     */
    public suspend
    fun getVirtualMachineScaleSetVM(argument: suspend GetVirtualMachineScaleSetVMPlainArgsBuilder.() -> Unit):
        GetVirtualMachineScaleSetVMResult {
        val builder = GetVirtualMachineScaleSetVMPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScaleSetVMResultToKotlin(getVirtualMachineScaleSetVMPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the VMSS VM extension.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-12-01, 2021-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a VMSS VM Extension.
     */
    public suspend
    fun getVirtualMachineScaleSetVMExtension(argument: GetVirtualMachineScaleSetVMExtensionPlainArgs):
        GetVirtualMachineScaleSetVMExtensionResult =
        getVirtualMachineScaleSetVMExtensionResultToKotlin(getVirtualMachineScaleSetVMExtensionPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineScaleSetVMExtension].
     * @param expand The expand expression to apply on the operation.
     * @param instanceId The instance ID of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @param vmExtensionName The name of the virtual machine extension.
     * @param vmScaleSetName The name of the VM scale set.
     * @return Describes a VMSS VM Extension.
     */
    public suspend fun getVirtualMachineScaleSetVMExtension(
        expand: String? = null,
        instanceId: String,
        resourceGroupName: String,
        vmExtensionName: String,
        vmScaleSetName: String,
    ): GetVirtualMachineScaleSetVMExtensionResult {
        val argument = GetVirtualMachineScaleSetVMExtensionPlainArgs(
            expand = expand,
            instanceId = instanceId,
            resourceGroupName = resourceGroupName,
            vmExtensionName = vmExtensionName,
            vmScaleSetName = vmScaleSetName,
        )
        return getVirtualMachineScaleSetVMExtensionResultToKotlin(getVirtualMachineScaleSetVMExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineScaleSetVMExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineScaleSetVMExtensionPlainArgs].
     * @return Describes a VMSS VM Extension.
     */
    public suspend
    fun getVirtualMachineScaleSetVMExtension(argument: suspend GetVirtualMachineScaleSetVMExtensionPlainArgsBuilder.() -> Unit):
        GetVirtualMachineScaleSetVMExtensionResult {
        val builder = GetVirtualMachineScaleSetVMExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScaleSetVMExtensionResultToKotlin(getVirtualMachineScaleSetVMExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the VMSS VM run command.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
     * @param argument null
     * @return Describes a Virtual Machine run command.
     */
    public suspend
    fun getVirtualMachineScaleSetVMRunCommand(argument: GetVirtualMachineScaleSetVMRunCommandPlainArgs):
        GetVirtualMachineScaleSetVMRunCommandResult =
        getVirtualMachineScaleSetVMRunCommandResultToKotlin(getVirtualMachineScaleSetVMRunCommandPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineScaleSetVMRunCommand].
     * @param expand The expand expression to apply on the operation.
     * @param instanceId The instance ID of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @param runCommandName The name of the virtual machine run command.
     * @param vmScaleSetName The name of the VM scale set.
     * @return Describes a Virtual Machine run command.
     */
    public suspend fun getVirtualMachineScaleSetVMRunCommand(
        expand: String? = null,
        instanceId: String,
        resourceGroupName: String,
        runCommandName: String,
        vmScaleSetName: String,
    ): GetVirtualMachineScaleSetVMRunCommandResult {
        val argument = GetVirtualMachineScaleSetVMRunCommandPlainArgs(
            expand = expand,
            instanceId = instanceId,
            resourceGroupName = resourceGroupName,
            runCommandName = runCommandName,
            vmScaleSetName = vmScaleSetName,
        )
        return getVirtualMachineScaleSetVMRunCommandResultToKotlin(getVirtualMachineScaleSetVMRunCommandPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineScaleSetVMRunCommand].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;compute&#46;kotlin&#46;inputs&#46;GetVirtualMachineScaleSetVMRunCommandPlainArgs].
     * @return Describes a Virtual Machine run command.
     */
    public suspend
    fun getVirtualMachineScaleSetVMRunCommand(argument: suspend GetVirtualMachineScaleSetVMRunCommandPlainArgsBuilder.() -> Unit):
        GetVirtualMachineScaleSetVMRunCommandResult {
        val builder = GetVirtualMachineScaleSetVMRunCommandPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScaleSetVMRunCommandResultToKotlin(getVirtualMachineScaleSetVMRunCommandPlain(builtArgument.toJava()).await())
    }
}
