@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PropertyUpdatesInProgressResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ShareInfoElementResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse.Companion.toKotlin as creationDataResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse.Companion.toKotlin as diskSecurityProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSkuResponse.Companion.toKotlin as diskSkuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse.Companion.toKotlin as encryptionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse.Companion.toKotlin as encryptionSettingsCollectionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PropertyUpdatesInProgressResponse.Companion.toKotlin as propertyUpdatesInProgressResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin as purchasePlanResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ShareInfoElementResponse.Companion.toKotlin as shareInfoElementResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse.Companion.toKotlin as supportedCapabilitiesResponseToKotlin

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.azurenative.compute.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * Disk resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2018-06-01, 2019-07-01, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a confidential VM supported disk encrypted with customer managed key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecureVMDiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}",
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.ConfidentialVM_DiskEncryptedWithCustomerKey,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecureVMDiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
 * 				SecurityType:                pulumi.String(compute.DiskSecurityTypes_ConfidentialVM_DiskEncryptedWithCustomerKey),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .secureVMDiskEncryptionSetId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
 *                 .securityType("ConfidentialVM_DiskEncryptedWithCustomerKey")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskAccessId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}",
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         NetworkAccessPolicy = AzureNative.Compute.NetworkAccessPolicy.AllowPrivate,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskAccessId:        pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}"),
 * 			DiskName:            pulumi.String("myDisk"),
 * 			DiskSizeGB:          pulumi.Int(200),
 * 			Location:            pulumi.String("West US"),
 * 			NetworkAccessPolicy: pulumi.String(compute.NetworkAccessPolicyAllowPrivate),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskAccessId("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .networkAccessPolicy("AllowPrivate")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk encryption set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             DiskEncryptionSetId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				DiskEncryptionSetId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .encryption(EncryptionArgs.builder()
 *                 .diskEncryptionSetId("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by copying a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Copy,
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionCopy),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Copy")
 *                 .sourceResourceId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Import,
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionImport),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Import")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .storageAccountId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from the same subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Import,
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionImport),
 * 				SourceUri:    pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Import")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from ImportSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.ImportSecure,
 *             SecurityDataUri = "https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionImportSecure),
 * 				SecurityDataUri:  pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypes_ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("ImportSecure")
 *                 .securityDataUri("https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .storageAccountId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from UploadPreparedSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.UploadPreparedSecure,
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.TrustedLaunch,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUploadPreparedSecure),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypesTrustedLaunch),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("UploadPreparedSecure")
 *                 .uploadSizeBytes(10737418752)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from a platform image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery community image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 CommunityGalleryImageId = "/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					CommunityGalleryImageId: pulumi.String("/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .communityGalleryImageId("/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery direct shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 SharedGalleryImageId = "/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					SharedGalleryImageId: pulumi.String("/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .sharedGalleryImageId("/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an existing managed disk in the same or different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Copy,
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1",
 *         },
 *         DiskName = "myDisk2",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionCopy),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk2"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Copy")
 *                 .sourceResourceId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1")
 *                 .build())
 *             .diskName("myDisk2")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with dataAccessAuthMode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DataAccessAuthMode = AzureNative.Compute.DataAccessAuthMode.AzureActiveDirectory,
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DataAccessAuthMode: pulumi.String(compute.DataAccessAuthModeAzureActiveDirectory),
 * 			DiskName:           pulumi.String("myDisk"),
 * 			DiskSizeGB:         pulumi.Int(200),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .dataAccessAuthMode("AzureActiveDirectory")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with optimizedForFrequentAttach.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         OptimizedForFrequentAttach = true,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:                   pulumi.String("myDisk"),
 * 			DiskSizeGB:                 pulumi.Int(200),
 * 			Location:                   pulumi.String("West US"),
 * 			OptimizedForFrequentAttach: pulumi.Bool(true),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .optimizedForFrequentAttach(true)
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with performancePlus.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Upload,
 *             PerformancePlus = true,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUpload),
 * 				PerformancePlus: pulumi.Bool(true),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Upload")
 *                 .performancePlus(true)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with premium v2 account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myPremiumV2Disk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.PremiumV2_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myPremiumV2Disk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_PremiumV2_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myPremiumV2Disk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("PremiumV2_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with security profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "North Central US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.TrustedLaunch,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("North Central US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypesTrustedLaunch),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("North Central US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ssd zrs account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.Premium_ZRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_Premium_ZRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("Premium_ZRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ultra account type with readOnly property set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *             LogicalSectorSize = 4096,
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myUltraReadOnlyDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             Type = AzureNative.Compute.EncryptionType.EncryptionAtRestWithPlatformKey,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.UltraSSD_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String(compute.DiskCreateOptionEmpty),
 * 				LogicalSectorSize: pulumi.Int(4096),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myUltraReadOnlyDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				Type: pulumi.String(compute.EncryptionTypeEncryptionAtRestWithPlatformKey),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_UltraSSD_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .logicalSectorSize(4096)
 *                 .build())
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myUltraReadOnlyDisk")
 *             .diskSizeGB(200)
 *             .encryption(EncryptionArgs.builder()
 *                 .type("EncryptionAtRestWithPlatformKey")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("UltraSSD_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed upload disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Upload,
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUpload),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Upload")
 *                 .uploadSizeBytes(10737418752)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk in extended location.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         ExtendedLocation = new AzureNative.Compute.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "{edge-zone-id}",
 *             Type = AzureNative.Compute.ExtendedLocationTypes.EdgeZone,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			ExtendedLocation: &compute.ExtendedLocationArgs{
 * 				Name: pulumi.String("{edge-zone-id}"),
 * 				Type: pulumi.String(compute.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("{edge-zone-id}")
 *                 .type("EdgeZone")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ultra managed disk with logicalSectorSize 512E
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *             LogicalSectorSize = 512,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.UltraSSD_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String(compute.DiskCreateOptionEmpty),
 * 				LogicalSectorSize: pulumi.Int(512),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_UltraSSD_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .logicalSectorSize(512)
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("UltraSSD_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Disk myDisk /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}
 * ```
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    /**
     * Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
     */
    public val burstingEnabled: Output<Boolean>?
        get() = javaResource.burstingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Latest time when bursting was last enabled on a disk.
     */
    public val burstingEnabledTime: Output<String>
        get() = javaResource.burstingEnabledTime().applyValue({ args0 -> args0 })

    /**
     * Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    public val completionPercent: Output<Double>?
        get() = javaResource.completionPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    public val creationData: Output<CreationDataResponse>
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.let({ args0 ->
                creationDataResponseToKotlin(args0)
            })
        })

    /**
     * Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    public val dataAccessAuthMode: Output<String>?
        get() = javaResource.dataAccessAuthMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    public val diskAccessId: Output<String>?
        get() = javaResource.diskAccessId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
     */
    public val diskIOPSReadOnly: Output<Double>?
        get() = javaResource.diskIOPSReadOnly().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
     */
    public val diskIOPSReadWrite: Output<Double>?
        get() = javaResource.diskIOPSReadWrite().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    public val diskMBpsReadOnly: Output<Double>?
        get() = javaResource.diskMBpsReadOnly().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    public val diskMBpsReadWrite: Output<Double>?
        get() = javaResource.diskMBpsReadWrite().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the disk in bytes. This field is read only.
     */
    public val diskSizeBytes: Output<Double>
        get() = javaResource.diskSizeBytes().applyValue({ args0 -> args0 })

    /**
     * If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    public val diskSizeGB: Output<Int>?
        get() = javaResource.diskSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the disk.
     */
    public val diskState: Output<String>
        get() = javaResource.diskState().applyValue({ args0 -> args0 })

    /**
     * Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    public val encryption: Output<EncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    public val encryptionSettingsCollection: Output<EncryptionSettingsCollectionResponse>?
        get() = javaResource.encryptionSettingsCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> encryptionSettingsCollectionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The extended location where the disk will be created. Extended location cannot be changed.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * A relative URI containing the ID of the VM that has the disk attached.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * List of relative URIs containing the IDs of the VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
     */
    public val managedByExtended: Output<List<String>>
        get() = javaResource.managedByExtended().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
     */
    public val maxShares: Output<Int>?
        get() = javaResource.maxShares().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy for accessing the disk via network.
     */
    public val networkAccessPolicy: Output<String>?
        get() = javaResource.networkAccessPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
     */
    public val optimizedForFrequentAttach: Output<Boolean>?
        get() = javaResource.optimizedForFrequentAttach().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Operating System type.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Properties of the disk for which update is pending.
     */
    public val propertyUpdatesInProgress: Output<PropertyUpdatesInProgressResponse>
        get() = javaResource.propertyUpdatesInProgress().applyValue({ args0 ->
            args0.let({ args0 ->
                propertyUpdatesInProgressResponseToKotlin(args0)
            })
        })

    /**
     * The disk provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Policy for controlling export on the disk.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    public val purchasePlan: Output<PurchasePlanResponse>?
        get() = javaResource.purchasePlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    purchasePlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains the security related information for the resource.
     */
    public val securityProfile: Output<DiskSecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diskSecurityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Details of the list of all VMs that have the disk attached. maxShares should be set to a value greater than one for disks to allow attaching them to multiple VMs.
     */
    public val shareInfo: Output<List<ShareInfoElementResponse>>
        get() = javaResource.shareInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    shareInfoElementResponseToKotlin(args0)
                })
            })
        })

    /**
     * The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    public val sku: Output<DiskSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    diskSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of supported capabilities for the image from which the OS disk was created.
     */
    public val supportedCapabilities: Output<SupportedCapabilitiesResponse>?
        get() = javaResource.supportedCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> supportedCapabilitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Indicates the OS on a disk supports hibernation.
     */
    public val supportsHibernation: Output<Boolean>?
        get() = javaResource.supportsHibernation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time when the disk was created.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique Guid identifying the resource.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })

    /**
     * The Logical zone list for Disk.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.azurenative.compute.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
