@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DataAccessAuthMode
import com.pulumi.azurenative.compute.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.compute.kotlin.enums.NetworkAccessPolicy
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.compute.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSkuArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Disk resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2018-06-01, 2019-07-01, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a confidential VM supported disk encrypted with customer managed key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecureVMDiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}",
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.ConfidentialVM_DiskEncryptedWithCustomerKey,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecureVMDiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
 * 				SecurityType:                pulumi.String(compute.DiskSecurityTypes_ConfidentialVM_DiskEncryptedWithCustomerKey),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .secureVMDiskEncryptionSetId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
 *                 .securityType("ConfidentialVM_DiskEncryptedWithCustomerKey")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskAccessId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}",
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         NetworkAccessPolicy = AzureNative.Compute.NetworkAccessPolicy.AllowPrivate,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskAccessId:        pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}"),
 * 			DiskName:            pulumi.String("myDisk"),
 * 			DiskSizeGB:          pulumi.Int(200),
 * 			Location:            pulumi.String("West US"),
 * 			NetworkAccessPolicy: pulumi.String(compute.NetworkAccessPolicyAllowPrivate),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskAccessId("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .networkAccessPolicy("AllowPrivate")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk encryption set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             DiskEncryptionSetId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				DiskEncryptionSetId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .encryption(EncryptionArgs.builder()
 *                 .diskEncryptionSetId("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by copying a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Copy,
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionCopy),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Copy")
 *                 .sourceResourceId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Import,
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionImport),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Import")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .storageAccountId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from the same subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Import,
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionImport),
 * 				SourceUri:    pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Import")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from ImportSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.ImportSecure,
 *             SecurityDataUri = "https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionImportSecure),
 * 				SecurityDataUri:  pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypes_ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("ImportSecure")
 *                 .securityDataUri("https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd")
 *                 .sourceUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                 .storageAccountId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from UploadPreparedSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.UploadPreparedSecure,
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.TrustedLaunch,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUploadPreparedSecure),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypesTrustedLaunch),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("UploadPreparedSecure")
 *                 .uploadSizeBytes(10737418752)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from a platform image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery community image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 CommunityGalleryImageId = "/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					CommunityGalleryImageId: pulumi.String("/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .communityGalleryImageId("/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery direct shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 SharedGalleryImageId = "/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					SharedGalleryImageId: pulumi.String("/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .sharedGalleryImageId("/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .galleryImageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an existing managed disk in the same or different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Copy,
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1",
 *         },
 *         DiskName = "myDisk2",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String(compute.DiskCreateOptionCopy),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk2"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Copy")
 *                 .sourceResourceId("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1")
 *                 .build())
 *             .diskName("myDisk2")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with dataAccessAuthMode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DataAccessAuthMode = AzureNative.Compute.DataAccessAuthMode.AzureActiveDirectory,
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DataAccessAuthMode: pulumi.String(compute.DataAccessAuthModeAzureActiveDirectory),
 * 			DiskName:           pulumi.String("myDisk"),
 * 			DiskSizeGB:         pulumi.Int(200),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .dataAccessAuthMode("AzureActiveDirectory")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with optimizedForFrequentAttach.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         OptimizedForFrequentAttach = true,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:                   pulumi.String("myDisk"),
 * 			DiskSizeGB:                 pulumi.Int(200),
 * 			Location:                   pulumi.String("West US"),
 * 			OptimizedForFrequentAttach: pulumi.Bool(true),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .optimizedForFrequentAttach(true)
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with performancePlus.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Upload,
 *             PerformancePlus = true,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUpload),
 * 				PerformancePlus: pulumi.Bool(true),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Upload")
 *                 .performancePlus(true)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with premium v2 account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myPremiumV2Disk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.PremiumV2_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myPremiumV2Disk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_PremiumV2_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myPremiumV2Disk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("PremiumV2_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with security profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.FromImage,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "North Central US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.DiskSecurityTypes.TrustedLaunch,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionFromImage),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("North Central US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.DiskSecurityTypesTrustedLaunch),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("FromImage")
 *                 .imageReference(ImageDiskReferenceArgs.builder()
 *                     .id("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}")
 *                     .build())
 *                 .build())
 *             .diskName("myDisk")
 *             .location("North Central US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(DiskSecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ssd zrs account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.Premium_ZRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_Premium_ZRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("Premium_ZRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ultra account type with readOnly property set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *             LogicalSectorSize = 4096,
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myUltraReadOnlyDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             Type = AzureNative.Compute.EncryptionType.EncryptionAtRestWithPlatformKey,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.UltraSSD_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String(compute.DiskCreateOptionEmpty),
 * 				LogicalSectorSize: pulumi.Int(4096),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myUltraReadOnlyDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				Type: pulumi.String(compute.EncryptionTypeEncryptionAtRestWithPlatformKey),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_UltraSSD_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .logicalSectorSize(4096)
 *                 .build())
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myUltraReadOnlyDisk")
 *             .diskSizeGB(200)
 *             .encryption(EncryptionArgs.builder()
 *                 .type("EncryptionAtRestWithPlatformKey")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("UltraSSD_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed upload disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Upload,
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String(compute.DiskCreateOptionUpload),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Upload")
 *                 .uploadSizeBytes(10737418752)
 *                 .build())
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk in extended location.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         ExtendedLocation = new AzureNative.Compute.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "{edge-zone-id}",
 *             Type = AzureNative.Compute.ExtendedLocationTypes.EdgeZone,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			ExtendedLocation: &compute.ExtendedLocationArgs{
 * 				Name: pulumi.String("{edge-zone-id}"),
 * 				Type: pulumi.String(compute.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("{edge-zone-id}")
 *                 .type("EdgeZone")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String(compute.DiskCreateOptionEmpty),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ultra managed disk with logicalSectorSize 512E
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = AzureNative.Compute.DiskCreateOption.Empty,
 *             LogicalSectorSize = 512,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = AzureNative.Compute.DiskStorageAccountTypes.UltraSSD_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String(compute.DiskCreateOptionEmpty),
 * 				LogicalSectorSize: pulumi.Int(512),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String(compute.DiskStorageAccountTypes_UltraSSD_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import com.pulumi.azurenative.compute.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(CreationDataArgs.builder()
 *                 .createOption("Empty")
 *                 .logicalSectorSize(512)
 *                 .build())
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(DiskSkuArgs.builder()
 *                 .name("UltraSSD_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Disk myDisk /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}
 * ```
 * @property burstingEnabled Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
 * @property completionPercent Percentage complete for the background copy when a resource is created via the CopyStart operation.
 * @property creationData Disk source information. CreationData information cannot be changed after the disk has been created.
 * @property dataAccessAuthMode Additional authentication requirements when exporting or uploading to a disk or snapshot.
 * @property diskAccessId ARM id of the DiskAccess resource for using private endpoints on disks.
 * @property diskIOPSReadOnly The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
 * @property diskIOPSReadWrite The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
 * @property diskMBpsReadOnly The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskMBpsReadWrite The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskName The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property diskSizeGB If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
 * @property encryption Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
 * @property encryptionSettingsCollection Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
 * @property extendedLocation The extended location where the disk will be created. Extended location cannot be changed.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property location Resource location
 * @property maxShares The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
 * @property networkAccessPolicy Policy for accessing the disk via network.
 * @property optimizedForFrequentAttach Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
 * @property osType The Operating System type.
 * @property publicNetworkAccess Policy for controlling export on the disk.
 * @property purchasePlan Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
 * @property resourceGroupName The name of the resource group.
 * @property securityProfile Contains the security related information for the resource.
 * @property sku The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
 * @property supportedCapabilities List of supported capabilities for the image from which the OS disk was created.
 * @property supportsHibernation Indicates the OS on a disk supports hibernation.
 * @property tags Resource tags
 * @property tier Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
 * @property zones The Logical zone list for Disk.
 */
public data class DiskArgs(
    public val burstingEnabled: Output<Boolean>? = null,
    public val completionPercent: Output<Double>? = null,
    public val creationData: Output<CreationDataArgs>? = null,
    public val dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null,
    public val diskAccessId: Output<String>? = null,
    public val diskIOPSReadOnly: Output<Double>? = null,
    public val diskIOPSReadWrite: Output<Double>? = null,
    public val diskMBpsReadOnly: Output<Double>? = null,
    public val diskMBpsReadWrite: Output<Double>? = null,
    public val diskName: Output<String>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val location: Output<String>? = null,
    public val maxShares: Output<Int>? = null,
    public val networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null,
    public val optimizedForFrequentAttach: Output<Boolean>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val purchasePlan: Output<PurchasePlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityProfile: Output<DiskSecurityProfileArgs>? = null,
    public val sku: Output<DiskSkuArgs>? = null,
    public val supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null,
    public val supportsHibernation: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tier: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DiskArgs =
        com.pulumi.azurenative.compute.DiskArgs.builder()
            .burstingEnabled(burstingEnabled?.applyValue({ args0 -> args0 }))
            .completionPercent(completionPercent?.applyValue({ args0 -> args0 }))
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataAccessAuthMode(
                dataAccessAuthMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .diskAccessId(diskAccessId?.applyValue({ args0 -> args0 }))
            .diskIOPSReadOnly(diskIOPSReadOnly?.applyValue({ args0 -> args0 }))
            .diskIOPSReadWrite(diskIOPSReadWrite?.applyValue({ args0 -> args0 }))
            .diskMBpsReadOnly(diskMBpsReadOnly?.applyValue({ args0 -> args0 }))
            .diskMBpsReadWrite(diskMBpsReadWrite?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionSettingsCollection(
                encryptionSettingsCollection?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maxShares(maxShares?.applyValue({ args0 -> args0 }))
            .networkAccessPolicy(
                networkAccessPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .optimizedForFrequentAttach(optimizedForFrequentAttach?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .purchasePlan(purchasePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportedCapabilities(
                supportedCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .supportsHibernation(supportsHibernation?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var burstingEnabled: Output<Boolean>? = null

    private var completionPercent: Output<Double>? = null

    private var creationData: Output<CreationDataArgs>? = null

    private var dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null

    private var diskAccessId: Output<String>? = null

    private var diskIOPSReadOnly: Output<Double>? = null

    private var diskIOPSReadWrite: Output<Double>? = null

    private var diskMBpsReadOnly: Output<Double>? = null

    private var diskMBpsReadWrite: Output<Double>? = null

    private var diskName: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var location: Output<String>? = null

    private var maxShares: Output<Int>? = null

    private var networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null

    private var optimizedForFrequentAttach: Output<Boolean>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var purchasePlan: Output<PurchasePlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityProfile: Output<DiskSecurityProfileArgs>? = null

    private var sku: Output<DiskSkuArgs>? = null

    private var supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null

    private var supportsHibernation: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tier: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
     */
    @JvmName("tlipnqrkfrnijerx")
    public suspend fun burstingEnabled(`value`: Output<Boolean>) {
        this.burstingEnabled = value
    }

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("vrhwjaphivrfqdog")
    public suspend fun completionPercent(`value`: Output<Double>) {
        this.completionPercent = value
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("akjyvvqknqfdnlax")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("ryodjtdkaeldkbxm")
    public suspend fun dataAccessAuthMode(`value`: Output<Either<String, DataAccessAuthMode>>) {
        this.dataAccessAuthMode = value
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("texbcuvirvrhkckw")
    public suspend fun diskAccessId(`value`: Output<String>) {
        this.diskAccessId = value
    }

    /**
     * @param value The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("jdidbqqbxcncahib")
    public suspend fun diskIOPSReadOnly(`value`: Output<Double>) {
        this.diskIOPSReadOnly = value
    }

    /**
     * @param value The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("uafwigexclahtfjd")
    public suspend fun diskIOPSReadWrite(`value`: Output<Double>) {
        this.diskIOPSReadWrite = value
    }

    /**
     * @param value The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("uynqflbxxvedenkl")
    public suspend fun diskMBpsReadOnly(`value`: Output<Double>) {
        this.diskMBpsReadOnly = value
    }

    /**
     * @param value The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("yivhlklptwqgacpi")
    public suspend fun diskMBpsReadWrite(`value`: Output<Double>) {
        this.diskMBpsReadWrite = value
    }

    /**
     * @param value The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("qagipranamdlsdar")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("huxxwaraxfcyuito")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("venumkwjfdmqojje")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("cfeqjpmneotkspms")
    public suspend
    fun encryptionSettingsCollection(`value`: Output<EncryptionSettingsCollectionArgs>) {
        this.encryptionSettingsCollection = value
    }

    /**
     * @param value The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("gwvlykilrohdpxtm")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("percuwcxnxvahxbk")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("pfebucwiseasridd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
     */
    @JvmName("puwdbaoagljoanuv")
    public suspend fun maxShares(`value`: Output<Int>) {
        this.maxShares = value
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("fxdkplukbmayhgnb")
    public suspend fun networkAccessPolicy(`value`: Output<Either<String, NetworkAccessPolicy>>) {
        this.networkAccessPolicy = value
    }

    /**
     * @param value Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
     */
    @JvmName("bkvrmfpyivtocjjb")
    public suspend fun optimizedForFrequentAttach(`value`: Output<Boolean>) {
        this.optimizedForFrequentAttach = value
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("ufyexpnnovqvtpft")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("kxjhbxhmovkxvgxp")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("ndclfwbvdaxievqq")
    public suspend fun purchasePlan(`value`: Output<PurchasePlanArgs>) {
        this.purchasePlan = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rbnynjspwoosxfqu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("qexavhippsviexid")
    public suspend fun securityProfile(`value`: Output<DiskSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("pjtpnbcmwisxpuiv")
    public suspend fun sku(`value`: Output<DiskSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("rcmusnqyjmycydiv")
    public suspend fun supportedCapabilities(`value`: Output<SupportedCapabilitiesArgs>) {
        this.supportedCapabilities = value
    }

    /**
     * @param value Indicates the OS on a disk supports hibernation.
     */
    @JvmName("wemyyrjisvmrcbaj")
    public suspend fun supportsHibernation(`value`: Output<Boolean>) {
        this.supportsHibernation = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("glxebdehwtnpnsln")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
     */
    @JvmName("mbixgrvngqqwfqfd")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The Logical zone list for Disk.
     */
    @JvmName("tvtnfsvqdlakrkih")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("ossidysucjcqolon")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The Logical zone list for Disk.
     */
    @JvmName("emlvknaavmjpnget")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
     */
    @JvmName("hpqaltifduutihqa")
    public suspend fun burstingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstingEnabled = mapped
    }

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("bnprogrrsofwmbga")
    public suspend fun completionPercent(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionPercent = mapped
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("jumnbugbwdnbgpkb")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("aisfikflolefbghs")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("uvefvehdpnbuuovs")
    public suspend fun dataAccessAuthMode(`value`: Either<String, DataAccessAuthMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("rljfmiqhytwdkmep")
    public fun dataAccessAuthMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("glddffejfuaytbfx")
    public fun dataAccessAuthMode(`value`: DataAccessAuthMode) {
        val toBeMapped = Either.ofRight<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("lwyknhwevldsicon")
    public suspend fun diskAccessId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAccessId = mapped
    }

    /**
     * @param value The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("hhxfiyombwxgwmao")
    public suspend fun diskIOPSReadOnly(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIOPSReadOnly = mapped
    }

    /**
     * @param value The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("aqcpikbntkuldebu")
    public suspend fun diskIOPSReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIOPSReadWrite = mapped
    }

    /**
     * @param value The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("clxykfowenbceeuv")
    public suspend fun diskMBpsReadOnly(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMBpsReadOnly = mapped
    }

    /**
     * @param value The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("kggxaeymhylhqdlp")
    public suspend fun diskMBpsReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMBpsReadWrite = mapped
    }

    /**
     * @param value The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("udcqtpmtbioybjpq")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("sjvcvtjkaacscjpf")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("swsbrevgnahcbvke")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("iyufxwibanlhlyxk")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("vfggscepyxytmlge")
    public suspend fun encryptionSettingsCollection(`value`: EncryptionSettingsCollectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param argument Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("mtsswfutbxsvkbtf")
    public suspend
    fun encryptionSettingsCollection(argument: suspend EncryptionSettingsCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionSettingsCollectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param value The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("ayktowndlrevpjxl")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("thkwffaavnrykjek")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("atjokyqqpgdiamei")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("rmkffsrfdrpybngi")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("okobfiniaqionfvj")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("mfigiaidkrrkgaii")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
     */
    @JvmName("oxehdygrcxvlkwdr")
    public suspend fun maxShares(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxShares = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("rduimvrqivfyvixo")
    public suspend fun networkAccessPolicy(`value`: Either<String, NetworkAccessPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("ebyfphxrayovglun")
    public fun networkAccessPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("ajpdaaieqqqtarco")
    public fun networkAccessPolicy(`value`: NetworkAccessPolicy) {
        val toBeMapped = Either.ofRight<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
     */
    @JvmName("rqhfwyxlumktcjfr")
    public suspend fun optimizedForFrequentAttach(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizedForFrequentAttach = mapped
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("gwqriowdfybsivif")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("qronveyvcsmueiwi")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("twaxnykflxnbbyrc")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("ftcliwngtwlbkkvp")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("vvswhuloeggbcetx")
    public suspend fun purchasePlan(`value`: PurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purchasePlan = mapped
    }

    /**
     * @param argument Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("pcuxmdxntaekfetr")
    public suspend fun purchasePlan(argument: suspend PurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = PurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purchasePlan = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vknhrqwklfjqpxxb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("xcjurmgteiwcqhlu")
    public suspend fun securityProfile(`value`: DiskSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Contains the security related information for the resource.
     */
    @JvmName("wlxettsoblbgwlsn")
    public suspend fun securityProfile(argument: suspend DiskSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("yxlqjberiufplarn")
    public suspend fun sku(`value`: DiskSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("fjcblxstvvmqfuwd")
    public suspend fun sku(argument: suspend DiskSkuArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("nlhymtxrespnhafx")
    public suspend fun supportedCapabilities(`value`: SupportedCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedCapabilities = mapped
    }

    /**
     * @param argument List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("bfhkggcsrjagnoxs")
    public suspend
    fun supportedCapabilities(argument: suspend SupportedCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = SupportedCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.supportedCapabilities = mapped
    }

    /**
     * @param value Indicates the OS on a disk supports hibernation.
     */
    @JvmName("esuicgsmrowoekwc")
    public suspend fun supportsHibernation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportsHibernation = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("aoouqierqqaiykll")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("vtuhtasjmhgahset")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
     */
    @JvmName("bgotdkyyyvyduynb")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The Logical zone list for Disk.
     */
    @JvmName("ddduwugrunbvnctb")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The Logical zone list for Disk.
     */
    @JvmName("rokiouilmugdtyhk")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        burstingEnabled = burstingEnabled,
        completionPercent = completionPercent,
        creationData = creationData,
        dataAccessAuthMode = dataAccessAuthMode,
        diskAccessId = diskAccessId,
        diskIOPSReadOnly = diskIOPSReadOnly,
        diskIOPSReadWrite = diskIOPSReadWrite,
        diskMBpsReadOnly = diskMBpsReadOnly,
        diskMBpsReadWrite = diskMBpsReadWrite,
        diskName = diskName,
        diskSizeGB = diskSizeGB,
        encryption = encryption,
        encryptionSettingsCollection = encryptionSettingsCollection,
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        location = location,
        maxShares = maxShares,
        networkAccessPolicy = networkAccessPolicy,
        optimizedForFrequentAttach = optimizedForFrequentAttach,
        osType = osType,
        publicNetworkAccess = publicNetworkAccess,
        purchasePlan = purchasePlan,
        resourceGroupName = resourceGroupName,
        securityProfile = securityProfile,
        sku = sku,
        supportedCapabilities = supportedCapabilities,
        supportsHibernation = supportsHibernation,
        tags = tags,
        tier = tier,
        zones = zones,
    )
}
