@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DiskEncryptionSetArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskEncryptionSetType
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSetIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSetIdentityArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.KeyForDiskEncryptionSetArgs
import com.pulumi.azurenative.compute.kotlin.inputs.KeyForDiskEncryptionSetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * disk encryption set resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-06-30, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a disk encryption set with key vault from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskEncryptionSet = new AzureNative.Compute.DiskEncryptionSet("diskEncryptionSet", new()
 *     {
 *         ActiveKey = new AzureNative.Compute.Inputs.KeyForDiskEncryptionSetArgs
 *         {
 *             KeyUrl = "https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}",
 *         },
 *         DiskEncryptionSetName = "myDiskEncryptionSet",
 *         EncryptionType = AzureNative.Compute.DiskEncryptionSetType.EncryptionAtRestWithCustomerKey,
 *         Identity = new AzureNative.Compute.Inputs.EncryptionSetIdentityArgs
 *         {
 *             Type = AzureNative.Compute.DiskEncryptionSetIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskEncryptionSet(ctx, "diskEncryptionSet", &compute.DiskEncryptionSetArgs{
 * 			ActiveKey: &compute.KeyForDiskEncryptionSetArgs{
 * 				KeyUrl: pulumi.String("https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}"),
 * 			},
 * 			DiskEncryptionSetName: pulumi.String("myDiskEncryptionSet"),
 * 			EncryptionType:        pulumi.String(compute.DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey),
 * 			Identity: &compute.EncryptionSetIdentityArgs{
 * 				Type: pulumi.String(compute.DiskEncryptionSetIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskEncryptionSet;
 * import com.pulumi.azurenative.compute.DiskEncryptionSetArgs;
 * import com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionSetIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskEncryptionSet = new DiskEncryptionSet("diskEncryptionSet", DiskEncryptionSetArgs.builder()
 *             .activeKey(KeyForDiskEncryptionSetArgs.builder()
 *                 .keyUrl("https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}")
 *                 .build())
 *             .diskEncryptionSetName("myDiskEncryptionSet")
 *             .encryptionType("EncryptionAtRestWithCustomerKey")
 *             .identity(EncryptionSetIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a disk encryption set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskEncryptionSet = new AzureNative.Compute.DiskEncryptionSet("diskEncryptionSet", new()
 *     {
 *         ActiveKey = new AzureNative.Compute.Inputs.KeyForDiskEncryptionSetArgs
 *         {
 *             KeyUrl = "https://myvmvault.vault-int.azure-int.net/keys/{key}",
 *             SourceVault = new AzureNative.Compute.Inputs.SourceVaultArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault",
 *             },
 *         },
 *         DiskEncryptionSetName = "myDiskEncryptionSet",
 *         EncryptionType = AzureNative.Compute.DiskEncryptionSetType.EncryptionAtRestWithCustomerKey,
 *         Identity = new AzureNative.Compute.Inputs.EncryptionSetIdentityArgs
 *         {
 *             Type = AzureNative.Compute.DiskEncryptionSetIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskEncryptionSet(ctx, "diskEncryptionSet", &compute.DiskEncryptionSetArgs{
 * 			ActiveKey: &compute.KeyForDiskEncryptionSetArgs{
 * 				KeyUrl: pulumi.String("https://myvmvault.vault-int.azure-int.net/keys/{key}"),
 * 				SourceVault: &compute.SourceVaultArgs{
 * 					Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault"),
 * 				},
 * 			},
 * 			DiskEncryptionSetName: pulumi.String("myDiskEncryptionSet"),
 * 			EncryptionType:        pulumi.String(compute.DiskEncryptionSetTypeEncryptionAtRestWithCustomerKey),
 * 			Identity: &compute.EncryptionSetIdentityArgs{
 * 				Type: pulumi.String(compute.DiskEncryptionSetIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskEncryptionSet;
 * import com.pulumi.azurenative.compute.DiskEncryptionSetArgs;
 * import com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SourceVaultArgs;
 * import com.pulumi.azurenative.compute.inputs.EncryptionSetIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskEncryptionSet = new DiskEncryptionSet("diskEncryptionSet", DiskEncryptionSetArgs.builder()
 *             .activeKey(KeyForDiskEncryptionSetArgs.builder()
 *                 .keyUrl("https://myvmvault.vault-int.azure-int.net/keys/{key}")
 *                 .sourceVault(SourceVaultArgs.builder()
 *                     .id("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault")
 *                     .build())
 *                 .build())
 *             .diskEncryptionSetName("myDiskEncryptionSet")
 *             .encryptionType("EncryptionAtRestWithCustomerKey")
 *             .identity(EncryptionSetIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DiskEncryptionSet myDiskEncryptionSet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}
 * ```
 * @property activeKey The key vault key which is currently used by this disk encryption set.
 * @property diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property encryptionType The type of key used to encrypt the data of the disk.
 * @property federatedClientId Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the property.
 * @property identity The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property rotationToLatestKeyVersionEnabled Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
 * @property tags Resource tags
 */
public data class DiskEncryptionSetArgs(
    public val activeKey: Output<KeyForDiskEncryptionSetArgs>? = null,
    public val diskEncryptionSetName: Output<String>? = null,
    public val encryptionType: Output<Either<String, DiskEncryptionSetType>>? = null,
    public val federatedClientId: Output<String>? = null,
    public val identity: Output<EncryptionSetIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rotationToLatestKeyVersionEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DiskEncryptionSetArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DiskEncryptionSetArgs =
        com.pulumi.azurenative.compute.DiskEncryptionSetArgs.builder()
            .activeKey(activeKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskEncryptionSetName(diskEncryptionSetName?.applyValue({ args0 -> args0 }))
            .encryptionType(
                encryptionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .federatedClientId(federatedClientId?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rotationToLatestKeyVersionEnabled(
                rotationToLatestKeyVersionEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiskEncryptionSetArgs].
 */
@PulumiTagMarker
public class DiskEncryptionSetArgsBuilder internal constructor() {
    private var activeKey: Output<KeyForDiskEncryptionSetArgs>? = null

    private var diskEncryptionSetName: Output<String>? = null

    private var encryptionType: Output<Either<String, DiskEncryptionSetType>>? = null

    private var federatedClientId: Output<String>? = null

    private var identity: Output<EncryptionSetIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rotationToLatestKeyVersionEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The key vault key which is currently used by this disk encryption set.
     */
    @JvmName("xwqlnfojlgabopvw")
    public suspend fun activeKey(`value`: Output<KeyForDiskEncryptionSetArgs>) {
        this.activeKey = value
    }

    /**
     * @param value The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("dvuxblwchwfmdmoj")
    public suspend fun diskEncryptionSetName(`value`: Output<String>) {
        this.diskEncryptionSetName = value
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("rndwrtwghwvambby")
    public suspend fun encryptionType(`value`: Output<Either<String, DiskEncryptionSetType>>) {
        this.encryptionType = value
    }

    /**
     * @param value Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the property.
     */
    @JvmName("sooxrjdkdxmcidlr")
    public suspend fun federatedClientId(`value`: Output<String>) {
        this.federatedClientId = value
    }

    /**
     * @param value The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
     */
    @JvmName("vkduarfbhigemtah")
    public suspend fun identity(`value`: Output<EncryptionSetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ykpraotmmnmqqkpf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rtoqljwidnjgbobg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
     */
    @JvmName("gljchbfnopsbbxtw")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Output<Boolean>) {
        this.rotationToLatestKeyVersionEnabled = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("favwmgkwienoayne")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The key vault key which is currently used by this disk encryption set.
     */
    @JvmName("jjrlxugvhqfjeqla")
    public suspend fun activeKey(`value`: KeyForDiskEncryptionSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeKey = mapped
    }

    /**
     * @param argument The key vault key which is currently used by this disk encryption set.
     */
    @JvmName("wdksvpngkdildotf")
    public suspend fun activeKey(argument: suspend KeyForDiskEncryptionSetArgsBuilder.() -> Unit) {
        val toBeMapped = KeyForDiskEncryptionSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activeKey = mapped
    }

    /**
     * @param value The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("ekekirwxhqdnuhrw")
    public suspend fun diskEncryptionSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetName = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("ggmkjhmhjfujjaff")
    public suspend fun encryptionType(`value`: Either<String, DiskEncryptionSetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("uvgybgvqpibffman")
    public fun encryptionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskEncryptionSetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("swkhvwatuacrblrt")
    public fun encryptionType(`value`: DiskEncryptionSetType) {
        val toBeMapped = Either.ofRight<String, DiskEncryptionSetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the property.
     */
    @JvmName("mghyagqdnwrkrjjo")
    public suspend fun federatedClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.federatedClientId = mapped
    }

    /**
     * @param value The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
     */
    @JvmName("mfpvlqujgurxwdtk")
    public suspend fun identity(`value`: EncryptionSetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
     */
    @JvmName("xtesohqalqthutbo")
    public suspend fun identity(argument: suspend EncryptionSetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionSetIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("yxnymocthumcqdpt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eiogctgbotwyfqeu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
     */
    @JvmName("ehgiuiwvhsbkqagj")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationToLatestKeyVersionEnabled = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ibqljbpsjxuysocm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("nplyeucqxsjjkwqf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiskEncryptionSetArgs = DiskEncryptionSetArgs(
        activeKey = activeKey,
        diskEncryptionSetName = diskEncryptionSetName,
        encryptionType = encryptionType,
        federatedClientId = federatedClientId,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled,
        tags = tags,
    )
}
