@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.GalleryApplicationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationCustomActionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationCustomActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the gallery Application Definition that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple gallery Application.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryApplication = new AzureNative.Compute.GalleryApplication("galleryApplication", new()
 *     {
 *         CustomActions = new[]
 *         {
 *             new AzureNative.Compute.Inputs.GalleryApplicationCustomActionArgs
 *             {
 *                 Description = "This is the custom action description.",
 *                 Name = "myCustomAction",
 *                 Parameters = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.GalleryApplicationCustomActionParameterArgs
 *                     {
 *                         DefaultValue = "default value of parameter.",
 *                         Description = "This is the description of the parameter",
 *                         Name = "myCustomActionParameter",
 *                         Required = false,
 *                         Type = AzureNative.Compute.GalleryApplicationCustomActionParameterType.String,
 *                     },
 *                 },
 *                 Script = "myCustomActionScript",
 *             },
 *         },
 *         Description = "This is the gallery application description.",
 *         Eula = "This is the gallery application EULA.",
 *         GalleryApplicationName = "myGalleryApplicationName",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PrivacyStatementUri = "myPrivacyStatementUri}",
 *         ReleaseNoteUri = "myReleaseNoteUri",
 *         ResourceGroupName = "myResourceGroup",
 *         SupportedOSType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryApplication(ctx, "galleryApplication", &compute.GalleryApplicationArgs{
 * 			CustomActions: compute.GalleryApplicationCustomActionArray{
 * 				&compute.GalleryApplicationCustomActionArgs{
 * 					Description: pulumi.String("This is the custom action description."),
 * 					Name:        pulumi.String("myCustomAction"),
 * 					Parameters: compute.GalleryApplicationCustomActionParameterArray{
 * 						&compute.GalleryApplicationCustomActionParameterArgs{
 * 							DefaultValue: pulumi.String("default value of parameter."),
 * 							Description:  pulumi.String("This is the description of the parameter"),
 * 							Name:         pulumi.String("myCustomActionParameter"),
 * 							Required:     pulumi.Bool(false),
 * 							Type:         compute.GalleryApplicationCustomActionParameterTypeString,
 * 						},
 * 					},
 * 					Script: pulumi.String("myCustomActionScript"),
 * 				},
 * 			},
 * 			Description:            pulumi.String("This is the gallery application description."),
 * 			Eula:                   pulumi.String("This is the gallery application EULA."),
 * 			GalleryApplicationName: pulumi.String("myGalleryApplicationName"),
 * 			GalleryName:            pulumi.String("myGalleryName"),
 * 			Location:               pulumi.String("West US"),
 * 			PrivacyStatementUri:    pulumi.String("myPrivacyStatementUri}"),
 * 			ReleaseNoteUri:         pulumi.String("myReleaseNoteUri"),
 * 			ResourceGroupName:      pulumi.String("myResourceGroup"),
 * 			SupportedOSType:        compute.OperatingSystemTypesWindows,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryApplication;
 * import com.pulumi.azurenative.compute.GalleryApplicationArgs;
 * import com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryApplication = new GalleryApplication("galleryApplication", GalleryApplicationArgs.builder()
 *             .customActions(GalleryApplicationCustomActionArgs.builder()
 *                 .description("This is the custom action description.")
 *                 .name("myCustomAction")
 *                 .parameters(GalleryApplicationCustomActionParameterArgs.builder()
 *                     .defaultValue("default value of parameter.")
 *                     .description("This is the description of the parameter")
 *                     .name("myCustomActionParameter")
 *                     .required(false)
 *                     .type("String")
 *                     .build())
 *                 .script("myCustomActionScript")
 *                 .build())
 *             .description("This is the gallery application description.")
 *             .eula("This is the gallery application EULA.")
 *             .galleryApplicationName("myGalleryApplicationName")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .privacyStatementUri("myPrivacyStatementUri}")
 *             .releaseNoteUri("myReleaseNoteUri")
 *             .resourceGroupName("myResourceGroup")
 *             .supportedOSType("Windows")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryApplication myGalleryApplicationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}
 * ```
 * @property customActions A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
 * @property description The description of this gallery Application Definition resource. This property is updatable.
 * @property endOfLifeDate The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
 * @property eula The Eula agreement for the gallery Application Definition.
 * @property galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
 * @property galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
 * @property location Resource location
 * @property privacyStatementUri The privacy statement uri.
 * @property releaseNoteUri The release note uri.
 * @property resourceGroupName The name of the resource group.
 * @property supportedOSType This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
 * @property tags Resource tags
 */
public data class GalleryApplicationArgs(
    public val customActions: Output<List<GalleryApplicationCustomActionArgs>>? = null,
    public val description: Output<String>? = null,
    public val endOfLifeDate: Output<String>? = null,
    public val eula: Output<String>? = null,
    public val galleryApplicationName: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privacyStatementUri: Output<String>? = null,
    public val releaseNoteUri: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val supportedOSType: Output<OperatingSystemTypes>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.GalleryApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.GalleryApplicationArgs =
        com.pulumi.azurenative.compute.GalleryApplicationArgs.builder()
            .customActions(
                customActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .endOfLifeDate(endOfLifeDate?.applyValue({ args0 -> args0 }))
            .eula(eula?.applyValue({ args0 -> args0 }))
            .galleryApplicationName(galleryApplicationName?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privacyStatementUri(privacyStatementUri?.applyValue({ args0 -> args0 }))
            .releaseNoteUri(releaseNoteUri?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .supportedOSType(supportedOSType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GalleryApplicationArgs].
 */
@PulumiTagMarker
public class GalleryApplicationArgsBuilder internal constructor() {
    private var customActions: Output<List<GalleryApplicationCustomActionArgs>>? = null

    private var description: Output<String>? = null

    private var endOfLifeDate: Output<String>? = null

    private var eula: Output<String>? = null

    private var galleryApplicationName: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var location: Output<String>? = null

    private var privacyStatementUri: Output<String>? = null

    private var releaseNoteUri: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var supportedOSType: Output<OperatingSystemTypes>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("tosaeakwcillolky")
    public suspend fun customActions(`value`: Output<List<GalleryApplicationCustomActionArgs>>) {
        this.customActions = value
    }

    @JvmName("snexolnvmuglafkl")
    public suspend fun customActions(vararg values: Output<GalleryApplicationCustomActionArgs>) {
        this.customActions = Output.all(values.asList())
    }

    /**
     * @param values A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("voepjxdcyaarrnmt")
    public suspend fun customActions(values: List<Output<GalleryApplicationCustomActionArgs>>) {
        this.customActions = Output.all(values)
    }

    /**
     * @param value The description of this gallery Application Definition resource. This property is updatable.
     */
    @JvmName("vcmeyvsgdavhxoai")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("nsyqubjmpaeweuin")
    public suspend fun endOfLifeDate(`value`: Output<String>) {
        this.endOfLifeDate = value
    }

    /**
     * @param value The Eula agreement for the gallery Application Definition.
     */
    @JvmName("aycfqkcxhxsgkeyw")
    public suspend fun eula(`value`: Output<String>) {
        this.eula = value
    }

    /**
     * @param value The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("awvsvkjpxoadauqf")
    public suspend fun galleryApplicationName(`value`: Output<String>) {
        this.galleryApplicationName = value
    }

    /**
     * @param value The name of the Shared Application Gallery in which the Application Definition is to be created.
     */
    @JvmName("umqyelsidtmlcati")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("weneumjrukvsgljt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The privacy statement uri.
     */
    @JvmName("ygkdcnfcnyfvqjqt")
    public suspend fun privacyStatementUri(`value`: Output<String>) {
        this.privacyStatementUri = value
    }

    /**
     * @param value The release note uri.
     */
    @JvmName("yarpupxagrckwuae")
    public suspend fun releaseNoteUri(`value`: Output<String>) {
        this.releaseNoteUri = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mqotlhmgqvarkuph")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    @JvmName("abrtcpoxvmucgtbu")
    public suspend fun supportedOSType(`value`: Output<OperatingSystemTypes>) {
        this.supportedOSType = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("iyusxbsrcpxbvstu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("ascroxkmukyrylhc")
    public suspend fun customActions(`value`: List<GalleryApplicationCustomActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("sjfutegaclxqkgqx")
    public suspend
    fun customActions(argument: List<suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("wblhvovcbnprbiik")
    public suspend fun customActions(
        vararg
        argument: suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("coltgvxwmelvcywr")
    public suspend
    fun customActions(argument: suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GalleryApplicationCustomActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param values A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    @JvmName("dpmwcclrsgmlixfu")
    public suspend fun customActions(vararg values: GalleryApplicationCustomActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param value The description of this gallery Application Definition resource. This property is updatable.
     */
    @JvmName("nrviqrcagsvbekgy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("ufcocauqowniowit")
    public suspend fun endOfLifeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endOfLifeDate = mapped
    }

    /**
     * @param value The Eula agreement for the gallery Application Definition.
     */
    @JvmName("anlvgkjnctqpvhpe")
    public suspend fun eula(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eula = mapped
    }

    /**
     * @param value The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("whjjdxphvhgjlinn")
    public suspend fun galleryApplicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryApplicationName = mapped
    }

    /**
     * @param value The name of the Shared Application Gallery in which the Application Definition is to be created.
     */
    @JvmName("wprnkudjowptaddo")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("honcigbxskcddixo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The privacy statement uri.
     */
    @JvmName("uojxwpsyifyynted")
    public suspend fun privacyStatementUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privacyStatementUri = mapped
    }

    /**
     * @param value The release note uri.
     */
    @JvmName("lqxjvxefyvfxjkqc")
    public suspend fun releaseNoteUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseNoteUri = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cuohtsksyypfjmab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    @JvmName("ykjxdtnyahbthafs")
    public suspend fun supportedOSType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedOSType = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ilmyqmtnkfwbqtcg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("nnkqdbkqiecgsdej")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GalleryApplicationArgs = GalleryApplicationArgs(
        customActions = customActions,
        description = description,
        endOfLifeDate = endOfLifeDate,
        eula = eula,
        galleryApplicationName = galleryApplicationName,
        galleryName = galleryName,
        location = location,
        privacyStatementUri = privacyStatementUri,
        releaseNoteUri = releaseNoteUri,
        resourceGroupName = resourceGroupName,
        supportedOSType = supportedOSType,
        tags = tags,
    )
}
