@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionPublishingProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionSafetyProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionPublishingProfileResponse.Companion.toKotlin as galleryApplicationVersionPublishingProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionSafetyProfileResponse.Companion.toKotlin as galleryApplicationVersionSafetyProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse.Companion.toKotlin as replicationStatusResponseToKotlin

/**
 * Builder for [GalleryApplicationVersion].
 */
@PulumiTagMarker
public class GalleryApplicationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryApplicationVersionArgs = GalleryApplicationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryApplicationVersionArgsBuilder.() -> Unit) {
        val builder = GalleryApplicationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GalleryApplicationVersion {
        val builtJavaResource =
            com.pulumi.azurenative.compute.GalleryApplicationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GalleryApplicationVersion(builtJavaResource)
    }
}

/**
 * Specifies information about the gallery Application Version that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple gallery Application Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryApplicationVersion = new AzureNative.Compute.GalleryApplicationVersion("galleryApplicationVersion", new()
 *     {
 *         GalleryApplicationName = "myGalleryApplicationName",
 *         GalleryApplicationVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryApplicationVersionPublishingProfileArgs
 *         {
 *             CustomActions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryApplicationCustomActionArgs
 *                 {
 *                     Description = "This is the custom action description.",
 *                     Name = "myCustomAction",
 *                     Parameters = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.GalleryApplicationCustomActionParameterArgs
 *                         {
 *                             DefaultValue = "default value of parameter.",
 *                             Description = "This is the description of the parameter",
 *                             Name = "myCustomActionParameter",
 *                             Required = false,
 *                             Type = AzureNative.Compute.GalleryApplicationCustomActionParameterType.String,
 *                         },
 *                     },
 *                     Script = "myCustomActionScript",
 *                 },
 *             },
 *             EndOfLifeDate = "2019-07-01T07:00:00Z",
 *             ManageActions = new AzureNative.Compute.Inputs.UserArtifactManageArgs
 *             {
 *                 Install = "powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\"",
 *                 Remove = "del C:\\package ",
 *             },
 *             ReplicaCount = 1,
 *             Source = new AzureNative.Compute.Inputs.UserArtifactSourceArgs
 *             {
 *                 MediaLink = "https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}",
 *             },
 *             StorageAccountType = AzureNative.Compute.StorageAccountType.Standard_LRS,
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                     StorageAccountType = AzureNative.Compute.StorageAccountType.Standard_LRS,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryApplicationVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryApplicationVersion(ctx, "galleryApplicationVersion", &compute.GalleryApplicationVersionArgs{
 * 			GalleryApplicationName:        pulumi.String("myGalleryApplicationName"),
 * 			GalleryApplicationVersionName: pulumi.String("1.0.0"),
 * 			GalleryName:                   pulumi.String("myGalleryName"),
 * 			Location:                      pulumi.String("West US"),
 * 			PublishingProfile: &compute.GalleryApplicationVersionPublishingProfileArgs{
 * 				CustomActions: compute.GalleryApplicationCustomActionArray{
 * 					&compute.GalleryApplicationCustomActionArgs{
 * 						Description: pulumi.String("This is the custom action description."),
 * 						Name:        pulumi.String("myCustomAction"),
 * 						Parameters: compute.GalleryApplicationCustomActionParameterArray{
 * 							&compute.GalleryApplicationCustomActionParameterArgs{
 * 								DefaultValue: pulumi.String("default value of parameter."),
 * 								Description:  pulumi.String("This is the description of the parameter"),
 * 								Name:         pulumi.String("myCustomActionParameter"),
 * 								Required:     pulumi.Bool(false),
 * 								Type:         compute.GalleryApplicationCustomActionParameterTypeString,
 * 							},
 * 						},
 * 						Script: pulumi.String("myCustomActionScript"),
 * 					},
 * 				},
 * 				EndOfLifeDate: pulumi.String("2019-07-01T07:00:00Z"),
 * 				ManageActions: &compute.UserArtifactManageArgs{
 * 					Install: pulumi.String("powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\""),
 * 					Remove:  pulumi.String("del C:\\package "),
 * 				},
 * 				ReplicaCount: pulumi.Int(1),
 * 				Source: &compute.UserArtifactSourceArgs{
 * 					MediaLink: pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}"),
 * 				},
 * 				StorageAccountType: pulumi.String(compute.StorageAccountType_Standard_LRS),
 * 				TargetRegions: compute.TargetRegionArray{
 * 					&compute.TargetRegionArgs{
 * 						ExcludeFromLatest:    pulumi.Bool(false),
 * 						Name:                 pulumi.String("West US"),
 * 						RegionalReplicaCount: pulumi.Int(1),
 * 						StorageAccountType:   pulumi.String(compute.StorageAccountType_Standard_LRS),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SafetyProfile: &compute.GalleryApplicationVersionSafetyProfileArgs{
 * 				AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryApplicationVersion;
 * import com.pulumi.azurenative.compute.GalleryApplicationVersionArgs;
 * import com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionPublishingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UserArtifactManageArgs;
 * import com.pulumi.azurenative.compute.inputs.UserArtifactSourceArgs;
 * import com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionSafetyProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryApplicationVersion = new GalleryApplicationVersion("galleryApplicationVersion", GalleryApplicationVersionArgs.builder()
 *             .galleryApplicationName("myGalleryApplicationName")
 *             .galleryApplicationVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(GalleryApplicationVersionPublishingProfileArgs.builder()
 *                 .customActions(GalleryApplicationCustomActionArgs.builder()
 *                     .description("This is the custom action description.")
 *                     .name("myCustomAction")
 *                     .parameters(GalleryApplicationCustomActionParameterArgs.builder()
 *                         .defaultValue("default value of parameter.")
 *                         .description("This is the description of the parameter")
 *                         .name("myCustomActionParameter")
 *                         .required(false)
 *                         .type("String")
 *                         .build())
 *                     .script("myCustomActionScript")
 *                     .build())
 *                 .endOfLifeDate("2019-07-01T07:00:00Z")
 *                 .manageActions(UserArtifactManageArgs.builder()
 *                     .install("powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\"")
 *                     .remove("del C:\\package ")
 *                     .build())
 *                 .replicaCount(1)
 *                 .source(UserArtifactSourceArgs.builder()
 *                     .mediaLink("https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}")
 *                     .build())
 *                 .storageAccountType("Standard_LRS")
 *                 .targetRegions(TargetRegionArgs.builder()
 *                     .excludeFromLatest(false)
 *                     .name("West US")
 *                     .regionalReplicaCount(1)
 *                     .storageAccountType("Standard_LRS")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(GalleryApplicationVersionSafetyProfileArgs.builder()
 *                 .allowDeletionOfReplicatedLocations(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryApplicationVersion 1.0.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}
 * ```
 */
public class GalleryApplicationVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.GalleryApplicationVersion,
) : KotlinCustomResource(javaResource, GalleryApplicationVersionMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The publishing profile of a gallery image version.
     */
    public val publishingProfile: Output<GalleryApplicationVersionPublishingProfileResponse>
        get() = javaResource.publishingProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                galleryApplicationVersionPublishingProfileResponseToKotlin(args0)
            })
        })

    /**
     * This is the replication status of the gallery image version.
     */
    public val replicationStatus: Output<ReplicationStatusResponse>
        get() = javaResource.replicationStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                replicationStatusResponseToKotlin(args0)
            })
        })

    /**
     * The safety profile of the Gallery Application Version.
     */
    public val safetyProfile: Output<GalleryApplicationVersionSafetyProfileResponse>?
        get() = javaResource.safetyProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryApplicationVersionSafetyProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryApplicationVersionMapper : ResourceMapper<GalleryApplicationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.GalleryApplicationVersion::class == javaResource::class

    override fun map(javaResource: Resource): GalleryApplicationVersion =
        GalleryApplicationVersion(
            javaResource as
                com.pulumi.azurenative.compute.GalleryApplicationVersion,
        )
}

/**
 * @see [GalleryApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GalleryApplicationVersion].
 */
public suspend fun galleryApplicationVersion(
    name: String,
    block: suspend GalleryApplicationVersionResourceBuilder.() -> Unit,
): GalleryApplicationVersion {
    val builder = GalleryApplicationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GalleryApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun galleryApplicationVersion(name: String): GalleryApplicationVersion {
    val builder = GalleryApplicationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
