@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.GalleryImageArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.Architecture
import com.pulumi.azurenative.compute.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemStateTypes
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.compute.kotlin.inputs.DisallowedArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DisallowedArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageFeatureArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageFeatureArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageIdentifierArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageIdentifierArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ImagePurchasePlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ImagePurchasePlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.RecommendedMachineConfigurationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RecommendedMachineConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the gallery image definition that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple gallery image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImage = new AzureNative.Compute.GalleryImage("galleryImage", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryName = "myGalleryName",
 *         HyperVGeneration = AzureNative.Compute.HyperVGeneration.V1,
 *         Identifier = new AzureNative.Compute.Inputs.GalleryImageIdentifierArgs
 *         {
 *             Offer = "myOfferName",
 *             Publisher = "myPublisherName",
 *             Sku = "mySkuName",
 *         },
 *         Location = "West US",
 *         OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryImage(ctx, "galleryImage", &compute.GalleryImageArgs{
 * 			GalleryImageName: pulumi.String("myGalleryImageName"),
 * 			GalleryName:      pulumi.String("myGalleryName"),
 * 			HyperVGeneration: pulumi.String(compute.HyperVGenerationV1),
 * 			Identifier: &compute.GalleryImageIdentifierArgs{
 * 				Offer:     pulumi.String("myOfferName"),
 * 				Publisher: pulumi.String("myPublisherName"),
 * 				Sku:       pulumi.String("mySkuName"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			OsState:           compute.OperatingSystemStateTypesGeneralized,
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImage;
 * import com.pulumi.azurenative.compute.GalleryImageArgs;
 * import com.pulumi.azurenative.compute.inputs.GalleryImageIdentifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImage = new GalleryImage("galleryImage", GalleryImageArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryName("myGalleryName")
 *             .hyperVGeneration("V1")
 *             .identifier(GalleryImageIdentifierArgs.builder()
 *                 .offer("myOfferName")
 *                 .publisher("myPublisherName")
 *                 .sku("mySkuName")
 *                 .build())
 *             .location("West US")
 *             .osState("Generalized")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryImage myGalleryImageName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}
 * ```
 * @property architecture The architecture of the image. Applicable to OS disks only.
 * @property description The description of this gallery image definition resource. This property is updatable.
 * @property disallowed Describes the disallowed disk types.
 * @property endOfLifeDate The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
 * @property eula The Eula agreement for the gallery image definition.
 * @property features A list of gallery image features.
 * @property galleryImageName The name of the gallery image definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
 * @property galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property identifier This is the gallery image definition identifier.
 * @property location Resource location
 * @property osState This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'.
 * @property osType This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
 * @property privacyStatementUri The privacy statement uri.
 * @property purchasePlan Describes the gallery image definition purchase plan. This is used by marketplace images.
 * @property recommended The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
 * @property releaseNoteUri The release note uri.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 */
public data class GalleryImageArgs(
    public val architecture: Output<Either<String, Architecture>>? = null,
    public val description: Output<String>? = null,
    public val disallowed: Output<DisallowedArgs>? = null,
    public val endOfLifeDate: Output<String>? = null,
    public val eula: Output<String>? = null,
    public val features: Output<List<GalleryImageFeatureArgs>>? = null,
    public val galleryImageName: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val identifier: Output<GalleryImageIdentifierArgs>? = null,
    public val location: Output<String>? = null,
    public val osState: Output<OperatingSystemStateTypes>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val privacyStatementUri: Output<String>? = null,
    public val purchasePlan: Output<ImagePurchasePlanArgs>? = null,
    public val recommended: Output<RecommendedMachineConfigurationArgs>? = null,
    public val releaseNoteUri: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.GalleryImageArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.GalleryImageArgs =
        com.pulumi.azurenative.compute.GalleryImageArgs.builder()
            .architecture(
                architecture?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .disallowed(disallowed?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endOfLifeDate(endOfLifeDate?.applyValue({ args0 -> args0 }))
            .eula(eula?.applyValue({ args0 -> args0 }))
            .features(
                features?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .galleryImageName(galleryImageName?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .identifier(identifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osState(osState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privacyStatementUri(privacyStatementUri?.applyValue({ args0 -> args0 }))
            .purchasePlan(purchasePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recommended(recommended?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .releaseNoteUri(releaseNoteUri?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GalleryImageArgs].
 */
@PulumiTagMarker
public class GalleryImageArgsBuilder internal constructor() {
    private var architecture: Output<Either<String, Architecture>>? = null

    private var description: Output<String>? = null

    private var disallowed: Output<DisallowedArgs>? = null

    private var endOfLifeDate: Output<String>? = null

    private var eula: Output<String>? = null

    private var features: Output<List<GalleryImageFeatureArgs>>? = null

    private var galleryImageName: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var identifier: Output<GalleryImageIdentifierArgs>? = null

    private var location: Output<String>? = null

    private var osState: Output<OperatingSystemStateTypes>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var privacyStatementUri: Output<String>? = null

    private var purchasePlan: Output<ImagePurchasePlanArgs>? = null

    private var recommended: Output<RecommendedMachineConfigurationArgs>? = null

    private var releaseNoteUri: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The architecture of the image. Applicable to OS disks only.
     */
    @JvmName("yohtpcgjxdhtddht")
    public suspend fun architecture(`value`: Output<Either<String, Architecture>>) {
        this.architecture = value
    }

    /**
     * @param value The description of this gallery image definition resource. This property is updatable.
     */
    @JvmName("mucvlqrhmyfaxhut")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Describes the disallowed disk types.
     */
    @JvmName("lvuivkbicpudawoi")
    public suspend fun disallowed(`value`: Output<DisallowedArgs>) {
        this.disallowed = value
    }

    /**
     * @param value The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("vraqufnxbphdeplc")
    public suspend fun endOfLifeDate(`value`: Output<String>) {
        this.endOfLifeDate = value
    }

    /**
     * @param value The Eula agreement for the gallery image definition.
     */
    @JvmName("yfsfmnidrkfiiyhx")
    public suspend fun eula(`value`: Output<String>) {
        this.eula = value
    }

    /**
     * @param value A list of gallery image features.
     */
    @JvmName("xebukpgakjeedjym")
    public suspend fun features(`value`: Output<List<GalleryImageFeatureArgs>>) {
        this.features = value
    }

    @JvmName("fvssreauypsvynrg")
    public suspend fun features(vararg values: Output<GalleryImageFeatureArgs>) {
        this.features = Output.all(values.asList())
    }

    /**
     * @param values A list of gallery image features.
     */
    @JvmName("kxluwtqvpgqtdcfh")
    public suspend fun features(values: List<Output<GalleryImageFeatureArgs>>) {
        this.features = Output.all(values)
    }

    /**
     * @param value The name of the gallery image definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("btekcemjdblerjvn")
    public suspend fun galleryImageName(`value`: Output<String>) {
        this.galleryImageName = value
    }

    /**
     * @param value The name of the Shared Image Gallery in which the Image Definition is to be created.
     */
    @JvmName("bibogigoakaqrseu")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("fphggvnpyvtnwkph")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("bdysrorvoqajlwyk")
    public suspend fun identifier(`value`: Output<GalleryImageIdentifierArgs>) {
        this.identifier = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ohfwftihlugegmgq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'.
     */
    @JvmName("ubpklakdcgxavcqt")
    public suspend fun osState(`value`: Output<OperatingSystemStateTypes>) {
        this.osState = value
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    @JvmName("jsxtgppxcrbaysoo")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value The privacy statement uri.
     */
    @JvmName("ircaudwduntppthh")
    public suspend fun privacyStatementUri(`value`: Output<String>) {
        this.privacyStatementUri = value
    }

    /**
     * @param value Describes the gallery image definition purchase plan. This is used by marketplace images.
     */
    @JvmName("eidfmwbmbolpnsss")
    public suspend fun purchasePlan(`value`: Output<ImagePurchasePlanArgs>) {
        this.purchasePlan = value
    }

    /**
     * @param value The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
     */
    @JvmName("uwgwalldxvmgemwy")
    public suspend fun recommended(`value`: Output<RecommendedMachineConfigurationArgs>) {
        this.recommended = value
    }

    /**
     * @param value The release note uri.
     */
    @JvmName("smcxfnajbrxagyab")
    public suspend fun releaseNoteUri(`value`: Output<String>) {
        this.releaseNoteUri = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wdliwmytrcvhhopn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ahrutoktjsjvlyfg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The architecture of the image. Applicable to OS disks only.
     */
    @JvmName("pgdoytybbbiguvgr")
    public suspend fun architecture(`value`: Either<String, Architecture>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The architecture of the image. Applicable to OS disks only.
     */
    @JvmName("aferclhqefbrhkag")
    public fun architecture(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The architecture of the image. Applicable to OS disks only.
     */
    @JvmName("psunqetmrpmhicvd")
    public fun architecture(`value`: Architecture) {
        val toBeMapped = Either.ofRight<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The description of this gallery image definition resource. This property is updatable.
     */
    @JvmName("rccoxrqvrvewxegs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Describes the disallowed disk types.
     */
    @JvmName("gktjlcxvggjccrfx")
    public suspend fun disallowed(`value`: DisallowedArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowed = mapped
    }

    /**
     * @param argument Describes the disallowed disk types.
     */
    @JvmName("bbcqqakhmwamyyxm")
    public suspend fun disallowed(argument: suspend DisallowedArgsBuilder.() -> Unit) {
        val toBeMapped = DisallowedArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.disallowed = mapped
    }

    /**
     * @param value The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("wausrjiiaweelpmq")
    public suspend fun endOfLifeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endOfLifeDate = mapped
    }

    /**
     * @param value The Eula agreement for the gallery image definition.
     */
    @JvmName("hyvrjsovselatdsf")
    public suspend fun eula(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eula = mapped
    }

    /**
     * @param value A list of gallery image features.
     */
    @JvmName("obewwbcyqtiwslod")
    public suspend fun features(`value`: List<GalleryImageFeatureArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument A list of gallery image features.
     */
    @JvmName("ehlqmvdmpiqwhblj")
    public suspend fun features(argument: List<suspend GalleryImageFeatureArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryImageFeatureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param argument A list of gallery image features.
     */
    @JvmName("acdbvsbtujbbkqoy")
    public suspend fun features(vararg argument: suspend GalleryImageFeatureArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GalleryImageFeatureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param argument A list of gallery image features.
     */
    @JvmName("sxdtfulvxusfdsmf")
    public suspend fun features(argument: suspend GalleryImageFeatureArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GalleryImageFeatureArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param values A list of gallery image features.
     */
    @JvmName("vxhklbdjhtfabnnt")
    public suspend fun features(vararg values: GalleryImageFeatureArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value The name of the gallery image definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("ebiufpvasivgheou")
    public suspend fun galleryImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery in which the Image Definition is to be created.
     */
    @JvmName("tlptcwomakrchvjm")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("essmhiflavylyqme")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("maslwraovomwyodb")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("vsyjnworegfbsoxq")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("keqncifenpptotgl")
    public suspend fun identifier(`value`: GalleryImageIdentifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param argument This is the gallery image definition identifier.
     */
    @JvmName("ytdidbsvsrrleqob")
    public suspend fun identifier(argument: suspend GalleryImageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageIdentifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identifier = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("jffwnikoujmvdxqf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'.
     */
    @JvmName("ahmdkkxftjmjwqma")
    public suspend fun osState(`value`: OperatingSystemStateTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osState = mapped
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    @JvmName("pjyieqllcgrksvex")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The privacy statement uri.
     */
    @JvmName("phaxeinpbvofbjis")
    public suspend fun privacyStatementUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privacyStatementUri = mapped
    }

    /**
     * @param value Describes the gallery image definition purchase plan. This is used by marketplace images.
     */
    @JvmName("liecptyvwraegori")
    public suspend fun purchasePlan(`value`: ImagePurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purchasePlan = mapped
    }

    /**
     * @param argument Describes the gallery image definition purchase plan. This is used by marketplace images.
     */
    @JvmName("sfbyffvvrxqhmymf")
    public suspend fun purchasePlan(argument: suspend ImagePurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purchasePlan = mapped
    }

    /**
     * @param value The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
     */
    @JvmName("hokydfqldxghrewd")
    public suspend fun recommended(`value`: RecommendedMachineConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommended = mapped
    }

    /**
     * @param argument The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
     */
    @JvmName("rfgdoblpcsbwkhrp")
    public suspend
    fun recommended(argument: suspend RecommendedMachineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RecommendedMachineConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recommended = mapped
    }

    /**
     * @param value The release note uri.
     */
    @JvmName("ntjqfiotpklnmohb")
    public suspend fun releaseNoteUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseNoteUri = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nmsbhxgsjudupbax")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mattdpmwmcikenmy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("hxiebradwnuypwsh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GalleryImageArgs = GalleryImageArgs(
        architecture = architecture,
        description = description,
        disallowed = disallowed,
        endOfLifeDate = endOfLifeDate,
        eula = eula,
        features = features,
        galleryImageName = galleryImageName,
        galleryName = galleryName,
        hyperVGeneration = hyperVGeneration,
        identifier = identifier,
        location = location,
        osState = osState,
        osType = osType,
        privacyStatementUri = privacyStatementUri,
        purchasePlan = purchasePlan,
        recommended = recommended,
        releaseNoteUri = releaseNoteUri,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
