@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.ProximityPlacementGroupArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ProximityPlacementGroupType
import com.pulumi.azurenative.compute.kotlin.inputs.InstanceViewStatusArgs
import com.pulumi.azurenative.compute.kotlin.inputs.InstanceViewStatusArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ProximityPlacementGroupPropertiesIntentArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ProximityPlacementGroupPropertiesIntentArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the proximity placement group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-03-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or Update a proximity placement group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var proximityPlacementGroup = new AzureNative.Compute.ProximityPlacementGroup("proximityPlacementGroup", new()
 *     {
 *         Intent = new AzureNative.Compute.Inputs.ProximityPlacementGroupPropertiesIntentArgs
 *         {
 *             VmSizes = new[]
 *             {
 *                 "Basic_A0",
 *                 "Basic_A2",
 *             },
 *         },
 *         Location = "westus",
 *         ProximityPlacementGroupName = "myProximityPlacementGroup",
 *         ProximityPlacementGroupType = AzureNative.Compute.ProximityPlacementGroupType.Standard,
 *         ResourceGroupName = "myResourceGroup",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewProximityPlacementGroup(ctx, "proximityPlacementGroup", &compute.ProximityPlacementGroupArgs{
 * 			Intent: &compute.ProximityPlacementGroupPropertiesIntentArgs{
 * 				VmSizes: pulumi.StringArray{
 * 					pulumi.String("Basic_A0"),
 * 					pulumi.String("Basic_A2"),
 * 				},
 * 			},
 * 			Location:                    pulumi.String("westus"),
 * 			ProximityPlacementGroupName: pulumi.String("myProximityPlacementGroup"),
 * 			ProximityPlacementGroupType: pulumi.String(compute.ProximityPlacementGroupTypeStandard),
 * 			ResourceGroupName:           pulumi.String("myResourceGroup"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.ProximityPlacementGroup;
 * import com.pulumi.azurenative.compute.ProximityPlacementGroupArgs;
 * import com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var proximityPlacementGroup = new ProximityPlacementGroup("proximityPlacementGroup", ProximityPlacementGroupArgs.builder()
 *             .intent(ProximityPlacementGroupPropertiesIntentArgs.builder()
 *                 .vmSizes(
 *                     "Basic_A0",
 *                     "Basic_A2")
 *                 .build())
 *             .location("westus")
 *             .proximityPlacementGroupName("myProximityPlacementGroup")
 *             .proximityPlacementGroupType("Standard")
 *             .resourceGroupName("myResourceGroup")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:ProximityPlacementGroup myProximityPlacementGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}
 * ```
 * @property colocationStatus Describes colocation status of the Proximity Placement Group.
 * @property intent Specifies the user intent of the proximity placement group.
 * @property location Resource location
 * @property proximityPlacementGroupName The name of the proximity placement group.
 * @property proximityPlacementGroupType Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 * @property zones Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
 */
public data class ProximityPlacementGroupArgs(
    public val colocationStatus: Output<InstanceViewStatusArgs>? = null,
    public val intent: Output<ProximityPlacementGroupPropertiesIntentArgs>? = null,
    public val location: Output<String>? = null,
    public val proximityPlacementGroupName: Output<String>? = null,
    public val proximityPlacementGroupType: Output<Either<String, ProximityPlacementGroupType>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.ProximityPlacementGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.ProximityPlacementGroupArgs =
        com.pulumi.azurenative.compute.ProximityPlacementGroupArgs.builder()
            .colocationStatus(colocationStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intent(intent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .proximityPlacementGroupName(proximityPlacementGroupName?.applyValue({ args0 -> args0 }))
            .proximityPlacementGroupType(
                proximityPlacementGroupType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProximityPlacementGroupArgs].
 */
@PulumiTagMarker
public class ProximityPlacementGroupArgsBuilder internal constructor() {
    private var colocationStatus: Output<InstanceViewStatusArgs>? = null

    private var intent: Output<ProximityPlacementGroupPropertiesIntentArgs>? = null

    private var location: Output<String>? = null

    private var proximityPlacementGroupName: Output<String>? = null

    private var proximityPlacementGroupType: Output<Either<String, ProximityPlacementGroupType>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Describes colocation status of the Proximity Placement Group.
     */
    @JvmName("uubscfqfjylelwbf")
    public suspend fun colocationStatus(`value`: Output<InstanceViewStatusArgs>) {
        this.colocationStatus = value
    }

    /**
     * @param value Specifies the user intent of the proximity placement group.
     */
    @JvmName("eivdkvpabvyskbqo")
    public suspend fun intent(`value`: Output<ProximityPlacementGroupPropertiesIntentArgs>) {
        this.intent = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ooempjcanfhkwmeq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the proximity placement group.
     */
    @JvmName("cradmliuvnuvraiu")
    public suspend fun proximityPlacementGroupName(`value`: Output<String>) {
        this.proximityPlacementGroupName = value
    }

    /**
     * @param value Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    @JvmName("ffnjagvvkunaummw")
    public suspend
    fun proximityPlacementGroupType(`value`: Output<Either<String, ProximityPlacementGroupType>>) {
        this.proximityPlacementGroupType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qprdvvajtyxcpmrc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("tteoayqpqnrkyadg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
     */
    @JvmName("jbuotbxnfgnwyhyi")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("rgwrvceklqlhjacu")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
     */
    @JvmName("ldeitgunwihqvwdi")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Describes colocation status of the Proximity Placement Group.
     */
    @JvmName("asjasjohcgkdidnw")
    public suspend fun colocationStatus(`value`: InstanceViewStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colocationStatus = mapped
    }

    /**
     * @param argument Describes colocation status of the Proximity Placement Group.
     */
    @JvmName("pgnjopcwcatgnggj")
    public suspend fun colocationStatus(argument: suspend InstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceViewStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.colocationStatus = mapped
    }

    /**
     * @param value Specifies the user intent of the proximity placement group.
     */
    @JvmName("gairvhqwxtoqmorb")
    public suspend fun intent(`value`: ProximityPlacementGroupPropertiesIntentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intent = mapped
    }

    /**
     * @param argument Specifies the user intent of the proximity placement group.
     */
    @JvmName("ohmjvvawluochhru")
    public suspend
    fun intent(argument: suspend ProximityPlacementGroupPropertiesIntentArgsBuilder.() -> Unit) {
        val toBeMapped = ProximityPlacementGroupPropertiesIntentArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.intent = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("tuaogrfgenaailqm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the proximity placement group.
     */
    @JvmName("maacexqjkocnmkis")
    public suspend fun proximityPlacementGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroupName = mapped
    }

    /**
     * @param value Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    @JvmName("ylmmdneylamumxnm")
    public suspend
    fun proximityPlacementGroupType(`value`: Either<String, ProximityPlacementGroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroupType = mapped
    }

    /**
     * @param value Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    @JvmName("pdajuklgkbwpfjli")
    public fun proximityPlacementGroupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProximityPlacementGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proximityPlacementGroupType = mapped
    }

    /**
     * @param value Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    @JvmName("dvxlmoxilmwsqbqg")
    public fun proximityPlacementGroupType(`value`: ProximityPlacementGroupType) {
        val toBeMapped = Either.ofRight<String, ProximityPlacementGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proximityPlacementGroupType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hvsfqktmxpdtrqwl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qgiebmnvxuulnybp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("wjosjncxdugblaui")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
     */
    @JvmName("nqlujtyawwfcbbaw")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
     */
    @JvmName("lxbyolkieqbkatlx")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): ProximityPlacementGroupArgs = ProximityPlacementGroupArgs(
        colocationStatus = colocationStatus,
        intent = intent,
        location = location,
        proximityPlacementGroupName = proximityPlacementGroupName,
        proximityPlacementGroupType = proximityPlacementGroupType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        zones = zones,
    )
}
