@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceMetadataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin as apiEntityReferenceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointInstanceViewResponse.Companion.toKotlin as restorePointInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceMetadataResponse.Companion.toKotlin as restorePointSourceMetadataResponseToKotlin

/**
 * Builder for [RestorePoint].
 */
@PulumiTagMarker
public class RestorePointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RestorePointArgs = RestorePointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RestorePointArgsBuilder.() -> Unit) {
        val builder = RestorePointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RestorePoint {
        val builtJavaResource = com.pulumi.azurenative.compute.RestorePoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RestorePoint(builtJavaResource)
    }
}

/**
 * Restore Point details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2022-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Copy a restore point to a different region
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePoint = new AzureNative.Compute.RestorePoint("restorePoint", new()
 *     {
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "rpcName",
 *         RestorePointName = "rpName",
 *         SourceRestorePoint = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePoint(ctx, "restorePoint", &compute.RestorePointArgs{
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("rpcName"),
 * 			RestorePointName:           pulumi.String("rpName"),
 * 			SourceRestorePoint: &compute.ApiEntityReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePoint;
 * import com.pulumi.azurenative.compute.RestorePointArgs;
 * import com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePoint = new RestorePoint("restorePoint", RestorePointArgs.builder()
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("rpcName")
 *             .restorePointName("rpName")
 *             .sourceRestorePoint(ApiEntityReferenceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a restore point
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePoint = new AzureNative.Compute.RestorePoint("restorePoint", new()
 *     {
 *         ExcludeDisks = new[]
 *         {
 *             new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "rpcName",
 *         RestorePointName = "rpName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePoint(ctx, "restorePoint", &compute.RestorePointArgs{
 * 			ExcludeDisks: compute.ApiEntityReferenceArray{
 * 				&compute.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123"),
 * 				},
 * 			},
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("rpcName"),
 * 			RestorePointName:           pulumi.String("rpName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePoint;
 * import com.pulumi.azurenative.compute.RestorePointArgs;
 * import com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePoint = new RestorePoint("restorePoint", RestorePointArgs.builder()
 *             .excludeDisks(ApiEntityReferenceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("rpcName")
 *             .restorePointName("rpName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:RestorePoint rpName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}
 * ```
 */
public class RestorePoint internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.RestorePoint,
) : KotlinCustomResource(javaResource, RestorePointMapper) {
    /**
     * ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    public val consistencyMode: Output<String>?
        get() = javaResource.consistencyMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    public val excludeDisks: Output<List<ApiEntityReferenceResponse>>?
        get() = javaResource.excludeDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> apiEntityReferenceResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The restore point instance view.
     */
    public val instanceView: Output<RestorePointInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                restorePointInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the restore point.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the details of the VM captured at the time of the restore point creation.
     */
    public val sourceMetadata: Output<RestorePointSourceMetadataResponse>?
        get() = javaResource.sourceMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> restorePointSourceMetadataResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource Id of the source restore point from which a copy needs to be created.
     */
    public val sourceRestorePoint: Output<ApiEntityReferenceResponse>?
        get() = javaResource.sourceRestorePoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiEntityReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the creation time of the restore point.
     */
    public val timeCreated: Output<String>?
        get() = javaResource.timeCreated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RestorePointMapper : ResourceMapper<RestorePoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.RestorePoint::class == javaResource::class

    override fun map(javaResource: Resource): RestorePoint = RestorePoint(
        javaResource as
            com.pulumi.azurenative.compute.RestorePoint,
    )
}

/**
 * @see [RestorePoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RestorePoint].
 */
public suspend fun restorePoint(
    name: String,
    block: suspend RestorePointResourceBuilder.() -> Unit,
): RestorePoint {
    val builder = RestorePointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RestorePoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun restorePoint(name: String): RestorePoint {
    val builder = RestorePointResourceBuilder()
    builder.name(name)
    return builder.build()
}
