@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.RestorePointArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ConsistencyModeTypes
import com.pulumi.azurenative.compute.kotlin.inputs.ApiEntityReferenceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ApiEntityReferenceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.RestorePointSourceMetadataArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RestorePointSourceMetadataArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Restore Point details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2022-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Copy a restore point to a different region
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePoint = new AzureNative.Compute.RestorePoint("restorePoint", new()
 *     {
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "rpcName",
 *         RestorePointName = "rpName",
 *         SourceRestorePoint = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePoint(ctx, "restorePoint", &compute.RestorePointArgs{
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("rpcName"),
 * 			RestorePointName:           pulumi.String("rpName"),
 * 			SourceRestorePoint: &compute.ApiEntityReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePoint;
 * import com.pulumi.azurenative.compute.RestorePointArgs;
 * import com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePoint = new RestorePoint("restorePoint", RestorePointArgs.builder()
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("rpcName")
 *             .restorePointName("rpName")
 *             .sourceRestorePoint(ApiEntityReferenceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName/restorePoints/sourceRpName")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a restore point
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePoint = new AzureNative.Compute.RestorePoint("restorePoint", new()
 *     {
 *         ExcludeDisks = new[]
 *         {
 *             new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "rpcName",
 *         RestorePointName = "rpName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePoint(ctx, "restorePoint", &compute.RestorePointArgs{
 * 			ExcludeDisks: compute.ApiEntityReferenceArray{
 * 				&compute.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123"),
 * 				},
 * 			},
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("rpcName"),
 * 			RestorePointName:           pulumi.String("rpName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePoint;
 * import com.pulumi.azurenative.compute.RestorePointArgs;
 * import com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePoint = new RestorePoint("restorePoint", RestorePointArgs.builder()
 *             .excludeDisks(ApiEntityReferenceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("rpcName")
 *             .restorePointName("rpName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:RestorePoint rpName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}
 * ```
 * @property consistencyMode ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
 * @property excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
 * @property resourceGroupName The name of the resource group.
 * @property restorePointCollectionName The name of the restore point collection.
 * @property restorePointName The name of the restore point.
 * @property sourceMetadata Gets the details of the VM captured at the time of the restore point creation.
 * @property sourceRestorePoint Resource Id of the source restore point from which a copy needs to be created.
 * @property timeCreated Gets the creation time of the restore point.
 */
public data class RestorePointArgs(
    public val consistencyMode: Output<Either<String, ConsistencyModeTypes>>? = null,
    public val excludeDisks: Output<List<ApiEntityReferenceArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePointCollectionName: Output<String>? = null,
    public val restorePointName: Output<String>? = null,
    public val sourceMetadata: Output<RestorePointSourceMetadataArgs>? = null,
    public val sourceRestorePoint: Output<ApiEntityReferenceArgs>? = null,
    public val timeCreated: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.RestorePointArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.RestorePointArgs =
        com.pulumi.azurenative.compute.RestorePointArgs.builder()
            .consistencyMode(
                consistencyMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .excludeDisks(
                excludeDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePointCollectionName(restorePointCollectionName?.applyValue({ args0 -> args0 }))
            .restorePointName(restorePointName?.applyValue({ args0 -> args0 }))
            .sourceMetadata(sourceMetadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceRestorePoint(
                sourceRestorePoint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeCreated(timeCreated?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestorePointArgs].
 */
@PulumiTagMarker
public class RestorePointArgsBuilder internal constructor() {
    private var consistencyMode: Output<Either<String, ConsistencyModeTypes>>? = null

    private var excludeDisks: Output<List<ApiEntityReferenceArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorePointCollectionName: Output<String>? = null

    private var restorePointName: Output<String>? = null

    private var sourceMetadata: Output<RestorePointSourceMetadataArgs>? = null

    private var sourceRestorePoint: Output<ApiEntityReferenceArgs>? = null

    private var timeCreated: Output<String>? = null

    /**
     * @param value ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    @JvmName("ayycxmuhhitllgiv")
    public suspend fun consistencyMode(`value`: Output<Either<String, ConsistencyModeTypes>>) {
        this.consistencyMode = value
    }

    /**
     * @param value List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("bglnrbiqedkmcrax")
    public suspend fun excludeDisks(`value`: Output<List<ApiEntityReferenceArgs>>) {
        this.excludeDisks = value
    }

    @JvmName("hongsdaaolgejjoh")
    public suspend fun excludeDisks(vararg values: Output<ApiEntityReferenceArgs>) {
        this.excludeDisks = Output.all(values.asList())
    }

    /**
     * @param values List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("yuwacrhjxqmwvtrc")
    public suspend fun excludeDisks(values: List<Output<ApiEntityReferenceArgs>>) {
        this.excludeDisks = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("djpalsnsbregyqiu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("xbtixhidujhcvbdy")
    public suspend fun restorePointCollectionName(`value`: Output<String>) {
        this.restorePointCollectionName = value
    }

    /**
     * @param value The name of the restore point.
     */
    @JvmName("velsgjnuqlhjyqxk")
    public suspend fun restorePointName(`value`: Output<String>) {
        this.restorePointName = value
    }

    /**
     * @param value Gets the details of the VM captured at the time of the restore point creation.
     */
    @JvmName("rhhaqvbpcogtqelp")
    public suspend fun sourceMetadata(`value`: Output<RestorePointSourceMetadataArgs>) {
        this.sourceMetadata = value
    }

    /**
     * @param value Resource Id of the source restore point from which a copy needs to be created.
     */
    @JvmName("kgggksndvaeywgkb")
    public suspend fun sourceRestorePoint(`value`: Output<ApiEntityReferenceArgs>) {
        this.sourceRestorePoint = value
    }

    /**
     * @param value Gets the creation time of the restore point.
     */
    @JvmName("ymppvhudjlxpcbwu")
    public suspend fun timeCreated(`value`: Output<String>) {
        this.timeCreated = value
    }

    /**
     * @param value ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    @JvmName("iripulsmbavoqlmo")
    public suspend fun consistencyMode(`value`: Either<String, ConsistencyModeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consistencyMode = mapped
    }

    /**
     * @param value ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    @JvmName("hclybgqdnkwjfxec")
    public fun consistencyMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConsistencyModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consistencyMode = mapped
    }

    /**
     * @param value ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    @JvmName("otaddmhdhubgubhl")
    public fun consistencyMode(`value`: ConsistencyModeTypes) {
        val toBeMapped = Either.ofRight<String, ConsistencyModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consistencyMode = mapped
    }

    /**
     * @param value List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("osdeemxglodpepbq")
    public suspend fun excludeDisks(`value`: List<ApiEntityReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeDisks = mapped
    }

    /**
     * @param argument List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("jfkfqwgyovanqhoq")
    public suspend
    fun excludeDisks(argument: List<suspend ApiEntityReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApiEntityReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeDisks = mapped
    }

    /**
     * @param argument List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("rdhyxjmfljridmkd")
    public suspend fun excludeDisks(
        vararg
        argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApiEntityReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeDisks = mapped
    }

    /**
     * @param argument List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("mthbqjwrjihnvepl")
    public suspend fun excludeDisks(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.excludeDisks = mapped
    }

    /**
     * @param values List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.
     */
    @JvmName("idibhccqqismifig")
    public suspend fun excludeDisks(vararg values: ApiEntityReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeDisks = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fwmrdxljskpvibmd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("xcqvtvspotgfpdrt")
    public suspend fun restorePointCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointCollectionName = mapped
    }

    /**
     * @param value The name of the restore point.
     */
    @JvmName("nrtucahnxlhgimth")
    public suspend fun restorePointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointName = mapped
    }

    /**
     * @param value Gets the details of the VM captured at the time of the restore point creation.
     */
    @JvmName("colcmnlmxyxhxutr")
    public suspend fun sourceMetadata(`value`: RestorePointSourceMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceMetadata = mapped
    }

    /**
     * @param argument Gets the details of the VM captured at the time of the restore point creation.
     */
    @JvmName("dfgetsulyrwbibkn")
    public suspend
    fun sourceMetadata(argument: suspend RestorePointSourceMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePointSourceMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceMetadata = mapped
    }

    /**
     * @param value Resource Id of the source restore point from which a copy needs to be created.
     */
    @JvmName("gejcreyqjychpmvl")
    public suspend fun sourceRestorePoint(`value`: ApiEntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRestorePoint = mapped
    }

    /**
     * @param argument Resource Id of the source restore point from which a copy needs to be created.
     */
    @JvmName("dufcbmvatmbieljl")
    public suspend
    fun sourceRestorePoint(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceRestorePoint = mapped
    }

    /**
     * @param value Gets the creation time of the restore point.
     */
    @JvmName("xpdunawqcbsgkhxa")
    public suspend fun timeCreated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeCreated = mapped
    }

    internal fun build(): RestorePointArgs = RestorePointArgs(
        consistencyMode = consistencyMode,
        excludeDisks = excludeDisks,
        resourceGroupName = resourceGroupName,
        restorePointCollectionName = restorePointCollectionName,
        restorePointName = restorePointName,
        sourceMetadata = sourceMetadata,
        sourceRestorePoint = sourceRestorePoint,
        timeCreated = timeCreated,
    )
}
