@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.RunCommandInputParameterResponse
import com.pulumi.azurenative.compute.kotlin.outputs.RunCommandManagedIdentityResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineRunCommandInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineRunCommandScriptSourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.RunCommandInputParameterResponse.Companion.toKotlin as runCommandInputParameterResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.RunCommandManagedIdentityResponse.Companion.toKotlin as runCommandManagedIdentityResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineRunCommandInstanceViewResponse.Companion.toKotlin as virtualMachineRunCommandInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineRunCommandScriptSourceResponse.Companion.toKotlin as virtualMachineRunCommandScriptSourceResponseToKotlin

/**
 * Builder for [VirtualMachineRunCommandByVirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineRunCommandByVirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineRunCommandByVirtualMachineArgs =
        VirtualMachineRunCommandByVirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend VirtualMachineRunCommandByVirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineRunCommandByVirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineRunCommandByVirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineRunCommandByVirtualMachine(builtJavaResource)
    }
}

/**
 * Describes a Virtual Machine run command.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a run command.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineRunCommandByVirtualMachine = new AzureNative.Compute.VirtualMachineRunCommandByVirtualMachine("virtualMachineRunCommandByVirtualMachine", new()
 *     {
 *         AsyncExecution = false,
 *         ErrorBlobUri = "https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D",
 *         Location = "West US",
 *         OutputBlobManagedIdentity = new AzureNative.Compute.Inputs.RunCommandManagedIdentityArgs
 *         {
 *             ClientId = "22d35efb-0c99-4041-8c5b-6d24db33a69a",
 *         },
 *         OutputBlobUri = "https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt",
 *         Parameters = new[]
 *         {
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param1",
 *                 Value = "value1",
 *             },
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param2",
 *                 Value = "value2",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RunAsPassword = "<runAsPassword>",
 *         RunAsUser = "user1",
 *         RunCommandName = "myRunCommand",
 *         Source = new AzureNative.Compute.Inputs.VirtualMachineRunCommandScriptSourceArgs
 *         {
 *             ScriptUri = "https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D",
 *         },
 *         TimeoutInSeconds = 3600,
 *         TreatFailureAsDeploymentFailure = false,
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineRunCommandByVirtualMachine(ctx, "virtualMachineRunCommandByVirtualMachine", &compute.VirtualMachineRunCommandByVirtualMachineArgs{
 * 			AsyncExecution: pulumi.Bool(false),
 * 			ErrorBlobUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D"),
 * 			Location:       pulumi.String("West US"),
 * 			OutputBlobManagedIdentity: &compute.RunCommandManagedIdentityArgs{
 * 				ClientId: pulumi.String("22d35efb-0c99-4041-8c5b-6d24db33a69a"),
 * 			},
 * 			OutputBlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt"),
 * 			Parameters: compute.RunCommandInputParameterArray{
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param1"),
 * 					Value: pulumi.String("value1"),
 * 				},
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param2"),
 * 					Value: pulumi.String("value2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunAsPassword:     pulumi.String("<runAsPassword>"),
 * 			RunAsUser:         pulumi.String("user1"),
 * 			RunCommandName:    pulumi.String("myRunCommand"),
 * 			Source: &compute.VirtualMachineRunCommandScriptSourceArgs{
 * 				ScriptUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D"),
 * 			},
 * 			TimeoutInSeconds:                pulumi.Int(3600),
 * 			TreatFailureAsDeploymentFailure: pulumi.Bool(false),
 * 			VmName:                          pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineRunCommandScriptSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineRunCommandByVirtualMachine = new VirtualMachineRunCommandByVirtualMachine("virtualMachineRunCommandByVirtualMachine", VirtualMachineRunCommandByVirtualMachineArgs.builder()
 *             .asyncExecution(false)
 *             .errorBlobUri("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D")
 *             .location("West US")
 *             .outputBlobManagedIdentity(RunCommandManagedIdentityArgs.builder()
 *                 .clientId("22d35efb-0c99-4041-8c5b-6d24db33a69a")
 *                 .build())
 *             .outputBlobUri("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt")
 *             .parameters(
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param1")
 *                     .value("value1")
 *                     .build(),
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param2")
 *                     .value("value2")
 *                     .build())
 *             .resourceGroupName("myResourceGroup")
 *             .runAsPassword("<runAsPassword>")
 *             .runAsUser("user1")
 *             .runCommandName("myRunCommand")
 *             .source(VirtualMachineRunCommandScriptSourceArgs.builder()
 *                 .scriptUri("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D")
 *                 .build())
 *             .timeoutInSeconds(3600)
 *             .treatFailureAsDeploymentFailure(false)
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineRunCommandByVirtualMachine myRunCommand /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}
 * ```
 */
public class VirtualMachineRunCommandByVirtualMachine internal constructor(
    override val javaResource:
    com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineRunCommandByVirtualMachineMapper) {
    /**
     * Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
     */
    public val asyncExecution: Output<Boolean>?
        get() = javaResource.asyncExecution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    public val errorBlobManagedIdentity: Output<RunCommandManagedIdentityResponse>?
        get() = javaResource.errorBlobManagedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> runCommandManagedIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    public val errorBlobUri: Output<String>?
        get() = javaResource.errorBlobUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine run command instance view.
     */
    public val instanceView: Output<VirtualMachineRunCommandInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineRunCommandInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    public val outputBlobManagedIdentity: Output<RunCommandManagedIdentityResponse>?
        get() = javaResource.outputBlobManagedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> runCommandManagedIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    public val outputBlobUri: Output<String>?
        get() = javaResource.outputBlobUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameters used by the script.
     */
    public val parameters: Output<List<RunCommandInputParameterResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> runCommandInputParameterResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The parameters used by the script.
     */
    public val protectedParameters: Output<List<RunCommandInputParameterResponse>>?
        get() = javaResource.protectedParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        runCommandInputParameterResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response. If treatFailureAsDeploymentFailure set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If treatFailureAsDeploymentFailure set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies the user account password on the VM when executing the run command.
     */
    public val runAsPassword: Output<String>?
        get() = javaResource.runAsPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the user account on the VM when executing the run command.
     */
    public val runAsUser: Output<String>?
        get() = javaResource.runAsUser().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source of the run command script.
     */
    public val source: Output<VirtualMachineRunCommandScriptSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineRunCommandScriptSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The timeout in seconds to execute the run command.
     */
    public val timeoutInSeconds: Output<Int>?
        get() = javaResource.timeoutInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    public val treatFailureAsDeploymentFailure: Output<Boolean>?
        get() = javaResource.treatFailureAsDeploymentFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualMachineRunCommandByVirtualMachineMapper :
    ResourceMapper<VirtualMachineRunCommandByVirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineRunCommandByVirtualMachine =
        VirtualMachineRunCommandByVirtualMachine(
            javaResource as
                com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine,
        )
}

/**
 * @see [VirtualMachineRunCommandByVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineRunCommandByVirtualMachine].
 */
public suspend fun virtualMachineRunCommandByVirtualMachine(
    name: String,
    block: suspend VirtualMachineRunCommandByVirtualMachineResourceBuilder.() -> Unit,
):
    VirtualMachineRunCommandByVirtualMachine {
    val builder = VirtualMachineRunCommandByVirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineRunCommandByVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineRunCommandByVirtualMachine(name: String):
    VirtualMachineRunCommandByVirtualMachine {
    val builder = VirtualMachineRunCommandByVirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
