@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandInputParameterArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandInputParameterArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandManagedIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandManagedIdentityArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineRunCommandScriptSourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineRunCommandScriptSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine run command.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a run command.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineRunCommandByVirtualMachine = new AzureNative.Compute.VirtualMachineRunCommandByVirtualMachine("virtualMachineRunCommandByVirtualMachine", new()
 *     {
 *         AsyncExecution = false,
 *         ErrorBlobUri = "https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D",
 *         Location = "West US",
 *         OutputBlobManagedIdentity = new AzureNative.Compute.Inputs.RunCommandManagedIdentityArgs
 *         {
 *             ClientId = "22d35efb-0c99-4041-8c5b-6d24db33a69a",
 *         },
 *         OutputBlobUri = "https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt",
 *         Parameters = new[]
 *         {
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param1",
 *                 Value = "value1",
 *             },
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param2",
 *                 Value = "value2",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RunAsPassword = "<runAsPassword>",
 *         RunAsUser = "user1",
 *         RunCommandName = "myRunCommand",
 *         Source = new AzureNative.Compute.Inputs.VirtualMachineRunCommandScriptSourceArgs
 *         {
 *             ScriptUri = "https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D",
 *         },
 *         TimeoutInSeconds = 3600,
 *         TreatFailureAsDeploymentFailure = false,
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineRunCommandByVirtualMachine(ctx, "virtualMachineRunCommandByVirtualMachine", &compute.VirtualMachineRunCommandByVirtualMachineArgs{
 * 			AsyncExecution: pulumi.Bool(false),
 * 			ErrorBlobUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D"),
 * 			Location:       pulumi.String("West US"),
 * 			OutputBlobManagedIdentity: &compute.RunCommandManagedIdentityArgs{
 * 				ClientId: pulumi.String("22d35efb-0c99-4041-8c5b-6d24db33a69a"),
 * 			},
 * 			OutputBlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt"),
 * 			Parameters: compute.RunCommandInputParameterArray{
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param1"),
 * 					Value: pulumi.String("value1"),
 * 				},
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param2"),
 * 					Value: pulumi.String("value2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunAsPassword:     pulumi.String("<runAsPassword>"),
 * 			RunAsUser:         pulumi.String("user1"),
 * 			RunCommandName:    pulumi.String("myRunCommand"),
 * 			Source: &compute.VirtualMachineRunCommandScriptSourceArgs{
 * 				ScriptUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D"),
 * 			},
 * 			TimeoutInSeconds:                pulumi.Int(3600),
 * 			TreatFailureAsDeploymentFailure: pulumi.Bool(false),
 * 			VmName:                          pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineRunCommandScriptSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineRunCommandByVirtualMachine = new VirtualMachineRunCommandByVirtualMachine("virtualMachineRunCommandByVirtualMachine", VirtualMachineRunCommandByVirtualMachineArgs.builder()
 *             .asyncExecution(false)
 *             .errorBlobUri("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt?sp=racw&st=2022-10-07T19:40:21Z&se=2022-10-08T03:40:21Z&spr=https&sv=2021-06-08&sr=b&sig=Yh7B%2Fy83olbYBdfsfbUREvd7ol8Dq5EVP3lAO4Kj4xDcN8%3D")
 *             .location("West US")
 *             .outputBlobManagedIdentity(RunCommandManagedIdentityArgs.builder()
 *                 .clientId("22d35efb-0c99-4041-8c5b-6d24db33a69a")
 *                 .build())
 *             .outputBlobUri("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt")
 *             .parameters(
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param1")
 *                     .value("value1")
 *                     .build(),
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param2")
 *                     .value("value2")
 *                     .build())
 *             .resourceGroupName("myResourceGroup")
 *             .runAsPassword("<runAsPassword>")
 *             .runAsUser("user1")
 *             .runCommandName("myRunCommand")
 *             .source(VirtualMachineRunCommandScriptSourceArgs.builder()
 *                 .scriptUri("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1?sp=r&st=2022-10-07T19:52:54Z&se=2022-10-08T03:52:54Z&spr=https&sv=2021-06-08&sr=b&sig=zfYFYCgea1PqVERZuwJiewrte5gjTnKGtVJngcw5oc828%3D")
 *                 .build())
 *             .timeoutInSeconds(3600)
 *             .treatFailureAsDeploymentFailure(false)
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineRunCommandByVirtualMachine myRunCommand /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}
 * ```
 * @property asyncExecution Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
 * @property errorBlobManagedIdentity User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property errorBlobUri Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
 * @property location Resource location
 * @property outputBlobManagedIdentity User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property outputBlobUri Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
 * @property parameters The parameters used by the script.
 * @property protectedParameters The parameters used by the script.
 * @property resourceGroupName The name of the resource group.
 * @property runAsPassword Specifies the user account password on the VM when executing the run command.
 * @property runAsUser Specifies the user account on the VM when executing the run command.
 * @property runCommandName The name of the virtual machine run command.
 * @property source The source of the run command script.
 * @property tags Resource tags
 * @property timeoutInSeconds The timeout in seconds to execute the run command.
 * @property treatFailureAsDeploymentFailure Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
 * @property vmName The name of the virtual machine where the run command should be created or updated.
 */
public data class VirtualMachineRunCommandByVirtualMachineArgs(
    public val asyncExecution: Output<Boolean>? = null,
    public val errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val errorBlobUri: Output<String>? = null,
    public val location: Output<String>? = null,
    public val outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val outputBlobUri: Output<String>? = null,
    public val parameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsPassword: Output<String>? = null,
    public val runAsUser: Output<String>? = null,
    public val runCommandName: Output<String>? = null,
    public val source: Output<VirtualMachineRunCommandScriptSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
    public val treatFailureAsDeploymentFailure: Output<Boolean>? = null,
    public val vmName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs =
        com.pulumi.azurenative.compute.VirtualMachineRunCommandByVirtualMachineArgs.builder()
            .asyncExecution(asyncExecution?.applyValue({ args0 -> args0 }))
            .errorBlobManagedIdentity(
                errorBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .errorBlobUri(errorBlobUri?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .outputBlobManagedIdentity(
                outputBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputBlobUri(outputBlobUri?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protectedParameters(
                protectedParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsPassword(runAsPassword?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 }))
            .runCommandName(runCommandName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .treatFailureAsDeploymentFailure(treatFailureAsDeploymentFailure?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineRunCommandByVirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineRunCommandByVirtualMachineArgsBuilder internal constructor() {
    private var asyncExecution: Output<Boolean>? = null

    private var errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var errorBlobUri: Output<String>? = null

    private var location: Output<String>? = null

    private var outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var outputBlobUri: Output<String>? = null

    private var parameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsPassword: Output<String>? = null

    private var runAsUser: Output<String>? = null

    private var runCommandName: Output<String>? = null

    private var source: Output<VirtualMachineRunCommandScriptSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeoutInSeconds: Output<Int>? = null

    private var treatFailureAsDeploymentFailure: Output<Boolean>? = null

    private var vmName: Output<String>? = null

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
     */
    @JvmName("fjitrnkrwiobuore")
    public suspend fun asyncExecution(`value`: Output<Boolean>) {
        this.asyncExecution = value
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("vnguamucqpigextc")
    public suspend fun errorBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.errorBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("tgfskrjbjnywrgfa")
    public suspend fun errorBlobUri(`value`: Output<String>) {
        this.errorBlobUri = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("brkpywmuxjeettqp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("pjkesaadmsxkdcaf")
    public suspend fun outputBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.outputBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("firkuhdqiivmvtcp")
    public suspend fun outputBlobUri(`value`: Output<String>) {
        this.outputBlobUri = value
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("qvcgceyphyhylyjc")
    public suspend fun parameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("nskmrcbvuqoslxtf")
    public suspend fun parameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("txrhodixnyfadefi")
    public suspend fun parameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("jlaybyldgwvqpikc")
    public suspend fun protectedParameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.protectedParameters = value
    }

    @JvmName("fvnurfglmtdulpoq")
    public suspend fun protectedParameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.protectedParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("limsxibehcbsdlgj")
    public suspend fun protectedParameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.protectedParameters = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tomgfwvftuwjcito")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the user account password on the VM when executing the run command.
     */
    @JvmName("bifeyxowrrsefhqy")
    public suspend fun runAsPassword(`value`: Output<String>) {
        this.runAsPassword = value
    }

    /**
     * @param value Specifies the user account on the VM when executing the run command.
     */
    @JvmName("nvjejemgtttyvlbs")
    public suspend fun runAsUser(`value`: Output<String>) {
        this.runAsUser = value
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("gwdwmtuqtpypqoor")
    public suspend fun runCommandName(`value`: Output<String>) {
        this.runCommandName = value
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("qoqbnvmqejwovwkl")
    public suspend fun source(`value`: Output<VirtualMachineRunCommandScriptSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("uxrcxuojwryorqdg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("ibnvokgxupwtbmvx")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    @JvmName("qckiikscvjuspsee")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Output<Boolean>) {
        this.treatFailureAsDeploymentFailure = value
    }

    /**
     * @param value The name of the virtual machine where the run command should be created or updated.
     */
    @JvmName("bwklegwypbwbdkje")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
     */
    @JvmName("foyfkqgtaikqibne")
    public suspend fun asyncExecution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncExecution = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("qwejiubpgrxurgbo")
    public suspend fun errorBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("vthsobnuxpblhtfy")
    public suspend
    fun errorBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("snkplvtsnfgosbws")
    public suspend fun errorBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobUri = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("wleioxwqqwdvtjfr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("vijvuanhcngbwtqs")
    public suspend fun outputBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("exppefotfvmtfoth")
    public suspend
    fun outputBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("aiegdeowlbxaocke")
    public suspend fun outputBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobUri = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("lciileedaqhitflu")
    public suspend fun parameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("vrbsgqsdawtoeijh")
    public suspend
    fun parameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("fgaxwfuhgxdnnsed")
    public suspend fun parameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("qnckxqkgwicuyhlq")
    public suspend fun parameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("heqtooahkaubmcqi")
    public suspend fun parameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("bnhdxhvekrjqnjuv")
    public suspend fun protectedParameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("kmpwbqeugojpirig")
    public suspend
    fun protectedParameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("omrrhmhwuubiteoq")
    public suspend fun protectedParameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("bbhufwawrqpdgvqx")
    public suspend
    fun protectedParameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("eauymdmosnqrhqpm")
    public suspend fun protectedParameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ltdncgecdsdggxho")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the user account password on the VM when executing the run command.
     */
    @JvmName("qijxacxkhhbluhjx")
    public suspend fun runAsPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsPassword = mapped
    }

    /**
     * @param value Specifies the user account on the VM when executing the run command.
     */
    @JvmName("xmkmaoehllyvaxvk")
    public suspend fun runAsUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("cakdpdjnvjslsjmk")
    public suspend fun runCommandName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runCommandName = mapped
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("rkeskaacmtflapoy")
    public suspend fun source(`value`: VirtualMachineRunCommandScriptSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of the run command script.
     */
    @JvmName("rurbrpkvhqxoxooa")
    public suspend
    fun source(argument: suspend VirtualMachineRunCommandScriptSourceArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineRunCommandScriptSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("awtufoyrytdmuukv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("coqcmoelhcmjyqhu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("rusqgsmttraqguac")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    @JvmName("fmyscvepurgjrvln")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.treatFailureAsDeploymentFailure = mapped
    }

    /**
     * @param value The name of the virtual machine where the run command should be created or updated.
     */
    @JvmName("kmirtndcawccjhel")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    internal fun build(): VirtualMachineRunCommandByVirtualMachineArgs =
        VirtualMachineRunCommandByVirtualMachineArgs(
            asyncExecution = asyncExecution,
            errorBlobManagedIdentity = errorBlobManagedIdentity,
            errorBlobUri = errorBlobUri,
            location = location,
            outputBlobManagedIdentity = outputBlobManagedIdentity,
            outputBlobUri = outputBlobUri,
            parameters = parameters,
            protectedParameters = protectedParameters,
            resourceGroupName = resourceGroupName,
            runAsPassword = runAsPassword,
            runAsUser = runAsUser,
            runCommandName = runCommandName,
            source = source,
            tags = tags,
            timeoutInSeconds = timeoutInSeconds,
            treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure,
            vmName = vmName,
        )
}
