@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse
import com.pulumi.azurenative.compute.kotlin.outputs.AutomaticRepairsPolicyResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PriorityMixPolicyResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ScaleInPolicyResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SpotRestorePolicyResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.UpgradePolicyResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetIdentityResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin as additionalCapabilitiesResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.AutomaticRepairsPolicyResponse.Companion.toKotlin as automaticRepairsPolicyResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PriorityMixPolicyResponse.Companion.toKotlin as priorityMixPolicyResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ScaleInPolicyResponse.Companion.toKotlin as scaleInPolicyResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SpotRestorePolicyResponse.Companion.toKotlin as spotRestorePolicyResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.UpgradePolicyResponse.Companion.toKotlin as upgradePolicyResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetIdentityResponse.Companion.toKotlin as virtualMachineScaleSetIdentityResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProfileResponse.Companion.toKotlin as virtualMachineScaleSetVMProfileResponseToKotlin

/**
 * Builder for [VirtualMachineScaleSet].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineScaleSetArgs = VirtualMachineScaleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineScaleSetArgsBuilder.() -> Unit) {
        val builder = VirtualMachineScaleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineScaleSet {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineScaleSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineScaleSet(builtJavaResource)
    }
}

/**
 * Describes a Virtual Machine Scale Set.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2015-06-15, 2016-04-30-preview, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create a VMSS with an extension that has suppressFailures enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         SuppressFailures = true,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							Publisher:               pulumi.String("{extension-Publisher}"),
 * 							Settings:                pulumi.Any(nil),
 * 							SuppressFailures:        pulumi.Bool(true),
 * 							Type:                    pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion:      pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .suppressFailures(true)
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VMSS with an extension with protectedSettingsFromKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         ProtectedSettingsFromKeyVault = new AzureNative.Compute.Inputs.KeyVaultSecretReferenceArgs
 *                         {
 *                             SecretUrl = "https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e",
 *                             SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName",
 *                             },
 *                         },
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							ProtectedSettingsFromKeyVault: &compute.KeyVaultSecretReferenceArgs{
 * 								SecretUrl: pulumi.String("https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e"),
 * 								SourceVault: &compute.SubResourceArgs{
 * 									Id: pulumi.String("/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName"),
 * 								},
 * 							},
 * 							Publisher:          pulumi.String("{extension-Publisher}"),
 * 							Settings:           pulumi.Any(nil),
 * 							Type:               pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion: pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .protectedSettingsFromKeyVault(KeyVaultSecretReferenceArgs.builder()
 *                             .secretUrl("https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e")
 *                             .sourceVault(SubResourceArgs.builder()
 *                                 .id("/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName")
 *                                 .build())
 *                             .build())
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a custom-image scale set from an unmanaged generalized os image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd",
 *                     },
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Image: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd"),
 * 						},
 * 						Name: pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .image(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd")
 *                             .build())
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a platform-image scale set with unmanaged os disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                     VhdContainers = new[]
 *                     {
 *                         "http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer",
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 						VhdContainers: pulumi.StringArray{
 * 							pulumi.String("http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .vhdContainers(
 *                             "http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a custom image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a generalized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a specialized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set where nic config has DisableTcpStateTracking property
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         DisableTcpStateTracking = true,
 *                         EnableAcceleratedNetworking = true,
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{nicConfig1-name}",
 *                         Primary = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         DisableTcpStateTracking = false,
 *                         EnableAcceleratedNetworking = false,
 *                         EnableIPForwarding = false,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{nicConfig2-name}",
 *                                 Primary = true,
 *                                 PrivateIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{nicConfig2-name}",
 *                         Primary = false,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							DisableTcpStateTracking:     pulumi.Bool(true),
 * 							EnableAcceleratedNetworking: pulumi.Bool(true),
 * 							EnableIPForwarding:          pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{nicConfig1-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							DisableTcpStateTracking:     pulumi.Bool(false),
 * 							EnableAcceleratedNetworking: pulumi.Bool(false),
 * 							EnableIPForwarding:          pulumi.Bool(false),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name:                    pulumi.String("{nicConfig2-name}"),
 * 									Primary:                 pulumi.Bool(true),
 * 									PrivateIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{nicConfig2-name}"),
 * 							Primary: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .disableTcpStateTracking(true)
 *                             .enableAcceleratedNetworking(true)
 *                             .enableIPForwarding(true)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{nicConfig1-name}")
 *                             .primary(true)
 *                             .build(),
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .disableTcpStateTracking(false)
 *                             .enableAcceleratedNetworking(false)
 *                             .enableIPForwarding(false)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{nicConfig2-name}")
 *                                 .primary(true)
 *                                 .privateIPAddressVersion("IPv4")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}")
 *                                     .build())
 *                                 .build())
 *                             .name("{nicConfig2-name}")
 *                             .primary(false)
 *                             .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Application Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             ApplicationProfile = new AzureNative.Compute.Inputs.ApplicationProfileArgs
 *             {
 *                 GalleryApplications = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                     {
 *                         ConfigurationReference = "https://mystorageaccount.blob.core.windows.net/configurations/settings.config",
 *                         EnableAutomaticUpgrade = false,
 *                         Order = 1,
 *                         PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0",
 *                         Tags = "myTag1",
 *                         TreatFailureAsDeploymentFailure = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                     {
 *                         PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				ApplicationProfile: &compute.ApplicationProfileArgs{
 * 					GalleryApplications: compute.VMGalleryApplicationArray{
 * 						&compute.VMGalleryApplicationArgs{
 * 							ConfigurationReference:          pulumi.String("https://mystorageaccount.blob.core.windows.net/configurations/settings.config"),
 * 							EnableAutomaticUpgrade:          pulumi.Bool(false),
 * 							Order:                           pulumi.Int(1),
 * 							PackageReferenceId:              pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0"),
 * 							Tags:                            pulumi.String("myTag1"),
 * 							TreatFailureAsDeploymentFailure: pulumi.Bool(true),
 * 						},
 * 						&compute.VMGalleryApplicationArgs{
 * 							PackageReferenceId: pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .applicationProfile(ApplicationProfileArgs.builder()
 *                     .galleryApplications(
 *                         VMGalleryApplicationArgs.builder()
 *                             .configurationReference("https://mystorageaccount.blob.core.windows.net/configurations/settings.config")
 *                             .enableAutomaticUpgrade(false)
 *                             .order(1)
 *                             .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0")
 *                             .tags("myTag1")
 *                             .treatFailureAsDeploymentFailure(true)
 *                             .build(),
 *                         VMGalleryApplicationArgs.builder()
 *                             .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1")
 *                             .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with DiskEncryptionSet resource in os disk and data disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                         ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                         {
 *                             DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                             {
 *                                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                             },
 *                             StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                         },
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							Caching:      compute.CachingTypesReadWrite,
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 							ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 								DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 									Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 								},
 * 								StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 							},
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(VirtualMachineScaleSetDataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Fpga Network Interfaces.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableAcceleratedNetworking = false,
 *                         EnableFpga = true,
 *                         EnableIPForwarding = false,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{fpgaNic-Name}",
 *                                 Primary = true,
 *                                 PrivateIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{fpgaNic-Name}",
 *                         Primary = false,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableAcceleratedNetworking: pulumi.Bool(false),
 * 							EnableFpga:                  pulumi.Bool(true),
 * 							EnableIPForwarding:          pulumi.Bool(false),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name:                    pulumi.String("{fpgaNic-Name}"),
 * 									Primary:                 pulumi.Bool(true),
 * 									PrivateIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{fpgaNic-Name}"),
 * 							Primary: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .enableIPForwarding(true)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .primary(true)
 *                             .build(),
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .enableAcceleratedNetworking(false)
 *                             .enableFpga(true)
 *                             .enableIPForwarding(false)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{fpgaNic-Name}")
 *                                 .primary(true)
 *                                 .privateIPAddressVersion("IPv4")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{fpgaNic-Name}")
 *                             .primary(false)
 *                             .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Host Encryption using encryptionAtHost property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 EncryptionAtHost = true,
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					EncryptionAtHost: pulumi.Bool(true),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .encryptionAtHost(true)
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with OS image scheduled events enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *             {
 *                 OsImageNotificationProfile = new AzureNative.Compute.Inputs.OSImageNotificationProfileArgs
 *                 {
 *                     Enable = true,
 *                     NotBeforeTimeout = "PT15M",
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 					OsImageNotificationProfile: &compute.OSImageNotificationProfileArgs{
 * 						Enable:           pulumi.Bool(true),
 * 						NotBeforeTimeout: pulumi.String("PT15M"),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                     .osImageNotificationProfile(OSImageNotificationProfileArgs.builder()
 *                         .enable(true)
 *                         .notBeforeTimeout("PT15M")
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Security Posture Reference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "eastus2euap",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_A1",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             AutomaticOSUpgradePolicy = new AzureNative.Compute.Inputs.AutomaticOSUpgradePolicyArgs
 *             {
 *                 EnableAutomaticOSUpgrade = true,
 *             },
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityPostureReference = new AzureNative.Compute.Inputs.SecurityPostureReferenceArgs
 *             {
 *                 Id = "/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2022-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_A1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				AutomaticOSUpgradePolicy: &compute.AutomaticOSUpgradePolicyArgs{
 * 					EnableAutomaticOSUpgrade: pulumi.Bool(true),
 * 				},
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityPostureReference: &compute.SecurityPostureReferenceArgs{
 * 					Id: pulumi.String("/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2022-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityPostureReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("eastus2euap")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_A1")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .automaticOSUpgradePolicy(AutomaticOSUpgradePolicyArgs.builder()
 *                     .enableAutomaticOSUpgrade(true)
 *                     .build())
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityPostureReference(SecurityPostureReferenceArgs.builder()
 *                     .id("/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2022-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with SecurityType as ConfidentialVM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DC2as_v5",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *                 UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *                 {
 *                     SecureBootEnabled = true,
 *                     VTpmEnabled = true,
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "2019-datacenter-cvm",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "windows-cvm",
 *                     Version = "17763.2183.2109130127",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                         {
 *                             SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.VMGuestStateOnly,
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DC2as_v5"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 					UefiSettings: &compute.UefiSettingsArgs{
 * 						SecureBootEnabled: pulumi.Bool(true),
 * 						VTpmEnabled:       pulumi.Bool(true),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("2019-datacenter-cvm"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("windows-cvm"),
 * 						Version:   pulumi.String("17763.2183.2109130127"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 								SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesVMGuestStateOnly),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DC2as_v5")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .securityType("ConfidentialVM")
 *                     .uefiSettings(UefiSettingsArgs.builder()
 *                         .secureBootEnabled(true)
 *                         .vTpmEnabled(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("2019-datacenter-cvm")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("windows-cvm")
 *                         .version("17763.2183.2109130127")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                                 .securityEncryptionType("VMGuestStateOnly")
 *                                 .build())
 *                             .storageAccountType("StandardSSD_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Service Artifact Reference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "eastus2euap",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_A1",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             AutomaticOSUpgradePolicy = new AzureNative.Compute.Inputs.AutomaticOSUpgradePolicyArgs
 *             {
 *                 EnableAutomaticOSUpgrade = true,
 *             },
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ServiceArtifactReference = new AzureNative.Compute.Inputs.ServiceArtifactReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2022-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_A1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				AutomaticOSUpgradePolicy: &compute.AutomaticOSUpgradePolicyArgs{
 * 					EnableAutomaticOSUpgrade: pulumi.Bool(true),
 * 				},
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ServiceArtifactReference: &compute.ServiceArtifactReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2022-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ServiceArtifactReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("eastus2euap")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_A1")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .automaticOSUpgradePolicy(AutomaticOSUpgradePolicyArgs.builder()
 *                     .enableAutomaticOSUpgrade(true)
 *                     .build())
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .serviceArtifactReference(ServiceArtifactReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2022-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Uefi Settings of secureBoot and vTPM.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D2s_v3",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 SecurityType = AzureNative.Compute.SecurityTypes.TrustedLaunch,
 *                 UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *                 {
 *                     SecureBootEnabled = true,
 *                     VTpmEnabled = true,
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windowsserver-gen2preview-preview",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "windows10-tvm",
 *                     Version = "18363.592.2001092016",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D2s_v3"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					SecurityType: pulumi.String(compute.SecurityTypesTrustedLaunch),
 * 					UefiSettings: &compute.UefiSettingsArgs{
 * 						SecureBootEnabled: pulumi.Bool(true),
 * 						VTpmEnabled:       pulumi.Bool(true),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windowsserver-gen2preview-preview"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("windows10-tvm"),
 * 						Version:   pulumi.String("18363.592.2001092016"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D2s_v3")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .securityType("TrustedLaunch")
 *                     .uefiSettings(UefiSettingsArgs.builder()
 *                         .secureBootEnabled(true)
 *                         .vTpmEnabled(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windowsserver-gen2preview-preview")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("windows10-tvm")
 *                         .version("18363.592.2001092016")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("StandardSSD_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with a marketplace image plan.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with an azure application gateway.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 ApplicationGatewayBackendAddressPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}",
 *                                     },
 *                                 },
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}"),
 * 										},
 * 									},
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .applicationGatewayBackendAddressPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}")
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with an azure load balancer.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 LoadBalancerBackendAddressPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}",
 *                                     },
 *                                 },
 *                                 LoadBalancerInboundNatPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}",
 *                                     },
 *                                 },
 *                                 Name = "{vmss-name}",
 *                                 PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs
 *                                 {
 *                                     Name = "{vmss-name}",
 *                                     PublicIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 },
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}"),
 * 										},
 * 									},
 * 									LoadBalancerInboundNatPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}"),
 * 										},
 * 									},
 * 									Name: pulumi.String("{vmss-name}"),
 * 									PublicIPAddressConfiguration: &compute.VirtualMachineScaleSetPublicIPAddressConfigurationArgs{
 * 										Name:                   pulumi.String("{vmss-name}"),
 * 										PublicIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									},
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .loadBalancerBackendAddressPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}")
 *                                 .build())
 *                             .loadBalancerInboundNatPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}")
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .publicIPAddressConfiguration(VirtualMachineScaleSetPublicIPAddressConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .publicIPAddressVersion("IPv4")
 *                                 .build())
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with automatic repairs enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         AutomaticRepairsPolicy = new AzureNative.Compute.Inputs.AutomaticRepairsPolicyArgs
 *         {
 *             Enabled = true,
 *             GracePeriod = "PT10M",
 *         },
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			AutomaticRepairsPolicy: &compute.AutomaticRepairsPolicyArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				GracePeriod: pulumi.String("PT10M"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .automaticRepairsPolicy(AutomaticRepairsPolicyArgs.builder()
 *                 .enabled(true)
 *                 .gracePeriod("PT10M")
 *                 .build())
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with empty data disks on each vm.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D2_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 1,
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiskSizeGB = 512,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D2_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 						},
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(1),
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiskSizeGB:   pulumi.Int(512),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D2_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(0)
 *                             .build(),
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(1)
 *                             .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .diskSizeGB(512)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ephemeral os disks using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                     {
 *                         Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                         Placement = AzureNative.Compute.DiffDiskPlacement.ResourceDisk,
 *                     },
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 							Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 							Placement: pulumi.String(compute.DiffDiskPlacementResourceDisk),
 * 						},
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                             .option("Local")
 *                             .placement("ResourceDisk")
 *                             .build())
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ephemeral os disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                     {
 *                         Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     },
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 							Option: pulumi.String(compute.DiffDiskOptionsLocal),
 * 						},
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                             .option("Local")
 *                             .build())
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with extension time budget.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *                 ExtensionsTimeBudget = "PT1H20M",
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							Publisher:               pulumi.String("{extension-Publisher}"),
 * 							Settings:                pulumi.Any(nil),
 * 							Type:                    pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion:      pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 					ExtensionsTimeBudget: pulumi.String("PT1H20M"),
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .extensionsTimeBudget("PT1H20M")
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with managed boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with password authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with premium storage.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Premium_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with priority mix policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         OrchestrationMode = AzureNative.Compute.OrchestrationMode.Flexible,
 *         PriorityMixPolicy = new AzureNative.Compute.Inputs.PriorityMixPolicyArgs
 *         {
 *             BaseRegularPriorityCount = 4,
 *             RegularPriorityPercentageAboveBase = 50,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SinglePlacementGroup = false,
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 10,
 *             Name = "Standard_A8m_v2",
 *             Tier = "Standard",
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             BillingProfile = new AzureNative.Compute.Inputs.BillingProfileArgs
 *             {
 *                 MaxPrice = -1,
 *             },
 *             EvictionPolicy = AzureNative.Compute.VirtualMachineEvictionPolicyTypes.Deallocate,
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             Priority = AzureNative.Compute.VirtualMachinePriorityTypes.Spot,
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			OrchestrationMode: pulumi.String(compute.OrchestrationModeFlexible),
 * 			PriorityMixPolicy: &compute.PriorityMixPolicyArgs{
 * 				BaseRegularPriorityCount:           pulumi.Int(4),
 * 				RegularPriorityPercentageAboveBase: pulumi.Int(50),
 * 			},
 * 			ResourceGroupName:    pulumi.String("myResourceGroup"),
 * 			SinglePlacementGroup: pulumi.Bool(false),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(10),
 * 				Name:     pulumi.String("Standard_A8m_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				BillingProfile: &compute.BillingProfileArgs{
 * 					MaxPrice: -1,
 * 				},
 * 				EvictionPolicy: pulumi.String(compute.VirtualMachineEvictionPolicyTypesDeallocate),
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				Priority: pulumi.String(compute.VirtualMachinePriorityTypesSpot),
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BillingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .orchestrationMode("Flexible")
 *             .priorityMixPolicy(PriorityMixPolicyArgs.builder()
 *                 .baseRegularPriorityCount(4)
 *                 .regularPriorityPercentageAboveBase(50)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .singlePlacementGroup(false)
 *             .sku(SkuArgs.builder()
 *                 .capacity(10)
 *                 .name("Standard_A8m_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .billingProfile(BillingProfileArgs.builder()
 *                     .maxPrice("TODO: GenUnaryOpExpression")
 *                     .build())
 *                 .evictionPolicy("Deallocate")
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .priority("Spot")
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with scaleInPolicy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         ScaleInPolicy = new AzureNative.Compute.Inputs.ScaleInPolicyArgs
 *         {
 *             ForceDeletion = true,
 *             Rules = new[]
 *             {
 *                 AzureNative.Compute.VirtualMachineScaleSetScaleInRules.OldestVM,
 *             },
 *         },
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScaleInPolicy: &compute.ScaleInPolicyArgs{
 * 				ForceDeletion: pulumi.Bool(true),
 * 				Rules: pulumi.StringArray{
 * 					pulumi.String(compute.VirtualMachineScaleSetScaleInRulesOldestVM),
 * 				},
 * 			},
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.ScaleInPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .scaleInPolicy(ScaleInPolicyArgs.builder()
 *                 .forceDeletion(true)
 *                 .rules("OldestVM")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with spot restore policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_A8m_v2",
 *             Tier = "Standard",
 *         },
 *         SpotRestorePolicy = new AzureNative.Compute.Inputs.SpotRestorePolicyArgs
 *         {
 *             Enabled = true,
 *             RestoreTimeout = "PT1H",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             BillingProfile = new AzureNative.Compute.Inputs.BillingProfileArgs
 *             {
 *                 MaxPrice = -1,
 *             },
 *             EvictionPolicy = AzureNative.Compute.VirtualMachineEvictionPolicyTypes.Deallocate,
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             Priority = AzureNative.Compute.VirtualMachinePriorityTypes.Spot,
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(2),
 * 				Name:     pulumi.String("Standard_A8m_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			SpotRestorePolicy: &compute.SpotRestorePolicyArgs{
 * 				Enabled:        pulumi.Bool(true),
 * 				RestoreTimeout: pulumi.String("PT1H"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				BillingProfile: &compute.BillingProfileArgs{
 * 					MaxPrice: -1,
 * 				},
 * 				EvictionPolicy: pulumi.String(compute.VirtualMachineEvictionPolicyTypesDeallocate),
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				Priority: pulumi.String(compute.VirtualMachinePriorityTypesSpot),
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BillingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("Standard_A8m_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .spotRestorePolicy(SpotRestorePolicyArgs.builder()
 *                 .enabled(true)
 *                 .restoreTimeout("PT1H")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .billingProfile(BillingProfileArgs.builder()
 *                     .maxPrice("TODO: GenUnaryOpExpression")
 *                     .build())
 *                 .evictionPolicy("Deallocate")
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .priority("Spot")
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ssh authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *                 LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *                 {
 *                     DisablePasswordAuthentication = true,
 *                     Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                     {
 *                         PublicKeys = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                             {
 *                                 KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1",
 *                                 Path = "/home/{your-username}/.ssh/authorized_keys",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 					LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 						DisablePasswordAuthentication: pulumi.Bool(true),
 * 						Ssh: &compute.SshConfigurationArgs{
 * 							PublicKeys: compute.SshPublicKeyTypeArray{
 * 								&compute.SshPublicKeyTypeArgs{
 * 									KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1"),
 * 									Path:    pulumi.String("/home/{your-username}/.ssh/authorized_keys"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.SshConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                         .disablePasswordAuthentication(true)
 *                         .ssh(SshConfigurationArgs.builder()
 *                             .publicKeys(SshPublicKeyArgs.builder()
 *                                 .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1")
 *                                 .path("/home/{your-username}/.ssh/authorized_keys")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with terminate scheduled events enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *             {
 *                 TerminateNotificationProfile = new AzureNative.Compute.Inputs.TerminateNotificationProfileArgs
 *                 {
 *                     Enable = true,
 *                     NotBeforeTimeout = "PT5M",
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 					TerminateNotificationProfile: &compute.TerminateNotificationProfileArgs{
 * 						Enable:           pulumi.Bool(true),
 * 						NotBeforeTimeout: pulumi.String("PT5M"),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                     .terminateNotificationProfile(TerminateNotificationProfileArgs.builder()
 *                         .enable(true)
 *                         .notBeforeTimeout("PT5M")
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with userData.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with virtual machines in different zones.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "centralus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_A1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 1,
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiskSizeGB = 512,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *         Zones = new[]
 *         {
 *             "1",
 *             "3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("centralus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(2),
 * 				Name:     pulumi.String("Standard_A1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 						},
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(1),
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiskSizeGB:   pulumi.Int(512),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("centralus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("Standard_A1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(0)
 *                             .build(),
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(1)
 *                             .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .diskSizeGB(512)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .zones(
 *                 "1",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with vm size properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             HardwareProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetHardwareProfileArgs
 *             {
 *                 VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *                 {
 *                     VCPUsAvailable = 1,
 *                     VCPUsPerCore = 1,
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				HardwareProfile: &compute.VirtualMachineScaleSetHardwareProfileArgs{
 * 					VmSizeProperties: &compute.VMSizePropertiesArgs{
 * 						VCPUsAvailable: pulumi.Int(1),
 * 						VCPUsPerCore:   pulumi.Int(1),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .hardwareProfile(VirtualMachineScaleSetHardwareProfileArgs.builder()
 *                     .vmSizeProperties(VMSizePropertiesArgs.builder()
 *                         .vCPUsAvailable(1)
 *                         .vCPUsPerCore(1)
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scale set with capacity reservation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             CapacityReservation = new AzureNative.Compute.Inputs.CapacityReservationProfileArgs
 *             {
 *                 CapacityReservationGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}",
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				CapacityReservation: &compute.CapacityReservationProfileArgs{
 * 					CapacityReservationGroup: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}"),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CapacityReservationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .capacityReservation(CapacityReservationProfileArgs.builder()
 *                     .capacityReservationGroup(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSet {vmss-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}
 * ```
 */
public class VirtualMachineScaleSet internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachineScaleSet,
) : KotlinCustomResource(javaResource, VirtualMachineScaleSetMapper) {
    /**
     * Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    public val additionalCapabilities: Output<AdditionalCapabilitiesResponse>?
        get() = javaResource.additionalCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> additionalCapabilitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Policy for automatic repairs.
     */
    public val automaticRepairsPolicy: Output<AutomaticRepairsPolicyResponse>?
        get() = javaResource.automaticRepairsPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> automaticRepairsPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Optional property which must either be set to True or omitted.
     */
    public val constrainedMaximumCapacity: Output<Boolean>?
        get() = javaResource.constrainedMaximumCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
     */
    public val doNotRunExtensionsOnOverprovisionedVMs: Output<Boolean>?
        get() = javaResource.doNotRunExtensionsOnOverprovisionedVMs().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The extended location of the Virtual Machine Scale Set.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
     */
    public val hostGroup: Output<SubResourceResponse>?
        get() = javaResource.hostGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identity of the virtual machine scale set, if configured.
     */
    public val identity: Output<VirtualMachineScaleSetIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineScaleSetIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the orchestration mode for the virtual machine scale set.
     */
    public val orchestrationMode: Output<String>?
        get() = javaResource.orchestrationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the Virtual Machine Scale Set should be overprovisioned.
     */
    public val overprovision: Output<Boolean>?
        get() = javaResource.overprovision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Fault Domain count for each placement group.
     */
    public val platformFaultDomainCount: Output<Int>?
        get() = javaResource.platformFaultDomainCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
     */
    public val priorityMixPolicy: Output<PriorityMixPolicyResponse>?
        get() = javaResource.priorityMixPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> priorityMixPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
     */
    public val proximityPlacementGroup: Output<SubResourceResponse>?
        get() = javaResource.proximityPlacementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
     */
    public val scaleInPolicy: Output<ScaleInPolicyResponse>?
        get() = javaResource.scaleInPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> scaleInPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
     */
    public val singlePlacementGroup: Output<Boolean>?
        get() = javaResource.singlePlacementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine scale set sku.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the Spot Restore properties for the virtual machine scale set.
     */
    public val spotRestorePolicy: Output<SpotRestorePolicyResponse>?
        get() = javaResource.spotRestorePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotRestorePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the time at which the Virtual Machine Scale Set resource was created. Minimum api-version: 2021-11-01.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })

    /**
     * The upgrade policy.
     */
    public val upgradePolicy: Output<UpgradePolicyResponse>?
        get() = javaResource.upgradePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> upgradePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The virtual machine profile.
     */
    public val virtualMachineProfile: Output<VirtualMachineScaleSetVMProfileResponse>?
        get() = javaResource.virtualMachineProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineScaleSetVMProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
     */
    public val zoneBalance: Output<Boolean>?
        get() = javaResource.zoneBalance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object VirtualMachineScaleSetMapper : ResourceMapper<VirtualMachineScaleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineScaleSet::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineScaleSet =
        VirtualMachineScaleSet(javaResource as com.pulumi.azurenative.compute.VirtualMachineScaleSet)
}

/**
 * @see [VirtualMachineScaleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineScaleSet].
 */
public suspend fun virtualMachineScaleSet(
    name: String,
    block: suspend VirtualMachineScaleSetResourceBuilder.() -> Unit,
): VirtualMachineScaleSet {
    val builder = VirtualMachineScaleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineScaleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineScaleSet(name: String): VirtualMachineScaleSet {
    val builder = VirtualMachineScaleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
