@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.OrchestrationMode
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.AutomaticRepairsPolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.AutomaticRepairsPolicyArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PriorityMixPolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PriorityMixPolicyArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ScaleInPolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ScaleInPolicyArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SpotRestorePolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SpotRestorePolicyArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.UpgradePolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.UpgradePolicyArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetIdentityArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine Scale Set.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2015-06-15, 2016-04-30-preview, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create a VMSS with an extension that has suppressFailures enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         SuppressFailures = true,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							Publisher:               pulumi.String("{extension-Publisher}"),
 * 							Settings:                pulumi.Any(nil),
 * 							SuppressFailures:        pulumi.Bool(true),
 * 							Type:                    pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion:      pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .suppressFailures(true)
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VMSS with an extension with protectedSettingsFromKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         ProtectedSettingsFromKeyVault = new AzureNative.Compute.Inputs.KeyVaultSecretReferenceArgs
 *                         {
 *                             SecretUrl = "https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e",
 *                             SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName",
 *                             },
 *                         },
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							ProtectedSettingsFromKeyVault: &compute.KeyVaultSecretReferenceArgs{
 * 								SecretUrl: pulumi.String("https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e"),
 * 								SourceVault: &compute.SubResourceArgs{
 * 									Id: pulumi.String("/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName"),
 * 								},
 * 							},
 * 							Publisher:          pulumi.String("{extension-Publisher}"),
 * 							Settings:           pulumi.Any(nil),
 * 							Type:               pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion: pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .protectedSettingsFromKeyVault(KeyVaultSecretReferenceArgs.builder()
 *                             .secretUrl("https://kvName.vault.azure.net/secrets/secretName/79b88b3a6f5440ffb2e73e44a0db712e")
 *                             .sourceVault(SubResourceArgs.builder()
 *                                 .id("/subscriptions/a53f7094-a16c-47af-abe4-b05c05d0d79a/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/kvName")
 *                                 .build())
 *                             .build())
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a custom-image scale set from an unmanaged generalized os image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd",
 *                     },
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Image: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd"),
 * 						},
 * 						Name: pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .image(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd")
 *                             .build())
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a platform-image scale set with unmanaged os disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                     VhdContainers = new[]
 *                     {
 *                         "http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer",
 *                         "http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer",
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 						VhdContainers: pulumi.StringArray{
 * 							pulumi.String("http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer"),
 * 							pulumi.String("http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .vhdContainers(
 *                             "http://{existing-storage-account-name-0}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-1}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-2}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-3}.blob.core.windows.net/vhdContainer",
 *                             "http://{existing-storage-account-name-4}.blob.core.windows.net/vhdContainer")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a custom image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a generalized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set from a specialized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set where nic config has DisableTcpStateTracking property
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         DisableTcpStateTracking = true,
 *                         EnableAcceleratedNetworking = true,
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{nicConfig1-name}",
 *                         Primary = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         DisableTcpStateTracking = false,
 *                         EnableAcceleratedNetworking = false,
 *                         EnableIPForwarding = false,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{nicConfig2-name}",
 *                                 Primary = true,
 *                                 PrivateIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{nicConfig2-name}",
 *                         Primary = false,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							DisableTcpStateTracking:     pulumi.Bool(true),
 * 							EnableAcceleratedNetworking: pulumi.Bool(true),
 * 							EnableIPForwarding:          pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{nicConfig1-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							DisableTcpStateTracking:     pulumi.Bool(false),
 * 							EnableAcceleratedNetworking: pulumi.Bool(false),
 * 							EnableIPForwarding:          pulumi.Bool(false),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name:                    pulumi.String("{nicConfig2-name}"),
 * 									Primary:                 pulumi.Bool(true),
 * 									PrivateIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{nicConfig2-name}"),
 * 							Primary: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .disableTcpStateTracking(true)
 *                             .enableAcceleratedNetworking(true)
 *                             .enableIPForwarding(true)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{nicConfig1-name}")
 *                             .primary(true)
 *                             .build(),
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .disableTcpStateTracking(false)
 *                             .enableAcceleratedNetworking(false)
 *                             .enableIPForwarding(false)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{nicConfig2-name}")
 *                                 .primary(true)
 *                                 .privateIPAddressVersion("IPv4")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name2}")
 *                                     .build())
 *                                 .build())
 *                             .name("{nicConfig2-name}")
 *                             .primary(false)
 *                             .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Application Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             ApplicationProfile = new AzureNative.Compute.Inputs.ApplicationProfileArgs
 *             {
 *                 GalleryApplications = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                     {
 *                         ConfigurationReference = "https://mystorageaccount.blob.core.windows.net/configurations/settings.config",
 *                         EnableAutomaticUpgrade = false,
 *                         Order = 1,
 *                         PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0",
 *                         Tags = "myTag1",
 *                         TreatFailureAsDeploymentFailure = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                     {
 *                         PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1",
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				ApplicationProfile: &compute.ApplicationProfileArgs{
 * 					GalleryApplications: compute.VMGalleryApplicationArray{
 * 						&compute.VMGalleryApplicationArgs{
 * 							ConfigurationReference:          pulumi.String("https://mystorageaccount.blob.core.windows.net/configurations/settings.config"),
 * 							EnableAutomaticUpgrade:          pulumi.Bool(false),
 * 							Order:                           pulumi.Int(1),
 * 							PackageReferenceId:              pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0"),
 * 							Tags:                            pulumi.String("myTag1"),
 * 							TreatFailureAsDeploymentFailure: pulumi.Bool(true),
 * 						},
 * 						&compute.VMGalleryApplicationArgs{
 * 							PackageReferenceId: pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1"),
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .applicationProfile(ApplicationProfileArgs.builder()
 *                     .galleryApplications(
 *                         VMGalleryApplicationArgs.builder()
 *                             .configurationReference("https://mystorageaccount.blob.core.windows.net/configurations/settings.config")
 *                             .enableAutomaticUpgrade(false)
 *                             .order(1)
 *                             .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0")
 *                             .tags("myTag1")
 *                             .treatFailureAsDeploymentFailure(true)
 *                             .build(),
 *                         VMGalleryApplicationArgs.builder()
 *                             .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1")
 *                             .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with DiskEncryptionSet resource in os disk and data disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                         ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                         {
 *                             DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                             {
 *                                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                             },
 *                             StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                         },
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							Caching:      compute.CachingTypesReadWrite,
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 							ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 								DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 									Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 								},
 * 								StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 							},
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(VirtualMachineScaleSetDataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Fpga Network Interfaces.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableAcceleratedNetworking = false,
 *                         EnableFpga = true,
 *                         EnableIPForwarding = false,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{fpgaNic-Name}",
 *                                 Primary = true,
 *                                 PrivateIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{fpgaNic-Name}",
 *                         Primary = false,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableAcceleratedNetworking: pulumi.Bool(false),
 * 							EnableFpga:                  pulumi.Bool(true),
 * 							EnableIPForwarding:          pulumi.Bool(false),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name:                    pulumi.String("{fpgaNic-Name}"),
 * 									Primary:                 pulumi.Bool(true),
 * 									PrivateIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{fpgaNic-Name}"),
 * 							Primary: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .enableIPForwarding(true)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .primary(true)
 *                             .build(),
 *                         VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                             .enableAcceleratedNetworking(false)
 *                             .enableFpga(true)
 *                             .enableIPForwarding(false)
 *                             .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                                 .name("{fpgaNic-Name}")
 *                                 .primary(true)
 *                                 .privateIPAddressVersion("IPv4")
 *                                 .subnet(ApiEntityReferenceArgs.builder()
 *                                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-fpga-subnet-name}")
 *                                     .build())
 *                                 .build())
 *                             .name("{fpgaNic-Name}")
 *                             .primary(false)
 *                             .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Host Encryption using encryptionAtHost property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 EncryptionAtHost = true,
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					EncryptionAtHost: pulumi.Bool(true),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .encryptionAtHost(true)
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with OS image scheduled events enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *             {
 *                 OsImageNotificationProfile = new AzureNative.Compute.Inputs.OSImageNotificationProfileArgs
 *                 {
 *                     Enable = true,
 *                     NotBeforeTimeout = "PT15M",
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 					OsImageNotificationProfile: &compute.OSImageNotificationProfileArgs{
 * 						Enable:           pulumi.Bool(true),
 * 						NotBeforeTimeout: pulumi.String("PT15M"),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                     .osImageNotificationProfile(OSImageNotificationProfileArgs.builder()
 *                         .enable(true)
 *                         .notBeforeTimeout("PT15M")
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Security Posture Reference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "eastus2euap",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_A1",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             AutomaticOSUpgradePolicy = new AzureNative.Compute.Inputs.AutomaticOSUpgradePolicyArgs
 *             {
 *                 EnableAutomaticOSUpgrade = true,
 *             },
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityPostureReference = new AzureNative.Compute.Inputs.SecurityPostureReferenceArgs
 *             {
 *                 Id = "/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2022-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_A1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				AutomaticOSUpgradePolicy: &compute.AutomaticOSUpgradePolicyArgs{
 * 					EnableAutomaticOSUpgrade: pulumi.Bool(true),
 * 				},
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityPostureReference: &compute.SecurityPostureReferenceArgs{
 * 					Id: pulumi.String("/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2022-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityPostureReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("eastus2euap")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_A1")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .automaticOSUpgradePolicy(AutomaticOSUpgradePolicyArgs.builder()
 *                     .enableAutomaticOSUpgrade(true)
 *                     .build())
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityPostureReference(SecurityPostureReferenceArgs.builder()
 *                     .id("/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2022-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with SecurityType as ConfidentialVM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DC2as_v5",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *                 UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *                 {
 *                     SecureBootEnabled = true,
 *                     VTpmEnabled = true,
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "2019-datacenter-cvm",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "windows-cvm",
 *                     Version = "17763.2183.2109130127",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                         {
 *                             SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.VMGuestStateOnly,
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DC2as_v5"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 					UefiSettings: &compute.UefiSettingsArgs{
 * 						SecureBootEnabled: pulumi.Bool(true),
 * 						VTpmEnabled:       pulumi.Bool(true),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("2019-datacenter-cvm"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("windows-cvm"),
 * 						Version:   pulumi.String("17763.2183.2109130127"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 								SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesVMGuestStateOnly),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DC2as_v5")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .securityType("ConfidentialVM")
 *                     .uefiSettings(UefiSettingsArgs.builder()
 *                         .secureBootEnabled(true)
 *                         .vTpmEnabled(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("2019-datacenter-cvm")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("windows-cvm")
 *                         .version("17763.2183.2109130127")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                                 .securityEncryptionType("VMGuestStateOnly")
 *                                 .build())
 *                             .storageAccountType("StandardSSD_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Service Artifact Reference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "eastus2euap",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_A1",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             AutomaticOSUpgradePolicy = new AzureNative.Compute.Inputs.AutomaticOSUpgradePolicyArgs
 *             {
 *                 EnableAutomaticOSUpgrade = true,
 *             },
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ServiceArtifactReference = new AzureNative.Compute.Inputs.ServiceArtifactReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2022-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     Name = "osDisk",
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_A1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				AutomaticOSUpgradePolicy: &compute.AutomaticOSUpgradePolicyArgs{
 * 					EnableAutomaticOSUpgrade: pulumi.Bool(true),
 * 				},
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ServiceArtifactReference: &compute.ServiceArtifactReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2022-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						Name:         pulumi.String("osDisk"),
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ServiceArtifactReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("eastus2euap")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_A1")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .automaticOSUpgradePolicy(AutomaticOSUpgradePolicyArgs.builder()
 *                     .enableAutomaticOSUpgrade(true)
 *                     .build())
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .serviceArtifactReference(ServiceArtifactReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myGalleryName/serviceArtifacts/serviceArtifactName/vmArtifactsProfiles/vmArtifactsProfilesName")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2022-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .name("osDisk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with Uefi Settings of secureBoot and vTPM.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D2s_v3",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *             {
 *                 SecurityType = AzureNative.Compute.SecurityTypes.TrustedLaunch,
 *                 UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *                 {
 *                     SecureBootEnabled = true,
 *                     VTpmEnabled = true,
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windowsserver-gen2preview-preview",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "windows10-tvm",
 *                     Version = "18363.592.2001092016",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D2s_v3"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				SecurityProfile: &compute.SecurityProfileArgs{
 * 					SecurityType: pulumi.String(compute.SecurityTypesTrustedLaunch),
 * 					UefiSettings: &compute.UefiSettingsArgs{
 * 						SecureBootEnabled: pulumi.Bool(true),
 * 						VTpmEnabled:       pulumi.Bool(true),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windowsserver-gen2preview-preview"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("windows10-tvm"),
 * 						Version:   pulumi.String("18363.592.2001092016"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D2s_v3")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .securityType("TrustedLaunch")
 *                     .uefiSettings(UefiSettingsArgs.builder()
 *                         .secureBootEnabled(true)
 *                         .vTpmEnabled(true)
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windowsserver-gen2preview-preview")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("windows10-tvm")
 *                         .version("18363.592.2001092016")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("StandardSSD_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with a marketplace image plan.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with an azure application gateway.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 ApplicationGatewayBackendAddressPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}",
 *                                     },
 *                                 },
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}"),
 * 										},
 * 									},
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .applicationGatewayBackendAddressPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/applicationGateways/{existing-application-gateway-name}/backendAddressPools/{existing-backend-address-pool-name}")
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with an azure load balancer.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 LoadBalancerBackendAddressPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}",
 *                                     },
 *                                 },
 *                                 LoadBalancerInboundNatPools = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.SubResourceArgs
 *                                     {
 *                                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}",
 *                                     },
 *                                 },
 *                                 Name = "{vmss-name}",
 *                                 PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs
 *                                 {
 *                                     Name = "{vmss-name}",
 *                                     PublicIPAddressVersion = AzureNative.Compute.IPVersion.IPv4,
 *                                 },
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}"),
 * 										},
 * 									},
 * 									LoadBalancerInboundNatPools: compute.SubResourceArray{
 * 										&compute.SubResourceArgs{
 * 											Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}"),
 * 										},
 * 									},
 * 									Name: pulumi.String("{vmss-name}"),
 * 									PublicIPAddressConfiguration: &compute.VirtualMachineScaleSetPublicIPAddressConfigurationArgs{
 * 										Name:                   pulumi.String("{vmss-name}"),
 * 										PublicIPAddressVersion: pulumi.String(compute.IPVersionIPv4),
 * 									},
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .loadBalancerBackendAddressPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/backendAddressPools/{existing-backend-address-pool-name}")
 *                                 .build())
 *                             .loadBalancerInboundNatPools(SubResourceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/loadBalancers/{existing-load-balancer-name}/inboundNatPools/{existing-nat-pool-name}")
 *                                 .build())
 *                             .name("{vmss-name}")
 *                             .publicIPAddressConfiguration(VirtualMachineScaleSetPublicIPAddressConfigurationArgs.builder()
 *                                 .name("{vmss-name}")
 *                                 .publicIPAddressVersion("IPv4")
 *                                 .build())
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with automatic repairs enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         AutomaticRepairsPolicy = new AzureNative.Compute.Inputs.AutomaticRepairsPolicyArgs
 *         {
 *             Enabled = true,
 *             GracePeriod = "PT10M",
 *         },
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			AutomaticRepairsPolicy: &compute.AutomaticRepairsPolicyArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				GracePeriod: pulumi.String("PT10M"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .automaticRepairsPolicy(AutomaticRepairsPolicyArgs.builder()
 *                 .enabled(true)
 *                 .gracePeriod("PT10M")
 *                 .build())
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with empty data disks on each vm.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D2_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 1,
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiskSizeGB = 512,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D2_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 						},
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(1),
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiskSizeGB:   pulumi.Int(512),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D2_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(0)
 *                             .build(),
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(1)
 *                             .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .diskSizeGB(512)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ephemeral os disks using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                     {
 *                         Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                         Placement = AzureNative.Compute.DiffDiskPlacement.ResourceDisk,
 *                     },
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 							Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 							Placement: pulumi.String(compute.DiffDiskPlacementResourceDisk),
 * 						},
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                             .option("Local")
 *                             .placement("ResourceDisk")
 *                             .build())
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ephemeral os disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "windows-data-science-vm",
 *                     Publisher = "microsoft-ads",
 *                     Sku = "windows2016",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                     {
 *                         Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     },
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:      pulumi.String("westus"),
 * 			Overprovision: pulumi.Bool(true),
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("windows-data-science-vm"),
 * 						Publisher: pulumi.String("microsoft-ads"),
 * 						Sku:       pulumi.String("windows2016"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadOnly,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 							Option: pulumi.String(compute.DiffDiskOptionsLocal),
 * 						},
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("windows-data-science-vm")
 *                         .publisher("microsoft-ads")
 *                         .sku("windows2016")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadOnly")
 *                         .createOption("FromImage")
 *                         .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                             .option("Local")
 *                             .build())
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with extension time budget.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                     StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *                 },
 *             },
 *             ExtensionProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = false,
 *                         Name = "{extension-name}",
 *                         Publisher = "{extension-Publisher}",
 *                         Settings = null,
 *                         Type = "{extension-Type}",
 *                         TypeHandlerVersion = "{handler-version}",
 *                     },
 *                 },
 *                 ExtensionsTimeBudget = "PT1H20M",
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled:    pulumi.Bool(true),
 * 						StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 					},
 * 				},
 * 				ExtensionProfile: &compute.VirtualMachineScaleSetExtensionProfileArgs{
 * 					Extensions: compute.VirtualMachineScaleSetExtensionTypeArray{
 * 						&compute.VirtualMachineScaleSetExtensionTypeArgs{
 * 							AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 							Name:                    pulumi.String("{extension-name}"),
 * 							Publisher:               pulumi.String("{extension-Publisher}"),
 * 							Settings:                pulumi.Any(nil),
 * 							Type:                    pulumi.String("{extension-Type}"),
 * 							TypeHandlerVersion:      pulumi.String("{handler-version}"),
 * 						},
 * 					},
 * 					ExtensionsTimeBudget: pulumi.String("PT1H20M"),
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .extensionProfile(VirtualMachineScaleSetExtensionProfileArgs.builder()
 *                     .extensions(VirtualMachineScaleSetExtensionArgs.builder()
 *                         .autoUpgradeMinorVersion(false)
 *                         .name("{extension-name}")
 *                         .publisher("{extension-Publisher}")
 *                         .settings()
 *                         .type("{extension-Type}")
 *                         .typeHandlerVersion("{handler-version}")
 *                         .build())
 *                     .extensionsTimeBudget("PT1H20M")
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with managed boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *             {
 *                 BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 					BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                     .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with password authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with premium storage.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Premium_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with priority mix policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         OrchestrationMode = AzureNative.Compute.OrchestrationMode.Flexible,
 *         PriorityMixPolicy = new AzureNative.Compute.Inputs.PriorityMixPolicyArgs
 *         {
 *             BaseRegularPriorityCount = 4,
 *             RegularPriorityPercentageAboveBase = 50,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SinglePlacementGroup = false,
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 10,
 *             Name = "Standard_A8m_v2",
 *             Tier = "Standard",
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             BillingProfile = new AzureNative.Compute.Inputs.BillingProfileArgs
 *             {
 *                 MaxPrice = -1,
 *             },
 *             EvictionPolicy = AzureNative.Compute.VirtualMachineEvictionPolicyTypes.Deallocate,
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             Priority = AzureNative.Compute.VirtualMachinePriorityTypes.Spot,
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			OrchestrationMode: pulumi.String(compute.OrchestrationModeFlexible),
 * 			PriorityMixPolicy: &compute.PriorityMixPolicyArgs{
 * 				BaseRegularPriorityCount:           pulumi.Int(4),
 * 				RegularPriorityPercentageAboveBase: pulumi.Int(50),
 * 			},
 * 			ResourceGroupName:    pulumi.String("myResourceGroup"),
 * 			SinglePlacementGroup: pulumi.Bool(false),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(10),
 * 				Name:     pulumi.String("Standard_A8m_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				BillingProfile: &compute.BillingProfileArgs{
 * 					MaxPrice: -1,
 * 				},
 * 				EvictionPolicy: pulumi.String(compute.VirtualMachineEvictionPolicyTypesDeallocate),
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				Priority: pulumi.String(compute.VirtualMachinePriorityTypesSpot),
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BillingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .orchestrationMode("Flexible")
 *             .priorityMixPolicy(PriorityMixPolicyArgs.builder()
 *                 .baseRegularPriorityCount(4)
 *                 .regularPriorityPercentageAboveBase(50)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .singlePlacementGroup(false)
 *             .sku(SkuArgs.builder()
 *                 .capacity(10)
 *                 .name("Standard_A8m_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .billingProfile(BillingProfileArgs.builder()
 *                     .maxPrice("TODO: GenUnaryOpExpression")
 *                     .build())
 *                 .evictionPolicy("Deallocate")
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .priority("Spot")
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with scaleInPolicy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         ScaleInPolicy = new AzureNative.Compute.Inputs.ScaleInPolicyArgs
 *         {
 *             ForceDeletion = true,
 *             Rules = new[]
 *             {
 *                 AzureNative.Compute.VirtualMachineScaleSetScaleInRules.OldestVM,
 *             },
 *         },
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScaleInPolicy: &compute.ScaleInPolicyArgs{
 * 				ForceDeletion: pulumi.Bool(true),
 * 				Rules: pulumi.StringArray{
 * 					pulumi.String(compute.VirtualMachineScaleSetScaleInRulesOldestVM),
 * 				},
 * 			},
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.ScaleInPolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .scaleInPolicy(ScaleInPolicyArgs.builder()
 *                 .forceDeletion(true)
 *                 .rules("OldestVM")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with spot restore policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_A8m_v2",
 *             Tier = "Standard",
 *         },
 *         SpotRestorePolicy = new AzureNative.Compute.Inputs.SpotRestorePolicyArgs
 *         {
 *             Enabled = true,
 *             RestoreTimeout = "PT1H",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             BillingProfile = new AzureNative.Compute.Inputs.BillingProfileArgs
 *             {
 *                 MaxPrice = -1,
 *             },
 *             EvictionPolicy = AzureNative.Compute.VirtualMachineEvictionPolicyTypes.Deallocate,
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             Priority = AzureNative.Compute.VirtualMachinePriorityTypes.Spot,
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(2),
 * 				Name:     pulumi.String("Standard_A8m_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			SpotRestorePolicy: &compute.SpotRestorePolicyArgs{
 * 				Enabled:        pulumi.Bool(true),
 * 				RestoreTimeout: pulumi.String("PT1H"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				BillingProfile: &compute.BillingProfileArgs{
 * 					MaxPrice: -1,
 * 				},
 * 				EvictionPolicy: pulumi.String(compute.VirtualMachineEvictionPolicyTypesDeallocate),
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				Priority: pulumi.String(compute.VirtualMachinePriorityTypesSpot),
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BillingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("Standard_A8m_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .spotRestorePolicy(SpotRestorePolicyArgs.builder()
 *                 .enabled(true)
 *                 .restoreTimeout("PT1H")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .billingProfile(BillingProfileArgs.builder()
 *                     .maxPrice("TODO: GenUnaryOpExpression")
 *                     .build())
 *                 .evictionPolicy("Deallocate")
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .priority("Spot")
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with ssh authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *                 LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *                 {
 *                     DisablePasswordAuthentication = true,
 *                     Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                     {
 *                         PublicKeys = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                             {
 *                                 KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1",
 *                                 Path = "/home/{your-username}/.ssh/authorized_keys",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 					LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 						DisablePasswordAuthentication: pulumi.Bool(true),
 * 						Ssh: &compute.SshConfigurationArgs{
 * 							PublicKeys: compute.SshPublicKeyTypeArray{
 * 								&compute.SshPublicKeyTypeArgs{
 * 									KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1"),
 * 									Path:    pulumi.String("/home/{your-username}/.ssh/authorized_keys"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.SshConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                         .disablePasswordAuthentication(true)
 *                         .ssh(SshConfigurationArgs.builder()
 *                             .publicKeys(SshPublicKeyArgs.builder()
 *                                 .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1")
 *                                 .path("/home/{your-username}/.ssh/authorized_keys")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with terminate scheduled events enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *             {
 *                 TerminateNotificationProfile = new AzureNative.Compute.Inputs.TerminateNotificationProfileArgs
 *                 {
 *                     Enable = true,
 *                     NotBeforeTimeout = "PT5M",
 *                 },
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 					TerminateNotificationProfile: &compute.TerminateNotificationProfileArgs{
 * 						Enable:           pulumi.Bool(true),
 * 						NotBeforeTimeout: pulumi.String("PT5M"),
 * 					},
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                     .terminateNotificationProfile(TerminateNotificationProfileArgs.builder()
 *                         .enable(true)
 *                         .notBeforeTimeout("PT5M")
 *                         .build())
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with userData.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with virtual machines in different zones.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "centralus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_A1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Automatic,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 0,
 *                     },
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetDataDiskArgs
 *                     {
 *                         CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                         DiskSizeGB = 1023,
 *                         Lun = 1,
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     DiskSizeGB = 512,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *         Zones = new[]
 *         {
 *             "1",
 *             "3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("centralus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(2),
 * 				Name:     pulumi.String("Standard_A1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeAutomatic,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					DataDisks: compute.VirtualMachineScaleSetDataDiskArray{
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(0),
 * 						},
 * 						&compute.VirtualMachineScaleSetDataDiskArgs{
 * 							CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 							DiskSizeGB:   pulumi.Int(1023),
 * 							Lun:          pulumi.Int(1),
 * 						},
 * 					},
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						DiskSizeGB:   pulumi.Int(512),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("centralus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("Standard_A1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Automatic")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .dataDisks(
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(0)
 *                             .build(),
 *                         VirtualMachineScaleSetDataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(1023)
 *                             .lun(1)
 *                             .build())
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .diskSizeGB(512)
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .zones(
 *                 "1",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a scale set with vm size properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_D1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             HardwareProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetHardwareProfileArgs
 *             {
 *                 VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *                 {
 *                     VCPUsAvailable = 1,
 *                     VCPUsPerCore = 1,
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_D1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				HardwareProfile: &compute.VirtualMachineScaleSetHardwareProfileArgs{
 * 					VmSizeProperties: &compute.VMSizePropertiesArgs{
 * 						VCPUsAvailable: pulumi.Int(1),
 * 						VCPUsPerCore:   pulumi.Int(1),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_D1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .hardwareProfile(VirtualMachineScaleSetHardwareProfileArgs.builder()
 *                     .vmSizeProperties(VMSizePropertiesArgs.builder()
 *                         .vCPUsAvailable(1)
 *                         .vCPUsPerCore(1)
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scale set with capacity reservation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSet = new AzureNative.Compute.VirtualMachineScaleSet("virtualMachineScaleSet", new()
 *     {
 *         Location = "westus",
 *         Overprovision = true,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 3,
 *             Name = "Standard_DS1_v2",
 *             Tier = "Standard",
 *         },
 *         UpgradePolicy = new AzureNative.Compute.Inputs.UpgradePolicyArgs
 *         {
 *             Mode = AzureNative.Compute.UpgradeMode.Manual,
 *         },
 *         VirtualMachineProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProfileArgs
 *         {
 *             CapacityReservation = new AzureNative.Compute.Inputs.CapacityReservationProfileArgs
 *             {
 *                 CapacityReservationGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}",
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkProfileArgs
 *             {
 *                 NetworkInterfaceConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                     {
 *                         EnableIPForwarding = true,
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                             {
 *                                 Name = "{vmss-name}",
 *                                 Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}",
 *                                 },
 *                             },
 *                         },
 *                         Name = "{vmss-name}",
 *                         Primary = true,
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSProfileArgs
 *             {
 *                 AdminPassword = "{your-password}",
 *                 AdminUsername = "{your-username}",
 *                 ComputerNamePrefix = "{vmss-name}",
 *             },
 *             StorageProfile = new AzureNative.Compute.Inputs.VirtualMachineScaleSetStorageProfileArgs
 *             {
 *                 ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter",
 *                     Version = "latest",
 *                 },
 *                 OsDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetOSDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.VirtualMachineScaleSetManagedDiskParametersArgs
 *                     {
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *         },
 *         VmScaleSetName = "{vmss-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSet(ctx, "virtualMachineScaleSet", &compute.VirtualMachineScaleSetArgs{
 * 			Location:          pulumi.String("westus"),
 * 			Overprovision:     pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(3),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			UpgradePolicy: &compute.UpgradePolicyArgs{
 * 				Mode: compute.UpgradeModeManual,
 * 			},
 * 			VirtualMachineProfile: &compute.VirtualMachineScaleSetVMProfileArgs{
 * 				CapacityReservation: &compute.CapacityReservationProfileArgs{
 * 					CapacityReservationGroup: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}"),
 * 					},
 * 				},
 * 				NetworkProfile: &compute.VirtualMachineScaleSetNetworkProfileArgs{
 * 					NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * 						&compute.VirtualMachineScaleSetNetworkConfigurationArgs{
 * 							EnableIPForwarding: pulumi.Bool(true),
 * 							IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * 								&compute.VirtualMachineScaleSetIPConfigurationArgs{
 * 									Name: pulumi.String("{vmss-name}"),
 * 									Subnet: &compute.ApiEntityReferenceArgs{
 * 										Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}"),
 * 									},
 * 								},
 * 							},
 * 							Name:    pulumi.String("{vmss-name}"),
 * 							Primary: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.VirtualMachineScaleSetOSProfileArgs{
 * 					AdminPassword:      pulumi.String("{your-password}"),
 * 					AdminUsername:      pulumi.String("{your-username}"),
 * 					ComputerNamePrefix: pulumi.String("{vmss-name}"),
 * 				},
 * 				StorageProfile: &compute.VirtualMachineScaleSetStorageProfileArgs{
 * 					ImageReference: &compute.ImageReferenceArgs{
 * 						Offer:     pulumi.String("WindowsServer"),
 * 						Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 						Sku:       pulumi.String("2016-Datacenter"),
 * 						Version:   pulumi.String("latest"),
 * 					},
 * 					OsDisk: &compute.VirtualMachineScaleSetOSDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 						ManagedDisk: &compute.VirtualMachineScaleSetManagedDiskParametersArgs{
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmScaleSetName: pulumi.String("{vmss-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSet;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CapacityReservationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSet = new VirtualMachineScaleSet("virtualMachineScaleSet", VirtualMachineScaleSetArgs.builder()
 *             .location("westus")
 *             .overprovision(true)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(3)
 *                 .name("Standard_DS1_v2")
 *                 .tier("Standard")
 *                 .build())
 *             .upgradePolicy(UpgradePolicyArgs.builder()
 *                 .mode("Manual")
 *                 .build())
 *             .virtualMachineProfile(VirtualMachineScaleSetVMProfileArgs.builder()
 *                 .capacityReservation(CapacityReservationProfileArgs.builder()
 *                     .capacityReservationGroup(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}")
 *                         .build())
 *                     .build())
 *                 .networkProfile(VirtualMachineScaleSetNetworkProfileArgs.builder()
 *                     .networkInterfaceConfigurations(VirtualMachineScaleSetNetworkConfigurationArgs.builder()
 *                         .enableIPForwarding(true)
 *                         .ipConfigurations(VirtualMachineScaleSetIPConfigurationArgs.builder()
 *                             .name("{vmss-name}")
 *                             .subnet(ApiEntityReferenceArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/{existing-virtual-network-name}/subnets/{existing-subnet-name}")
 *                                 .build())
 *                             .build())
 *                         .name("{vmss-name}")
 *                         .primary(true)
 *                         .build())
 *                     .build())
 *                 .osProfile(VirtualMachineScaleSetOSProfileArgs.builder()
 *                     .adminPassword("{your-password}")
 *                     .adminUsername("{your-username}")
 *                     .computerNamePrefix("{vmss-name}")
 *                     .build())
 *                 .storageProfile(VirtualMachineScaleSetStorageProfileArgs.builder()
 *                     .imageReference(ImageReferenceArgs.builder()
 *                         .offer("WindowsServer")
 *                         .publisher("MicrosoftWindowsServer")
 *                         .sku("2016-Datacenter")
 *                         .version("latest")
 *                         .build())
 *                     .osDisk(VirtualMachineScaleSetOSDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("FromImage")
 *                         .managedDisk(VirtualMachineScaleSetManagedDiskParametersArgs.builder()
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmScaleSetName("{vmss-name}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSet {vmss-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}
 * ```
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
 * @property automaticRepairsPolicy Policy for automatic repairs.
 * @property constrainedMaximumCapacity Optional property which must either be set to True or omitted.
 * @property doNotRunExtensionsOnOverprovisionedVMs When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
 * @property extendedLocation The extended location of the Virtual Machine Scale Set.
 * @property hostGroup Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
 * @property identity The identity of the virtual machine scale set, if configured.
 * @property location Resource location
 * @property orchestrationMode Specifies the orchestration mode for the virtual machine scale set.
 * @property overprovision Specifies whether the Virtual Machine Scale Set should be overprovisioned.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property platformFaultDomainCount Fault Domain count for each placement group.
 * @property priorityMixPolicy Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
 * @property resourceGroupName The name of the resource group.
 * @property scaleInPolicy Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
 * @property singlePlacementGroup When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
 * @property sku The virtual machine scale set sku.
 * @property spotRestorePolicy Specifies the Spot Restore properties for the virtual machine scale set.
 * @property tags Resource tags
 * @property upgradePolicy The upgrade policy.
 * @property virtualMachineProfile The virtual machine profile.
 * @property vmScaleSetName The name of the VM scale set to create or update.
 * @property zoneBalance Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
 * @property zones The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
 */
public data class VirtualMachineScaleSetArgs(
    public val additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null,
    public val automaticRepairsPolicy: Output<AutomaticRepairsPolicyArgs>? = null,
    public val constrainedMaximumCapacity: Output<Boolean>? = null,
    public val doNotRunExtensionsOnOverprovisionedVMs: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hostGroup: Output<SubResourceArgs>? = null,
    public val identity: Output<VirtualMachineScaleSetIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val orchestrationMode: Output<Either<String, OrchestrationMode>>? = null,
    public val overprovision: Output<Boolean>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val platformFaultDomainCount: Output<Int>? = null,
    public val priorityMixPolicy: Output<PriorityMixPolicyArgs>? = null,
    public val proximityPlacementGroup: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scaleInPolicy: Output<ScaleInPolicyArgs>? = null,
    public val singlePlacementGroup: Output<Boolean>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val spotRestorePolicy: Output<SpotRestorePolicyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upgradePolicy: Output<UpgradePolicyArgs>? = null,
    public val virtualMachineProfile: Output<VirtualMachineScaleSetVMProfileArgs>? = null,
    public val vmScaleSetName: Output<String>? = null,
    public val zoneBalance: Output<Boolean>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .automaticRepairsPolicy(
                automaticRepairsPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .constrainedMaximumCapacity(constrainedMaximumCapacity?.applyValue({ args0 -> args0 }))
            .doNotRunExtensionsOnOverprovisionedVMs(
                doNotRunExtensionsOnOverprovisionedVMs?.applyValue({ args0 ->
                    args0
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostGroup(hostGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .orchestrationMode(
                orchestrationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .overprovision(overprovision?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .platformFaultDomainCount(platformFaultDomainCount?.applyValue({ args0 -> args0 }))
            .priorityMixPolicy(priorityMixPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .proximityPlacementGroup(
                proximityPlacementGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scaleInPolicy(scaleInPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singlePlacementGroup(singlePlacementGroup?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spotRestorePolicy(spotRestorePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upgradePolicy(upgradePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualMachineProfile(
                virtualMachineProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmScaleSetName(vmScaleSetName?.applyValue({ args0 -> args0 }))
            .zoneBalance(zoneBalance?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VirtualMachineScaleSetArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetArgsBuilder internal constructor() {
    private var additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null

    private var automaticRepairsPolicy: Output<AutomaticRepairsPolicyArgs>? = null

    private var constrainedMaximumCapacity: Output<Boolean>? = null

    private var doNotRunExtensionsOnOverprovisionedVMs: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hostGroup: Output<SubResourceArgs>? = null

    private var identity: Output<VirtualMachineScaleSetIdentityArgs>? = null

    private var location: Output<String>? = null

    private var orchestrationMode: Output<Either<String, OrchestrationMode>>? = null

    private var overprovision: Output<Boolean>? = null

    private var plan: Output<PlanArgs>? = null

    private var platformFaultDomainCount: Output<Int>? = null

    private var priorityMixPolicy: Output<PriorityMixPolicyArgs>? = null

    private var proximityPlacementGroup: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scaleInPolicy: Output<ScaleInPolicyArgs>? = null

    private var singlePlacementGroup: Output<Boolean>? = null

    private var sku: Output<SkuArgs>? = null

    private var spotRestorePolicy: Output<SpotRestorePolicyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upgradePolicy: Output<UpgradePolicyArgs>? = null

    private var virtualMachineProfile: Output<VirtualMachineScaleSetVMProfileArgs>? = null

    private var vmScaleSetName: Output<String>? = null

    private var zoneBalance: Output<Boolean>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("ntjqwgoldtrxccie")
    public suspend fun additionalCapabilities(`value`: Output<AdditionalCapabilitiesArgs>) {
        this.additionalCapabilities = value
    }

    /**
     * @param value Policy for automatic repairs.
     */
    @JvmName("ynktbbuqpihdpiyx")
    public suspend fun automaticRepairsPolicy(`value`: Output<AutomaticRepairsPolicyArgs>) {
        this.automaticRepairsPolicy = value
    }

    /**
     * @param value Optional property which must either be set to True or omitted.
     */
    @JvmName("bcysdsiikjkukrgt")
    public suspend fun constrainedMaximumCapacity(`value`: Output<Boolean>) {
        this.constrainedMaximumCapacity = value
    }

    /**
     * @param value When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
     */
    @JvmName("ofqrsbkvsohhqsiv")
    public suspend fun doNotRunExtensionsOnOverprovisionedVMs(`value`: Output<Boolean>) {
        this.doNotRunExtensionsOnOverprovisionedVMs = value
    }

    /**
     * @param value The extended location of the Virtual Machine Scale Set.
     */
    @JvmName("nvwmqsitvqvnubbn")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
     */
    @JvmName("mkwbcepryxbgcmmk")
    public suspend fun hostGroup(`value`: Output<SubResourceArgs>) {
        this.hostGroup = value
    }

    /**
     * @param value The identity of the virtual machine scale set, if configured.
     */
    @JvmName("yojtvmwcokyerqjc")
    public suspend fun identity(`value`: Output<VirtualMachineScaleSetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("dptpabenumymnixy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the orchestration mode for the virtual machine scale set.
     */
    @JvmName("wpnqxovxjnoxpjdj")
    public suspend fun orchestrationMode(`value`: Output<Either<String, OrchestrationMode>>) {
        this.orchestrationMode = value
    }

    /**
     * @param value Specifies whether the Virtual Machine Scale Set should be overprovisioned.
     */
    @JvmName("vnpxgakdvequfqgp")
    public suspend fun overprovision(`value`: Output<Boolean>) {
        this.overprovision = value
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("iauwuudmjmwfhbxm")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Fault Domain count for each placement group.
     */
    @JvmName("fcvbgeipowdfmlvw")
    public suspend fun platformFaultDomainCount(`value`: Output<Int>) {
        this.platformFaultDomainCount = value
    }

    /**
     * @param value Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
     */
    @JvmName("ocdderuadykvsbxr")
    public suspend fun priorityMixPolicy(`value`: Output<PriorityMixPolicyArgs>) {
        this.priorityMixPolicy = value
    }

    /**
     * @param value Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("jskswuskjjhwjdgl")
    public suspend fun proximityPlacementGroup(`value`: Output<SubResourceArgs>) {
        this.proximityPlacementGroup = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mkbyfsqgkevthqsj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
     */
    @JvmName("ttcfbgkowjqpjsep")
    public suspend fun scaleInPolicy(`value`: Output<ScaleInPolicyArgs>) {
        this.scaleInPolicy = value
    }

    /**
     * @param value When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
     */
    @JvmName("ubtdynrgyffpafdo")
    public suspend fun singlePlacementGroup(`value`: Output<Boolean>) {
        this.singlePlacementGroup = value
    }

    /**
     * @param value The virtual machine scale set sku.
     */
    @JvmName("uoahbymxmbnjarxt")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Specifies the Spot Restore properties for the virtual machine scale set.
     */
    @JvmName("welwehdcqvmeplet")
    public suspend fun spotRestorePolicy(`value`: Output<SpotRestorePolicyArgs>) {
        this.spotRestorePolicy = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("dxvcmhwlphttfrio")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The upgrade policy.
     */
    @JvmName("awrwbvdcmeirwnux")
    public suspend fun upgradePolicy(`value`: Output<UpgradePolicyArgs>) {
        this.upgradePolicy = value
    }

    /**
     * @param value The virtual machine profile.
     */
    @JvmName("jadusrwxgfgvteul")
    public suspend fun virtualMachineProfile(`value`: Output<VirtualMachineScaleSetVMProfileArgs>) {
        this.virtualMachineProfile = value
    }

    /**
     * @param value The name of the VM scale set to create or update.
     */
    @JvmName("sgqxuyuyolkyjdsd")
    public suspend fun vmScaleSetName(`value`: Output<String>) {
        this.vmScaleSetName = value
    }

    /**
     * @param value Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
     */
    @JvmName("rvesqwaptaskfgcw")
    public suspend fun zoneBalance(`value`: Output<Boolean>) {
        this.zoneBalance = value
    }

    /**
     * @param value The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
     */
    @JvmName("smvococakngmytuj")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("tbhuurpgojtqcirb")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
     */
    @JvmName("sabnlvgwtxbrwsbk")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("axbiqdlclauxafbe")
    public suspend fun additionalCapabilities(`value`: AdditionalCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param argument Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("yshxvdtgfuhytwmm")
    public suspend
    fun additionalCapabilities(argument: suspend AdditionalCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = AdditionalCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.additionalCapabilities = mapped
    }

    /**
     * @param value Policy for automatic repairs.
     */
    @JvmName("dtncojtnkctqoxly")
    public suspend fun automaticRepairsPolicy(`value`: AutomaticRepairsPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticRepairsPolicy = mapped
    }

    /**
     * @param argument Policy for automatic repairs.
     */
    @JvmName("afqltgfqoygeunlg")
    public suspend
    fun automaticRepairsPolicy(argument: suspend AutomaticRepairsPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = AutomaticRepairsPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.automaticRepairsPolicy = mapped
    }

    /**
     * @param value Optional property which must either be set to True or omitted.
     */
    @JvmName("senitwquwsnotfle")
    public suspend fun constrainedMaximumCapacity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constrainedMaximumCapacity = mapped
    }

    /**
     * @param value When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
     */
    @JvmName("vypnamjusodlmhfg")
    public suspend fun doNotRunExtensionsOnOverprovisionedVMs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doNotRunExtensionsOnOverprovisionedVMs = mapped
    }

    /**
     * @param value The extended location of the Virtual Machine Scale Set.
     */
    @JvmName("oylmbbiunonuwrgp")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the Virtual Machine Scale Set.
     */
    @JvmName("iapdvixnkjtpcjuu")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
     */
    @JvmName("bybcsuxlgdoudncf")
    public suspend fun hostGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroup = mapped
    }

    /**
     * @param argument Specifies information about the dedicated host group that the virtual machine scale set resides in. Minimum api-version: 2020-06-01.
     */
    @JvmName("rxkyyrihdhiujdkd")
    public suspend fun hostGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostGroup = mapped
    }

    /**
     * @param value The identity of the virtual machine scale set, if configured.
     */
    @JvmName("lcpjhrlvbsyyxyqd")
    public suspend fun identity(`value`: VirtualMachineScaleSetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the virtual machine scale set, if configured.
     */
    @JvmName("sxgxvklfefdpanrl")
    public suspend
    fun identity(argument: suspend VirtualMachineScaleSetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("doasogsigdkxbqpt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the orchestration mode for the virtual machine scale set.
     */
    @JvmName("vrblslrneprpobbs")
    public suspend fun orchestrationMode(`value`: Either<String, OrchestrationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orchestrationMode = mapped
    }

    /**
     * @param value Specifies the orchestration mode for the virtual machine scale set.
     */
    @JvmName("snrnwofbylddyacw")
    public fun orchestrationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OrchestrationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orchestrationMode = mapped
    }

    /**
     * @param value Specifies the orchestration mode for the virtual machine scale set.
     */
    @JvmName("btnaycxexkjpekia")
    public fun orchestrationMode(`value`: OrchestrationMode) {
        val toBeMapped = Either.ofRight<String, OrchestrationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orchestrationMode = mapped
    }

    /**
     * @param value Specifies whether the Virtual Machine Scale Set should be overprovisioned.
     */
    @JvmName("xvbupjltwjpycelf")
    public suspend fun overprovision(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overprovision = mapped
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("ahhvmlmdryrgaids")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("jiuotrmjkjfflwrg")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Fault Domain count for each placement group.
     */
    @JvmName("wqqhadnphlagrwao")
    public suspend fun platformFaultDomainCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomainCount = mapped
    }

    /**
     * @param value Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
     */
    @JvmName("fpjaadbjkqmjakmc")
    public suspend fun priorityMixPolicy(`value`: PriorityMixPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priorityMixPolicy = mapped
    }

    /**
     * @param argument Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
     */
    @JvmName("itdrphdaajdtoblr")
    public suspend fun priorityMixPolicy(argument: suspend PriorityMixPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = PriorityMixPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.priorityMixPolicy = mapped
    }

    /**
     * @param value Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("mclninbqadxkblkv")
    public suspend fun proximityPlacementGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param argument Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("ocuwmaymiiulkmmh")
    public suspend fun proximityPlacementGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hittxtjwhwvbbedv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
     */
    @JvmName("sdxltvpbhwogschq")
    public suspend fun scaleInPolicy(`value`: ScaleInPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleInPolicy = mapped
    }

    /**
     * @param argument Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
     */
    @JvmName("cnrbrcgaomviqhhl")
    public suspend fun scaleInPolicy(argument: suspend ScaleInPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleInPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleInPolicy = mapped
    }

    /**
     * @param value When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
     */
    @JvmName("kdeanrhrktdxlmwo")
    public suspend fun singlePlacementGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singlePlacementGroup = mapped
    }

    /**
     * @param value The virtual machine scale set sku.
     */
    @JvmName("ftsffesgtroiioqm")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The virtual machine scale set sku.
     */
    @JvmName("tjcdxumdtuqjdify")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Specifies the Spot Restore properties for the virtual machine scale set.
     */
    @JvmName("gpaepybaajooyoui")
    public suspend fun spotRestorePolicy(`value`: SpotRestorePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotRestorePolicy = mapped
    }

    /**
     * @param argument Specifies the Spot Restore properties for the virtual machine scale set.
     */
    @JvmName("msvtmaxlyuefudit")
    public suspend fun spotRestorePolicy(argument: suspend SpotRestorePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SpotRestorePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spotRestorePolicy = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jcxfvsjbashmuyco")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("scocoxnceiagexpj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The upgrade policy.
     */
    @JvmName("adbtalivyoprmeks")
    public suspend fun upgradePolicy(`value`: UpgradePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradePolicy = mapped
    }

    /**
     * @param argument The upgrade policy.
     */
    @JvmName("uqdlumpvycimcyxr")
    public suspend fun upgradePolicy(argument: suspend UpgradePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = UpgradePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradePolicy = mapped
    }

    /**
     * @param value The virtual machine profile.
     */
    @JvmName("uefhbnumgdmldptd")
    public suspend fun virtualMachineProfile(`value`: VirtualMachineScaleSetVMProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineProfile = mapped
    }

    /**
     * @param argument The virtual machine profile.
     */
    @JvmName("grmidctlshdlhehl")
    public suspend
    fun virtualMachineProfile(argument: suspend VirtualMachineScaleSetVMProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetVMProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineProfile = mapped
    }

    /**
     * @param value The name of the VM scale set to create or update.
     */
    @JvmName("mbpqfkbvqjmtnbpj")
    public suspend fun vmScaleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScaleSetName = mapped
    }

    /**
     * @param value Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
     */
    @JvmName("nyrqclioosbwifcl")
    public suspend fun zoneBalance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneBalance = mapped
    }

    /**
     * @param value The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
     */
    @JvmName("pihxcqlhwnjetuhk")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
     */
    @JvmName("dbsuqmhvbuwdicek")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): VirtualMachineScaleSetArgs = VirtualMachineScaleSetArgs(
        additionalCapabilities = additionalCapabilities,
        automaticRepairsPolicy = automaticRepairsPolicy,
        constrainedMaximumCapacity = constrainedMaximumCapacity,
        doNotRunExtensionsOnOverprovisionedVMs = doNotRunExtensionsOnOverprovisionedVMs,
        extendedLocation = extendedLocation,
        hostGroup = hostGroup,
        identity = identity,
        location = location,
        orchestrationMode = orchestrationMode,
        overprovision = overprovision,
        plan = plan,
        platformFaultDomainCount = platformFaultDomainCount,
        priorityMixPolicy = priorityMixPolicy,
        proximityPlacementGroup = proximityPlacementGroup,
        resourceGroupName = resourceGroupName,
        scaleInPolicy = scaleInPolicy,
        singlePlacementGroup = singlePlacementGroup,
        sku = sku,
        spotRestorePolicy = spotRestorePolicy,
        tags = tags,
        upgradePolicy = upgradePolicy,
        virtualMachineProfile = virtualMachineProfile,
        vmScaleSetName = vmScaleSetName,
        zoneBalance = zoneBalance,
        zones = zones,
    )
}
