@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VirtualMachineScaleSetExtension].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineScaleSetExtensionArgs = VirtualMachineScaleSetExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineScaleSetExtensionArgsBuilder.() -> Unit) {
        val builder = VirtualMachineScaleSetExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineScaleSetExtension {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineScaleSetExtension(builtJavaResource)
    }
}

/**
 * Describes a Virtual Machine Scale Set Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### VirtualMachineScaleSetExtension_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetExtension = new AzureNative.Compute.VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         EnableAutomaticUpgrade = true,
 *         ForceUpdateTag = "aaaaaaaaa",
 *         Name = "{extension-name}",
 *         ProtectedSettings = null,
 *         ProvisionAfterExtensions = new[]
 *         {
 *             "aa",
 *         },
 *         Publisher = "{extension-Publisher}",
 *         ResourceGroupName = "rgcompute",
 *         Settings = null,
 *         SuppressFailures = true,
 *         Type = "{extension-Type}",
 *         TypeHandlerVersion = "{handler-version}",
 *         VmScaleSetName = "aaaaaaa",
 *         VmssExtensionName = "aaaaaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetExtension(ctx, "virtualMachineScaleSetExtension", &compute.VirtualMachineScaleSetExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 			ForceUpdateTag:          pulumi.String("aaaaaaaaa"),
 * 			Name:                    pulumi.String("{extension-name}"),
 * 			ProtectedSettings:       pulumi.Any(nil),
 * 			ProvisionAfterExtensions: pulumi.StringArray{
 * 				pulumi.String("aa"),
 * 			},
 * 			Publisher:          pulumi.String("{extension-Publisher}"),
 * 			ResourceGroupName:  pulumi.String("rgcompute"),
 * 			Settings:           pulumi.Any(nil),
 * 			SuppressFailures:   pulumi.Bool(true),
 * 			Type:               pulumi.String("{extension-Type}"),
 * 			TypeHandlerVersion: pulumi.String("{handler-version}"),
 * 			VmScaleSetName:     pulumi.String("aaaaaaa"),
 * 			VmssExtensionName:  pulumi.String("aaaaaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetExtension = new VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", VirtualMachineScaleSetExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .enableAutomaticUpgrade(true)
 *             .forceUpdateTag("aaaaaaaaa")
 *             .name("{extension-name}")
 *             .protectedSettings()
 *             .provisionAfterExtensions("aa")
 *             .publisher("{extension-Publisher}")
 *             .resourceGroupName("rgcompute")
 *             .settings()
 *             .suppressFailures(true)
 *             .type("{extension-Type}")
 *             .typeHandlerVersion("{handler-version}")
 *             .vmScaleSetName("aaaaaaa")
 *             .vmssExtensionName("aaaaaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineScaleSetExtension_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetExtension = new AzureNative.Compute.VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", new()
 *     {
 *         ResourceGroupName = "rgcompute",
 *         VmScaleSetName = "aaaaaaaaaaa",
 *         VmssExtensionName = "aaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetExtension(ctx, "virtualMachineScaleSetExtension", &compute.VirtualMachineScaleSetExtensionArgs{
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmScaleSetName:    pulumi.String("aaaaaaaaaaa"),
 * 			VmssExtensionName: pulumi.String("aaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetExtension = new VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", VirtualMachineScaleSetExtensionArgs.builder()
 *             .resourceGroupName("rgcompute")
 *             .vmScaleSetName("aaaaaaaaaaa")
 *             .vmssExtensionName("aaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetExtension {extension-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions/{vmssExtensionName}
 * ```
 */
public class VirtualMachineScaleSetExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension,
) : KotlinCustomResource(javaResource, VirtualMachineScaleSetExtensionMapper) {
    /**
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    public val enableAutomaticUpgrade: Output<Boolean>?
        get() = javaResource.enableAutomaticUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the extension.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    public val protectedSettings: Output<Any>?
        get() = javaResource.protectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extensions protected settings that are passed by reference, and consumed from key vault
     */
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceResponse>?
        get() = javaResource.protectedSettingsFromKeyVault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Collection of extension names after which this extension needs to be provisioned.
     */
    public val provisionAfterExtensions: Output<List<String>>?
        get() = javaResource.provisionAfterExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the extension handler publisher.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Json formatted public settings for the extension.
     */
    public val settings: Output<Any>?
        get() = javaResource.settings().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    public val suppressFailures: Output<Boolean>?
        get() = javaResource.suppressFailures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the script handler.
     */
    public val typeHandlerVersion: Output<String>?
        get() = javaResource.typeHandlerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualMachineScaleSetExtensionMapper :
    ResourceMapper<VirtualMachineScaleSetExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineScaleSetExtension =
        VirtualMachineScaleSetExtension(
            javaResource as
                com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension,
        )
}

/**
 * @see [VirtualMachineScaleSetExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineScaleSetExtension].
 */
public suspend fun virtualMachineScaleSetExtension(
    name: String,
    block: suspend VirtualMachineScaleSetExtensionResourceBuilder.() -> Unit,
):
    VirtualMachineScaleSetExtension {
    val builder = VirtualMachineScaleSetExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineScaleSetExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineScaleSetExtension(name: String): VirtualMachineScaleSetExtension {
    val builder = VirtualMachineScaleSetExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
