@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse.Companion.toKotlin as keyVaultSecretReferenceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse.Companion.toKotlin as virtualMachineExtensionInstanceViewResponseToKotlin

/**
 * Builder for [VirtualMachineScaleSetVMExtension].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineScaleSetVMExtensionArgs = VirtualMachineScaleSetVMExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineScaleSetVMExtensionArgsBuilder.() -> Unit) {
        val builder = VirtualMachineScaleSetVMExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineScaleSetVMExtension {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineScaleSetVMExtension(builtJavaResource)
    }
}

/**
 * Describes a VMSS VM Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-12-01, 2021-11-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create VirtualMachineScaleSet VM extension.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVMExtension = new AzureNative.Compute.VirtualMachineScaleSetVMExtension("virtualMachineScaleSetVMExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         InstanceId = "0",
 *         Publisher = "extPublisher",
 *         ResourceGroupName = "myResourceGroup",
 *         Settings = new Dictionary<string, object?>
 *         {
 *             ["UserName"] = "xyz@microsoft.com",
 *         },
 *         Type = "extType",
 *         TypeHandlerVersion = "1.2",
 *         VmExtensionName = "myVMExtension",
 *         VmScaleSetName = "myvmScaleSet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetVMExtension(ctx, "virtualMachineScaleSetVMExtension", &compute.VirtualMachineScaleSetVMExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			InstanceId:              pulumi.String("0"),
 * 			Publisher:               pulumi.String("extPublisher"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Settings: pulumi.Any(map[string]interface{}{
 * 				"UserName": "xyz@microsoft.com",
 * 			}),
 * 			Type:               pulumi.String("extType"),
 * 			TypeHandlerVersion: pulumi.String("1.2"),
 * 			VmExtensionName:    pulumi.String("myVMExtension"),
 * 			VmScaleSetName:     pulumi.String("myvmScaleSet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVMExtension = new VirtualMachineScaleSetVMExtension("virtualMachineScaleSetVMExtension", VirtualMachineScaleSetVMExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .instanceId("0")
 *             .publisher("extPublisher")
 *             .resourceGroupName("myResourceGroup")
 *             .settings(Map.of("UserName", "xyz@microsoft.com"))
 *             .type("extType")
 *             .typeHandlerVersion("1.2")
 *             .vmExtensionName("myVMExtension")
 *             .vmScaleSetName("myvmScaleSet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetVMExtension myVMExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}
 * ```
 */
public class VirtualMachineScaleSetVMExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension,
) : KotlinCustomResource(javaResource, VirtualMachineScaleSetVMExtensionMapper) {
    /**
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    public val enableAutomaticUpgrade: Output<Boolean>?
        get() = javaResource.enableAutomaticUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine extension instance view.
     */
    public val instanceView: Output<VirtualMachineExtensionInstanceViewResponse>?
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineExtensionInstanceViewResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the extension.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the extension.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    public val protectedSettings: Output<Any>?
        get() = javaResource.protectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extensions protected settings that are passed by reference, and consumed from key vault
     */
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceResponse>?
        get() = javaResource.protectedSettingsFromKeyVault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyVaultSecretReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Collection of extension names after which this extension needs to be provisioned.
     */
    public val provisionAfterExtensions: Output<List<String>>?
        get() = javaResource.provisionAfterExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the extension handler publisher.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Json formatted public settings for the extension.
     */
    public val settings: Output<Any>?
        get() = javaResource.settings().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    public val suppressFailures: Output<Boolean>?
        get() = javaResource.suppressFailures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the script handler.
     */
    public val typeHandlerVersion: Output<String>?
        get() = javaResource.typeHandlerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualMachineScaleSetVMExtensionMapper :
    ResourceMapper<VirtualMachineScaleSetVMExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineScaleSetVMExtension =
        VirtualMachineScaleSetVMExtension(
            javaResource as
                com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension,
        )
}

/**
 * @see [VirtualMachineScaleSetVMExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineScaleSetVMExtension].
 */
public suspend fun virtualMachineScaleSetVMExtension(
    name: String,
    block: suspend VirtualMachineScaleSetVMExtensionResourceBuilder.() -> Unit,
):
    VirtualMachineScaleSetVMExtension {
    val builder = VirtualMachineScaleSetVMExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineScaleSetVMExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineScaleSetVMExtension(name: String): VirtualMachineScaleSetVMExtension {
    val builder = VirtualMachineScaleSetVMExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
