@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommandArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandInputParameterArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandInputParameterArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandManagedIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RunCommandManagedIdentityArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineRunCommandScriptSourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineRunCommandScriptSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine run command.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create VirtualMachineScaleSet VM run command.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVMRunCommand = new AzureNative.Compute.VirtualMachineScaleSetVMRunCommand("virtualMachineScaleSetVMRunCommand", new()
 *     {
 *         AsyncExecution = false,
 *         ErrorBlobManagedIdentity = null,
 *         ErrorBlobUri = "https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt",
 *         InstanceId = "0",
 *         Location = "West US",
 *         OutputBlobManagedIdentity = new AzureNative.Compute.Inputs.RunCommandManagedIdentityArgs
 *         {
 *             ClientId = "22d35efb-0c99-4041-8c5b-6d24db33a69a",
 *         },
 *         OutputBlobUri = "https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt",
 *         Parameters = new[]
 *         {
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param1",
 *                 Value = "value1",
 *             },
 *             new AzureNative.Compute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param2",
 *                 Value = "value2",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RunAsPassword = "<runAsPassword>",
 *         RunAsUser = "user1",
 *         RunCommandName = "myRunCommand",
 *         Source = new AzureNative.Compute.Inputs.VirtualMachineRunCommandScriptSourceArgs
 *         {
 *             ScriptUri = "https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1",
 *             ScriptUriManagedIdentity = new AzureNative.Compute.Inputs.RunCommandManagedIdentityArgs
 *             {
 *                 ObjectId = "4231e4d2-33e4-4e23-96b2-17888afa6072",
 *             },
 *         },
 *         TimeoutInSeconds = 3600,
 *         TreatFailureAsDeploymentFailure = true,
 *         VmScaleSetName = "myvmScaleSet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetVMRunCommand(ctx, "virtualMachineScaleSetVMRunCommand", &compute.VirtualMachineScaleSetVMRunCommandArgs{
 * 			AsyncExecution:           pulumi.Bool(false),
 * 			ErrorBlobManagedIdentity: nil,
 * 			ErrorBlobUri:             pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt"),
 * 			InstanceId:               pulumi.String("0"),
 * 			Location:                 pulumi.String("West US"),
 * 			OutputBlobManagedIdentity: &compute.RunCommandManagedIdentityArgs{
 * 				ClientId: pulumi.String("22d35efb-0c99-4041-8c5b-6d24db33a69a"),
 * 			},
 * 			OutputBlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt"),
 * 			Parameters: compute.RunCommandInputParameterArray{
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param1"),
 * 					Value: pulumi.String("value1"),
 * 				},
 * 				&compute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param2"),
 * 					Value: pulumi.String("value2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunAsPassword:     pulumi.String("<runAsPassword>"),
 * 			RunAsUser:         pulumi.String("user1"),
 * 			RunCommandName:    pulumi.String("myRunCommand"),
 * 			Source: &compute.VirtualMachineRunCommandScriptSourceArgs{
 * 				ScriptUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1"),
 * 				ScriptUriManagedIdentity: &compute.RunCommandManagedIdentityArgs{
 * 					ObjectId: pulumi.String("4231e4d2-33e4-4e23-96b2-17888afa6072"),
 * 				},
 * 			},
 * 			TimeoutInSeconds:                pulumi.Int(3600),
 * 			TreatFailureAsDeploymentFailure: pulumi.Bool(true),
 * 			VmScaleSetName:                  pulumi.String("myvmScaleSet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommand;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommandArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs;
 * import com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualMachineRunCommandScriptSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVMRunCommand = new VirtualMachineScaleSetVMRunCommand("virtualMachineScaleSetVMRunCommand", VirtualMachineScaleSetVMRunCommandArgs.builder()
 *             .asyncExecution(false)
 *             .errorBlobManagedIdentity()
 *             .errorBlobUri("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt")
 *             .instanceId("0")
 *             .location("West US")
 *             .outputBlobManagedIdentity(RunCommandManagedIdentityArgs.builder()
 *                 .clientId("22d35efb-0c99-4041-8c5b-6d24db33a69a")
 *                 .build())
 *             .outputBlobUri("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt")
 *             .parameters(
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param1")
 *                     .value("value1")
 *                     .build(),
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param2")
 *                     .value("value2")
 *                     .build())
 *             .resourceGroupName("myResourceGroup")
 *             .runAsPassword("<runAsPassword>")
 *             .runAsUser("user1")
 *             .runCommandName("myRunCommand")
 *             .source(VirtualMachineRunCommandScriptSourceArgs.builder()
 *                 .scriptUri("https://mystorageaccount.blob.core.windows.net/scriptcontainer/MyScript.ps1")
 *                 .scriptUriManagedIdentity(RunCommandManagedIdentityArgs.builder()
 *                     .objectId("4231e4d2-33e4-4e23-96b2-17888afa6072")
 *                     .build())
 *                 .build())
 *             .timeoutInSeconds(3600)
 *             .treatFailureAsDeploymentFailure(true)
 *             .vmScaleSetName("myvmScaleSet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetVMRunCommand myRunCommand /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}
 * ```
 * @property asyncExecution Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
 * @property errorBlobManagedIdentity User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property errorBlobUri Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
 * @property instanceId The instance ID of the virtual machine.
 * @property location Resource location
 * @property outputBlobManagedIdentity User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property outputBlobUri Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
 * @property parameters The parameters used by the script.
 * @property protectedParameters The parameters used by the script.
 * @property resourceGroupName The name of the resource group.
 * @property runAsPassword Specifies the user account password on the VM when executing the run command.
 * @property runAsUser Specifies the user account on the VM when executing the run command.
 * @property runCommandName The name of the virtual machine run command.
 * @property source The source of the run command script.
 * @property tags Resource tags
 * @property timeoutInSeconds The timeout in seconds to execute the run command.
 * @property treatFailureAsDeploymentFailure Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class VirtualMachineScaleSetVMRunCommandArgs(
    public val asyncExecution: Output<Boolean>? = null,
    public val errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val errorBlobUri: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val outputBlobUri: Output<String>? = null,
    public val parameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsPassword: Output<String>? = null,
    public val runAsUser: Output<String>? = null,
    public val runCommandName: Output<String>? = null,
    public val source: Output<VirtualMachineRunCommandScriptSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
    public val treatFailureAsDeploymentFailure: Output<Boolean>? = null,
    public val vmScaleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommandArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommandArgs =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetVMRunCommandArgs.builder()
            .asyncExecution(asyncExecution?.applyValue({ args0 -> args0 }))
            .errorBlobManagedIdentity(
                errorBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .errorBlobUri(errorBlobUri?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .outputBlobManagedIdentity(
                outputBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputBlobUri(outputBlobUri?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protectedParameters(
                protectedParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsPassword(runAsPassword?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 }))
            .runCommandName(runCommandName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .treatFailureAsDeploymentFailure(treatFailureAsDeploymentFailure?.applyValue({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMRunCommandArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMRunCommandArgsBuilder internal constructor() {
    private var asyncExecution: Output<Boolean>? = null

    private var errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var errorBlobUri: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var location: Output<String>? = null

    private var outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var outputBlobUri: Output<String>? = null

    private var parameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsPassword: Output<String>? = null

    private var runAsUser: Output<String>? = null

    private var runCommandName: Output<String>? = null

    private var source: Output<VirtualMachineRunCommandScriptSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeoutInSeconds: Output<Int>? = null

    private var treatFailureAsDeploymentFailure: Output<Boolean>? = null

    private var vmScaleSetName: Output<String>? = null

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
     */
    @JvmName("otvbroqbkeqxmvfm")
    public suspend fun asyncExecution(`value`: Output<Boolean>) {
        this.asyncExecution = value
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("umhxrrwhqchpbafr")
    public suspend fun errorBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.errorBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("attwwatuvxygcvyy")
    public suspend fun errorBlobUri(`value`: Output<String>) {
        this.errorBlobUri = value
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("jwwpiunyuoaxchlh")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("gdnafjbtotrdmhfl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("dktutrlrepbcsuch")
    public suspend fun outputBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.outputBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("wuvqlvjkmdovreqp")
    public suspend fun outputBlobUri(`value`: Output<String>) {
        this.outputBlobUri = value
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("wmmtysyddikiiloi")
    public suspend fun parameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("xgkjibgpupkdufec")
    public suspend fun parameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("wmgtngevmqimdnmb")
    public suspend fun parameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("gbgwcpmyawlxxyod")
    public suspend fun protectedParameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.protectedParameters = value
    }

    @JvmName("usbgjiunkjogudmk")
    public suspend fun protectedParameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.protectedParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("uxfjbilfbjrdqfxv")
    public suspend fun protectedParameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.protectedParameters = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pssvuppralhmfenf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the user account password on the VM when executing the run command.
     */
    @JvmName("oxlotbfrmyvtdlfi")
    public suspend fun runAsPassword(`value`: Output<String>) {
        this.runAsPassword = value
    }

    /**
     * @param value Specifies the user account on the VM when executing the run command.
     */
    @JvmName("ufcwyciuqubuksgp")
    public suspend fun runAsUser(`value`: Output<String>) {
        this.runAsUser = value
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("qmpspmpcklgcntpk")
    public suspend fun runCommandName(`value`: Output<String>) {
        this.runCommandName = value
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("kldfadbastdwealf")
    public suspend fun source(`value`: Output<VirtualMachineRunCommandScriptSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("quejqdogewtbveri")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("wjtnvuqtdlgalusc")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    @JvmName("tuvwsiqueahkualu")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Output<Boolean>) {
        this.treatFailureAsDeploymentFailure = value
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("oqtuljwrgguirwks")
    public suspend fun vmScaleSetName(`value`: Output<String>) {
        this.vmScaleSetName = value
    }

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
     */
    @JvmName("owknwhrkshaujqug")
    public suspend fun asyncExecution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncExecution = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("xeacgbskgjxmfliu")
    public suspend fun errorBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("pwayqtcpnhxmlhbp")
    public suspend
    fun errorBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("ktrafnonjhcacsxe")
    public suspend fun errorBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobUri = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("eyosjjyomlrephfg")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("qehjlcdhfcvtrvto")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("edvpurwennrkxjwp")
    public suspend fun outputBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("uwwoquedgjfnuxdq")
    public suspend
    fun outputBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("glfsovvgupcjouvs")
    public suspend fun outputBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobUri = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("erlfgnitlkknanil")
    public suspend fun parameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("wydcjjhpwwxcmyki")
    public suspend
    fun parameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("ldvcpvloyrmnhtcu")
    public suspend fun parameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("jlyyqlobynflrvbj")
    public suspend fun parameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("ixkjsyjbwblhmvap")
    public suspend fun parameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("froqdhifgnvvgivw")
    public suspend fun protectedParameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("iexwhvopsgxlnxfv")
    public suspend
    fun protectedParameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("spikvksthaqyutjc")
    public suspend fun protectedParameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("eiiruknwppobafhv")
    public suspend
    fun protectedParameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("ugtoxstjmlioahxa")
    public suspend fun protectedParameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cuxokrbnltjwknam")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the user account password on the VM when executing the run command.
     */
    @JvmName("igreilrnirsrxpbm")
    public suspend fun runAsPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsPassword = mapped
    }

    /**
     * @param value Specifies the user account on the VM when executing the run command.
     */
    @JvmName("aiyccdnfddsmcyyh")
    public suspend fun runAsUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("yhyeqdfchgmytcwx")
    public suspend fun runCommandName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runCommandName = mapped
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("mhpwrcgseoseavdu")
    public suspend fun source(`value`: VirtualMachineRunCommandScriptSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of the run command script.
     */
    @JvmName("mkgpxsswpylxkjfu")
    public suspend
    fun source(argument: suspend VirtualMachineRunCommandScriptSourceArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineRunCommandScriptSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("bbigpcbcwmgxfbnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("vjwmmrymihdvjaqa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("bmntgtgcdxlftytp")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value Optional. If set to true, any failure in the script will fail the deployment and ProvisioningState will be marked as Failed. If set to false, ProvisioningState would only reflect whether the run command was run or not by the extensions platform, it would not indicate whether script failed in case of script failures. See instance view of run command in case of script failures to see executionMessage, output, error: https://aka.ms/runcommandmanaged#get-execution-status-and-results
     */
    @JvmName("pxsyqmmuptpduncw")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.treatFailureAsDeploymentFailure = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("aitnuoufvprjmboo")
    public suspend fun vmScaleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScaleSetName = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMRunCommandArgs =
        VirtualMachineScaleSetVMRunCommandArgs(
            asyncExecution = asyncExecution,
            errorBlobManagedIdentity = errorBlobManagedIdentity,
            errorBlobUri = errorBlobUri,
            instanceId = instanceId,
            location = location,
            outputBlobManagedIdentity = outputBlobManagedIdentity,
            outputBlobUri = outputBlobUri,
            parameters = parameters,
            protectedParameters = protectedParameters,
            resourceGroupName = resourceGroupName,
            runAsPassword = runAsPassword,
            runAsUser = runAsUser,
            runCommandName = runCommandName,
            source = source,
            tags = tags,
            timeoutInSeconds = timeoutInSeconds,
            treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure,
            vmScaleSetName = vmScaleSetName,
        )
}
