@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
 */
public enum class CachingTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.CachingTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.CachingTypes> {
    None(com.pulumi.azurenative.compute.enums.CachingTypes.None),
    ReadOnly(com.pulumi.azurenative.compute.enums.CachingTypes.ReadOnly),
    ReadWrite(com.pulumi.azurenative.compute.enums.CachingTypes.ReadWrite),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.CachingTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.CachingTypes): CachingTypes =
            CachingTypes.values().first { it.javaValue == javaType }
    }
}
