@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This enumerates the possible sources of a disk's creation.
 */
public enum class DiskCreateOption(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskCreateOption,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskCreateOption> {
    /**
     * Create an empty data disk of a size given by diskSizeGB.
     */
    Empty(com.pulumi.azurenative.compute.enums.DiskCreateOption.Empty),

    /**
     * Disk will be attached to a VM.
     */
    Attach(com.pulumi.azurenative.compute.enums.DiskCreateOption.Attach),

    /**
     * Create a new disk from a platform image specified by the given imageReference or galleryImageReference.
     */
    FromImage(com.pulumi.azurenative.compute.enums.DiskCreateOption.FromImage),

    /**
     * Create a disk by importing from a blob specified by a sourceUri in a storage account specified by storageAccountId.
     */
    Import(com.pulumi.azurenative.compute.enums.DiskCreateOption.Import),

    /**
     * Create a new disk or snapshot by copying from a disk or snapshot specified by the given sourceResourceId.
     */
    Copy(com.pulumi.azurenative.compute.enums.DiskCreateOption.Copy),

    /**
     * Create a new disk by copying from a backup recovery point.
     */
    Restore(com.pulumi.azurenative.compute.enums.DiskCreateOption.Restore),

    /**
     * Create a new disk by obtaining a write token and using it to directly upload the contents of the disk.
     */
    Upload(com.pulumi.azurenative.compute.enums.DiskCreateOption.Upload),

    /**
     * Create a new disk by using a deep copy process, where the resource creation is considered complete only after all data has been copied from the source.
     */
    CopyStart(com.pulumi.azurenative.compute.enums.DiskCreateOption.CopyStart),

    /**
     * Similar to Import create option. Create a new Trusted Launch VM or Confidential VM supported disk by importing additional blob for VM guest state specified by securityDataUri in storage account specified by storageAccountId
     */
    ImportSecure(com.pulumi.azurenative.compute.enums.DiskCreateOption.ImportSecure),

    /**
     * Similar to Upload create option. Create a new Trusted Launch VM or Confidential VM supported disk and upload using write token in both disk and VM guest state
     */
    UploadPreparedSecure(com.pulumi.azurenative.compute.enums.DiskCreateOption.UploadPreparedSecure),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskCreateOption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskCreateOption):
            DiskCreateOption = DiskCreateOption.values().first { it.javaValue == javaType }
    }
}
