@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
 */
public enum class HyperVGenerationTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.HyperVGenerationTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.HyperVGenerationTypes> {
    V1(com.pulumi.azurenative.compute.enums.HyperVGenerationTypes.V1),
    V2(com.pulumi.azurenative.compute.enums.HyperVGenerationTypes.V2),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.HyperVGenerationTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.HyperVGenerationTypes):
            HyperVGenerationTypes = HyperVGenerationTypes.values().first { it.javaValue == javaType }
    }
}
