@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
 */
public enum class UpgradeMode(
    public val javaValue: com.pulumi.azurenative.compute.enums.UpgradeMode,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.UpgradeMode> {
    Automatic(com.pulumi.azurenative.compute.enums.UpgradeMode.Automatic),
    Manual(com.pulumi.azurenative.compute.enums.UpgradeMode.Manual),
    Rolling(com.pulumi.azurenative.compute.enums.UpgradeMode.Rolling),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.UpgradeMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.UpgradeMode): UpgradeMode =
            UpgradeMode.values().first { it.javaValue == javaType }
    }
}
